/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuanmomo.mybatis.mbg.table;

import com.github.yuanmomo.mybatis.mbg.util.PropertiesUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class TableXMLPrinter {
    protected static boolean isPrintSchema;

    public static List<String> print(String propertiesFile, String ... dbSchemaArray) throws IOException {
        Properties properties = PropertiesUtil.load(propertiesFile);
        if (ArrayUtils.isEmpty((Object[])dbSchemaArray)) {
            return Collections.emptyList();
        }
        if (!isPrintSchema && dbSchemaArray.length > 1) {
            isPrintSchema = true;
        }
        String driver = PropertiesUtil.getStringProp(properties, "driver");
        String url = PropertiesUtil.getStringProp(properties, "url");
        String username = PropertiesUtil.getStringProp(properties, "username");
        String password = PropertiesUtil.getStringProp(properties, "password");
        ArrayList<String> allDbSchema = new ArrayList<String>();
        for (String db : dbSchemaArray) {
            List<String> single = TableXMLPrinter.printTables(db, driver, url, username, password);
            if (single == null || single.size() <= 0) continue;
            allDbSchema.addAll(single);
        }
        return allDbSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> printTables(String schema, String driver, String url, String user, String password) {
        ArrayList<String> output = new ArrayList<String>();
        Connection con = null;
        ResultSet tableListRs = null;
        ResultSet columListRS = null;
        Statement psmt = null;
        try {
            Class.forName(driver);
            con = DriverManager.getConnection(url, user, password);
            DatabaseMetaData metadata = con.getMetaData();
            tableListRs = metadata.getTables(null, schema, "%", new String[]{"TABLE"});
            while (tableListRs.next()) {
                String tableName = tableListRs.getString(3);
                String javaBeanName = JavaBeansUtil.getCamelCaseString((String)tableName, (boolean)true);
                output.add(String.format("\t\t<table tableName=\"%s\" domainObjectName=\"%s\">", tableName, javaBeanName));
                if (isPrintSchema) {
                    output.add(String.format("\t\t\t<property name=\"runtimeSchema\" value=\"%s\"/>", schema));
                }
                psmt = con.prepareStatement("desc " + tableName);
                columListRS = psmt.executeQuery();
                while (columListRS.next()) {
                    String extra = columListRS.getString("Extra");
                    if (!extra.equalsIgnoreCase("auto_increment")) continue;
                    String col = columListRS.getString("Field").toLowerCase();
                    output.add("\t\t\t<generatedKey column=\"" + col + "\" sqlStatement=\"MySql\" identity=\"true\"/>");
                }
                output.add("\t\t</table>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                psmt.close();
                columListRS.close();
                tableListRs.close();
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableXMLPrinter)) {
            return false;
        }
        TableXMLPrinter other = (TableXMLPrinter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableXMLPrinter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "TableXMLPrinter()";
    }
}

