/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuanmomo.mybatis.mbg.util;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;

public class JavaFilesMergeUtil
extends DefaultShellCallback {
    private boolean overwrite;
    private boolean isMergeSupported;

    public JavaFilesMergeUtil(boolean overwrite) {
        super(overwrite);
    }

    public JavaFilesMergeUtil(boolean overwrite, boolean isMergeSupported) {
        super(overwrite);
        this.isMergeSupported = isMergeSupported;
    }

    public void refreshProject(String project) {
    }

    public boolean isMergeSupported() {
        return this.isMergeSupported;
    }

    public boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public String mergeJavaFile(String newFileSource, File existingFile, String[] javadocTags, String fileEncoding) throws ShellException {
        Javadoc javadoc;
        NodeWithJavadoc field;
        Optional javadocOptional;
        NodeList members;
        FileInputStream existingFileInputStream = null;
        try {
            existingFileInputStream = new FileInputStream(existingFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        CompilationUnit newFileCU = JavaParser.parse((String)newFileSource);
        CompilationUnit existingFileCU = JavaParser.parse((InputStream)existingFileInputStream);
        NodeList newImportList = newFileCU.getImports();
        NodeList existingImportList = existingFileCU.getImports();
        if (existingImportList == null) {
            existingImportList = new NodeList();
        }
        if (newImportList != null && newImportList.size() > 0) {
            for (Iterator newImportDeclaration : newImportList) {
                boolean exists = false;
                for (ImportDeclaration existImportDeclaration : existingImportList) {
                    if (!existImportDeclaration.getNameAsString().equals(newImportDeclaration.getNameAsString())) continue;
                    exists = true;
                }
                if (exists) continue;
                existingImportList.add((Node)newImportDeclaration);
            }
        }
        NodeList existingTypes = existingFileCU.getTypes();
        for (TypeDeclaration type : existingTypes) {
            members = type.getMembers();
            Iterator iterator = members.iterator();
            while (iterator.hasNext()) {
                boolean isMBGMethod = false;
                BodyDeclaration member = (BodyDeclaration)iterator.next();
                if ((member instanceof FieldDeclaration || member instanceof MethodDeclaration || member instanceof ClassOrInterfaceDeclaration || member instanceof ConstructorDeclaration) && (javadocOptional = (field = (NodeWithJavadoc)member).getJavadoc()) != null && javadocOptional.isPresent() && (javadoc = (Javadoc)javadocOptional.get()) != null && javadoc.getBlockTags() != null && javadoc.getBlockTags().size() > 0) {
                    for (JavadocBlockTag javadocBlockTag : javadoc.getBlockTags()) {
                        if (!javadocBlockTag.toText().contains("@mbg.generated")) continue;
                        if (member instanceof MethodDeclaration) {
                            isMBGMethod = true;
                        }
                        iterator.remove();
                    }
                }
                if (isMBGMethod || !(member instanceof MethodDeclaration)) continue;
                Optional selectAnnotation = member.getAnnotationByName(Select.class.getSimpleName());
                Optional resultsAnnotation = member.getAnnotationByName(Results.class.getSimpleName());
                if (!selectAnnotation.isPresent() || !resultsAnnotation.isPresent() || !JavaFilesMergeUtil.isContainsAnnotation(((AnnotationExpr)selectAnnotation.get()).getChildNodes(), "ALL_COLUMN_FIELDS")) continue;
                ((AnnotationExpr)resultsAnnotation.get()).remove();
                BodyDeclaration selectByExample = JavaFilesMergeUtil.findMBGMethod(newFileCU, "selectByPrimaryKey");
                Optional newResultsAnnotation = selectByExample.getAnnotationByName(Results.class.getSimpleName());
                if (!newResultsAnnotation.isPresent()) continue;
                member.addAnnotation((AnnotationExpr)newResultsAnnotation.get());
            }
        }
        NodeList newTypes = newFileCU.getTypes();
        for (int i = 0; i < newTypes.size(); ++i) {
            members = ((TypeDeclaration)newTypes.get(i)).getMembers();
            NodeList existMembers = ((TypeDeclaration)existingTypes.get(i)).getMembers();
            for (BodyDeclaration member : members) {
                if (!(member instanceof FieldDeclaration) && !(member instanceof MethodDeclaration) && !(member instanceof ClassOrInterfaceDeclaration) && !(member instanceof ConstructorDeclaration) || !(javadocOptional = (field = (NodeWithJavadoc)member).getJavadoc()).isPresent() || (javadoc = (Javadoc)javadocOptional.get()) == null || javadoc.getBlockTags() == null || javadoc.getBlockTags().size() <= 0) continue;
                for (JavadocBlockTag javadocBlockTag : javadoc.getBlockTags()) {
                    if (!javadocBlockTag.toText().contains("@mbg.generated")) continue;
                    existMembers.add((Node)member);
                }
            }
        }
        return existingFileCU.toString();
    }

    private static boolean isContainsAnnotation(List<Node> childNodes, String target) {
        if (StringUtils.isBlank((CharSequence)target)) {
            return false;
        }
        if (childNodes != null && childNodes.size() > 0) {
            for (Node childNode : childNodes) {
                if (childNode.getChildNodes() != null && childNode.getChildNodes().size() > 1) {
                    return JavaFilesMergeUtil.isContainsAnnotation(childNode.getChildNodes(), target);
                }
                if (!childNode.toString().equals(target)) continue;
                return true;
            }
        }
        return false;
    }

    private static BodyDeclaration findMBGMethod(CompilationUnit fileCU, String target) {
        NodeList newTypes = fileCU.getTypes();
        for (int i = 0; i < newTypes.size(); ++i) {
            List methods = ((TypeDeclaration)newTypes.get(i)).getMethodsByName(target);
            if (methods == null || methods.size() <= 0) continue;
            for (MethodDeclaration method : methods) {
                Javadoc javadoc;
                MethodDeclaration field = method;
                Optional javadocOptional = field.getJavadoc();
                if (javadocOptional == null || !javadocOptional.isPresent() || (javadoc = (Javadoc)javadocOptional.get()) == null || javadoc.getBlockTags() == null || javadoc.getBlockTags().size() <= 0) continue;
                for (JavadocBlockTag javadocBlockTag : javadoc.getBlockTags()) {
                    if (!javadocBlockTag.toText().contains("@mbg.generated")) continue;
                    return method;
                }
            }
        }
        return null;
    }
}

