/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.autoconfigure;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusLanguageDriverAutoConfiguration;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.github.yulichang.autoconfigure.MybatisPlusJoinProperties;
import com.github.yulichang.autoconfigure.conditional.JoinSqlInjectorCondition;
import com.github.yulichang.autoconfigure.consumer.MybatisPlusJoinIfExistsConsumer;
import com.github.yulichang.autoconfigure.consumer.MybatisPlusJoinPropertiesConsumer;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.config.MPJInterceptorConfig;
import com.github.yulichang.extension.mapping.config.MappingConfig;
import com.github.yulichang.injector.MPJSqlInjector;
import com.github.yulichang.interceptor.MPJInterceptor;
import com.github.yulichang.toolkit.SpringContentUtils;
import com.github.yulichang.wrapper.interfaces.MBiPredicate;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@EnableConfigurationProperties(value={MybatisPlusJoinProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MybatisPlusLanguageDriverAutoConfiguration.class})
public class MybatisPlusJoinAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MybatisPlusJoinAutoConfiguration.class);
    private final MybatisPlusJoinProperties properties;

    public MybatisPlusJoinAutoConfiguration(MybatisPlusJoinProperties properties, ObjectProvider<MybatisPlusJoinPropertiesConsumer> propertiesConsumers, ObjectProvider<MybatisPlusJoinIfExistsConsumer> IfExistsConsumers) {
        this.properties = Optional.ofNullable((MybatisPlusJoinPropertiesConsumer)propertiesConsumers.getIfAvailable()).map(c -> c.config(properties)).orElse(properties);
        ConfigProperties.banner = this.properties.getBanner();
        ConfigProperties.msCache = this.properties.isMsCache();
        ConfigProperties.tableAlias = this.properties.getTableAlias();
        ConfigProperties.joinPrefix = this.properties.getJoinPrefix();
        ConfigProperties.logicDelType = this.properties.getLogicDelType();
        ConfigProperties.subQueryAlias = this.properties.getSubQueryAlias();
        ConfigProperties.subTableLogic = this.properties.getSubTableLogic();
        ConfigProperties.mappingMaxCount = this.properties.getMappingMaxCount();
        ConfigProperties.Convert.IfExists = this.properties.getIfExists();
        ConfigProperties.ifExists = Optional.ofNullable((MybatisPlusJoinIfExistsConsumer)IfExistsConsumers.getIfAvailable()).map(m -> m).orElse((MBiPredicate & Serializable)(val, key) -> ConfigProperties.Convert.IfExists.test(val));
        MybatisPlusJoinAutoConfiguration.info("mybatis plus join properties config complete");
    }

    @Bean
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    public MPJInterceptor mpjInterceptor() {
        return new MPJInterceptor();
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    public MPJInterceptorConfig mpjInterceptorConfig(List<SqlSessionFactory> sqlSessionFactoryList) {
        return new MPJInterceptorConfig(sqlSessionFactoryList, this.properties.getBanner());
    }

    @Bean
    @Primary
    @JoinSqlInjectorCondition
    @Order(value=-2147483648)
    @ConditionalOnBean(value={ISqlInjector.class})
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    public MPJSqlInjector mpjSqlInjector(ISqlInjector sqlInjector) {
        MybatisPlusJoinAutoConfiguration.info("mybatis plus join SqlInjector init");
        return new MPJSqlInjector(sqlInjector);
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean(value={ISqlInjector.class})
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    public MPJSqlInjector mpjSqlInjectorOnMiss() {
        MybatisPlusJoinAutoConfiguration.info("mybatis plus join SqlInjector init");
        return new MPJSqlInjector();
    }

    private static void info(String info) {
        if (ConfigProperties.banner) {
            logger.info(info);
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    public static class MPJSpringContext
    implements SpringContentUtils.SpringContext,
    BeanFactoryPostProcessor,
    ApplicationContextAware {
        private ApplicationContext applicationContext;
        private ListableBeanFactory listableBeanFactory;

        public <T> T getBean(Class<T> clazz) {
            return (T)this.getBeanFactory().getBean(clazz);
        }

        public <T> void getBeansOfType(Class<T> clazz) {
            this.getBeanFactory().getBeansOfType(clazz);
        }

        private ListableBeanFactory getBeanFactory() {
            return this.applicationContext == null ? this.listableBeanFactory : this.applicationContext;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
            SpringContentUtils.setSpringContext((SpringContentUtils.SpringContext)this);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            this.listableBeanFactory = beanFactory;
            SpringContentUtils.setSpringContext((SpringContentUtils.SpringContext)this);
            try {
                String[] names;
                for (String name : names = beanFactory.getBeanNamesForType(SqlSessionFactory.class)) {
                    BeanDefinition definition = beanFactory.getBeanDefinition(name);
                    MybatisPlusJoinAutoConfiguration.info(String.format("MPJ SqlSessionFactory bean definition: %s factoryBeanName: %s factoryMethodName: %s source: %s", name, definition.getFactoryBeanName(), definition.getFactoryMethodName(), definition.getSource()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Configuration
    @Order(value=-2147483648)
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    public static class MPJMappingConfig
    implements ApplicationListener<ApplicationReadyEvent> {
        public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
            MappingConfig.init();
        }
    }
}

