/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.mapping.mapper;

import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MPJMappingWrapper {
    private final boolean hasFirst;
    private String first;
    private final boolean hasSelect;
    private String select;
    private final boolean hasApply;
    private List<Apply> applyList;
    private final boolean hasCondition;
    private List<Condition> conditionList;
    private final boolean hasLast;
    private String last;
    private final boolean hasOrderByAsc;
    private List<String> orderByAsc;
    private final boolean hasOrderByDesc;
    private List<String> orderByDesc;

    public MPJMappingWrapper(String first, String select, com.github.yulichang.annotation.Apply[] applys, com.github.yulichang.annotation.Condition[] conditions, String last, String orderByAsc, String orderByDesc) {
        this.hasFirst = StringUtils.isNotBlank((CharSequence)first);
        if (this.hasFirst) {
            this.first = first;
        }
        this.hasSelect = StringUtils.isNotBlank((CharSequence)select);
        if (this.hasSelect) {
            this.select = select;
        }
        boolean bl = this.hasApply = applys.length > 0;
        if (this.hasApply) {
            this.applyList = new ArrayList<Apply>();
            for (com.github.yulichang.annotation.Apply apply : applys) {
                this.applyList.add(new Apply(apply.value(), apply.args()));
            }
        }
        boolean bl2 = this.hasCondition = conditions.length > 0;
        if (this.hasCondition) {
            this.conditionList = new ArrayList<Condition>();
            for (com.github.yulichang.annotation.Apply apply : conditions) {
                this.conditionList.add(new Condition(this.convert(apply.keyWord()), apply.column(), apply.value()));
            }
        }
        this.hasLast = StringUtils.isNotBlank((CharSequence)last);
        if (this.hasLast) {
            this.last = last;
        }
        this.hasOrderByAsc = StringUtils.isNotBlank((CharSequence)orderByAsc);
        if (this.hasOrderByAsc) {
            this.orderByAsc = Arrays.asList(orderByAsc.split(","));
        }
        this.hasOrderByDesc = StringUtils.isNotBlank((CharSequence)orderByDesc);
        if (this.hasOrderByDesc) {
            this.orderByDesc = Arrays.asList(orderByDesc.split(","));
        }
    }

    private SqlKeyword convert(com.github.yulichang.annotation.enums.SqlKeyword sqlKeyword) {
        if (Objects.isNull(sqlKeyword)) {
            return null;
        }
        switch (sqlKeyword) {
            case NOT: {
                return SqlKeyword.NOT;
            }
            case IN: {
                return SqlKeyword.IN;
            }
            case NOT_IN: {
                return SqlKeyword.NOT_IN;
            }
            case LIKE: {
                return SqlKeyword.LIKE;
            }
            case NOT_LIKE: {
                return SqlKeyword.NOT_LIKE;
            }
            case EQ: {
                return SqlKeyword.EQ;
            }
            case NE: {
                return SqlKeyword.NE;
            }
            case GT: {
                return SqlKeyword.GT;
            }
            case GE: {
                return SqlKeyword.GE;
            }
            case LT: {
                return SqlKeyword.LT;
            }
            case LE: {
                return SqlKeyword.LE;
            }
            case IS_NULL: {
                return SqlKeyword.IS_NULL;
            }
            case IS_NOT_NULL: {
                return SqlKeyword.IS_NOT_NULL;
            }
            case BETWEEN: {
                return SqlKeyword.BETWEEN;
            }
            case NOT_BETWEEN: {
                return SqlKeyword.NOT_BETWEEN;
            }
        }
        return SqlKeyword.EQ;
    }

    public boolean isHasFirst() {
        return this.hasFirst;
    }

    public String getFirst() {
        return this.first;
    }

    public boolean isHasSelect() {
        return this.hasSelect;
    }

    public String getSelect() {
        return this.select;
    }

    public boolean isHasApply() {
        return this.hasApply;
    }

    public List<Apply> getApplyList() {
        return this.applyList;
    }

    public boolean isHasCondition() {
        return this.hasCondition;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public boolean isHasLast() {
        return this.hasLast;
    }

    public String getLast() {
        return this.last;
    }

    public boolean isHasOrderByAsc() {
        return this.hasOrderByAsc;
    }

    public List<String> getOrderByAsc() {
        return this.orderByAsc;
    }

    public boolean isHasOrderByDesc() {
        return this.hasOrderByDesc;
    }

    public List<String> getOrderByDesc() {
        return this.orderByDesc;
    }

    public static class Condition {
        private final SqlKeyword keyword;
        private final String column;
        private final String[] val;

        public SqlKeyword getKeyword() {
            return this.keyword;
        }

        public String getColumn() {
            return this.column;
        }

        public String[] getVal() {
            return this.val;
        }

        public Condition(SqlKeyword keyword, String column, String[] val) {
            this.keyword = keyword;
            this.column = column;
            this.val = val;
        }
    }

    public static class Apply {
        private final String sql;
        private final String[] val;

        public String getSql() {
            return this.sql;
        }

        public String[] getVal() {
            return this.val;
        }

        public Apply(String sql, String[] val) {
            this.sql = sql;
            this.val = val;
        }
    }
}

