/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.config;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.yulichang.exception.MPJException;
import com.github.yulichang.interceptor.MPJInterceptor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.plugin.InterceptorChain;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class InterceptorConfig
implements ApplicationListener<ApplicationReadyEvent> {
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactoryList;
    @Autowired
    private MPJInterceptor mpjInterceptor;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (CollectionUtils.isNotEmpty(this.sqlSessionFactoryList)) {
            try {
                for (SqlSessionFactory factory : this.sqlSessionFactoryList) {
                    Field interceptorChain = Configuration.class.getDeclaredField("interceptorChain");
                    interceptorChain.setAccessible(true);
                    InterceptorChain chain = (InterceptorChain)interceptorChain.get(factory.getConfiguration());
                    Field interceptors = InterceptorChain.class.getDeclaredField("interceptors");
                    interceptors.setAccessible(true);
                    List list = (List)interceptors.get(chain);
                    if (!CollectionUtils.isNotEmpty((Collection)list) || list.get(list.size() - 1) == this.mpjInterceptor) continue;
                    list.removeIf(i -> i == this.mpjInterceptor);
                    list.add(this.mpjInterceptor);
                }
            }
            catch (Exception ignored) {
                throw new MPJException("mpjInterceptor exception");
            }
        }
    }
}

