/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.wrapper.MPJAbstractLambdaWrapper;
import com.github.yulichang.wrapper.enums.BaseFuncEnum;
import com.github.yulichang.wrapper.interfaces.LambdaJoin;
import com.github.yulichang.wrapper.interfaces.Query;
import com.github.yulichang.wrapper.interfaces.on.OnFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MPJLambdaWrapper<T>
extends MPJAbstractLambdaWrapper<T, MPJLambdaWrapper<T>>
implements Query<MPJLambdaWrapper<T>>,
LambdaJoin<MPJLambdaWrapper<T>> {
    private SharedString sqlSelect = new SharedString();
    private final SharedString from = new SharedString();
    private final SharedString alias = new SharedString("t");
    private final List<SelectColumn> selectColumns = new ArrayList<SelectColumn>();
    private final List<SelectColumn> ignoreColumns = new ArrayList<SelectColumn>();
    private int tableIndex = 1;
    private final List<MPJLambdaWrapper<?>> onWrappers = new ArrayList();
    private String keyWord;
    private Class<?> joinClass;

    public MPJLambdaWrapper() {
    }

    MPJLambdaWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, Map<Class<?>, Integer> subTable, String keyWord, Class<?> joinClass) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.subTable = subTable;
        this.keyWord = keyWord;
        this.joinClass = joinClass;
    }

    @Override
    @SafeVarargs
    public final <S> MPJLambdaWrapper<T> select(SFunction<S, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<S, ?> s : columns) {
                this.selectColumns.add(SelectColumn.of(LambdaUtils.getEntityClass(s), this.getCache(s).getColumn()));
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <E> MPJLambdaWrapper<T> select(Class<E> entityClass, Predicate<TableFieldInfo> predicate) {
        TableInfo info = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull((Object)info, (String)"table can not be find", (Object[])new Object[0]);
        info.getFieldList().stream().filter(predicate).collect(Collectors.toList()).forEach(i -> this.selectColumns.add(SelectColumn.of(entityClass, i.getColumn())));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <S> MPJLambdaWrapper<T> selectAs(SFunction<S, ?> column, String alias) {
        this.selectColumns.add(SelectColumn.of(LambdaUtils.getEntityClass(column), this.getCache(column).getColumn(), alias));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <S> MPJLambdaWrapper<T> selectFunc(boolean condition, BaseFuncEnum funcEnum, SFunction<S, ?> column, String alias) {
        if (condition) {
            this.selectColumns.add(SelectColumn.of(LambdaUtils.getEntityClass(column), this.getCache(column).getColumn(), alias, funcEnum));
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public MPJLambdaWrapper<T> selectFunc(boolean condition, BaseFuncEnum funcEnum, Object column, String alias) {
        if (condition) {
            this.selectColumns.add(SelectColumn.of(null, column.toString(), alias, funcEnum));
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public final MPJLambdaWrapper<T> selectAll(Class<?> clazz) {
        TableInfo info = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)info, (String)"table can not be find -> %s", (Object[])new Object[]{clazz});
        if (info.havePK()) {
            this.selectColumns.add(SelectColumn.of(clazz, info.getKeyColumn()));
        }
        info.getFieldList().forEach(c -> this.selectColumns.add(SelectColumn.of(clazz, c.getColumn())));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    @SafeVarargs
    public final <S> MPJLambdaWrapper<T> selectIgnore(SFunction<S, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<S, ?> s : columns) {
                this.ignoreColumns.add(SelectColumn.of(LambdaUtils.getEntityClass(s), this.getCache(s).getColumn()));
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue())) {
            if (CollectionUtils.isNotEmpty(this.ignoreColumns)) {
                this.selectColumns.removeIf(c -> c.getFuncEnum() == null && this.ignoreColumns.stream().anyMatch(i -> i.getClazz() == c.getClazz() && Objects.equals(c.getColumnName(), i.getColumnName())));
            }
            String s = this.selectColumns.stream().map(i -> {
                String str = "t" + this.getDefault((Integer)this.subTable.get(i.getClazz())) + "." + i.getColumnName();
                return (i.getFuncEnum() == null ? str : String.format(i.getFuncEnum().getSql(), str)) + (StringUtils.isBlank((CharSequence)i.getAlias()) ? "" : " AS " + i.getAlias());
            }).collect(Collectors.joining(","));
            this.sqlSelect.setStringValue(s);
        }
        return this.sqlSelect.getStringValue();
    }

    public String getFrom() {
        if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
            StringBuilder value = new StringBuilder();
            for (MPJLambdaWrapper<?> wrapper : this.onWrappers) {
                String tableName = TableInfoHelper.getTableInfo(wrapper.getJoinClass()).getTableName();
                value.append(wrapper.getKeyWord()).append(tableName).append(" t").append(this.subTable.get(wrapper.getJoinClass())).append(" ON ").append(wrapper.getExpression().getNormal().getSqlSegment());
            }
            this.from.setStringValue(value.toString());
        }
        return this.from.getStringValue();
    }

    public String getAlias() {
        return this.alias.getStringValue();
    }

    @Override
    protected MPJLambdaWrapper<T> instance() {
        return this.instance(null, null);
    }

    protected MPJLambdaWrapper<T> instance(String keyWord, Class<?> joinClass) {
        return new MPJLambdaWrapper(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), this.subTable, keyWord, joinClass);
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
        this.from.toNull();
        this.selectColumns.clear();
        this.ignoreColumns.clear();
        this.subTable.clear();
    }

    @Override
    public <R> MPJLambdaWrapper<T> join(String keyWord, boolean condition, Class<R> clazz, OnFunction function) {
        if (condition) {
            MPJLambdaWrapper<?> apply = function.apply(this.instance(keyWord, clazz));
            this.onWrappers.add(apply);
            this.subTable.put(clazz, this.tableIndex);
            ++this.tableIndex;
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public Class<?> getJoinClass() {
        return this.joinClass;
    }

    public static class SelectColumn {
        private Class<?> clazz;
        private String columnName;
        private String alias;
        private BaseFuncEnum funcEnum;
        private List<SFunction<?, ?>> funcArgs;

        private SelectColumn(Class<?> clazz, String columnName, String alias, BaseFuncEnum funcEnum) {
            this.clazz = clazz;
            this.columnName = columnName;
            this.alias = alias;
            this.funcEnum = funcEnum;
        }

        public static SelectColumn of(Class<?> clazz, String columnName) {
            return new SelectColumn(clazz, columnName, null, null);
        }

        public static SelectColumn of(Class<?> clazz, String columnName, String alias) {
            return new SelectColumn(clazz, columnName, alias, null);
        }

        public static SelectColumn of(Class<?> clazz, String columnName, String alias, BaseFuncEnum funcEnum) {
            return new SelectColumn(clazz, columnName, alias, funcEnum);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getAlias() {
            return this.alias;
        }

        public BaseFuncEnum getFuncEnum() {
            return this.funcEnum;
        }

        public List<SFunction<?, ?>> getFuncArgs() {
            return this.funcArgs;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setFuncEnum(BaseFuncEnum funcEnum) {
            this.funcEnum = funcEnum;
        }

        public void setFuncArgs(List<SFunction<?, ?>> funcArgs) {
            this.funcArgs = funcArgs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectColumn)) {
                return false;
            }
            SelectColumn other = (SelectColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            BaseFuncEnum this$funcEnum = this.getFuncEnum();
            BaseFuncEnum other$funcEnum = other.getFuncEnum();
            if (this$funcEnum == null ? other$funcEnum != null : !this$funcEnum.equals(other$funcEnum)) {
                return false;
            }
            List<SFunction<?, ?>> this$funcArgs = this.getFuncArgs();
            List<SFunction<?, ?>> other$funcArgs = other.getFuncArgs();
            return !(this$funcArgs == null ? other$funcArgs != null : !((Object)this$funcArgs).equals(other$funcArgs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelectColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            BaseFuncEnum $funcEnum = this.getFuncEnum();
            result = result * 59 + ($funcEnum == null ? 43 : $funcEnum.hashCode());
            List<SFunction<?, ?>> $funcArgs = this.getFuncArgs();
            result = result * 59 + ($funcArgs == null ? 43 : ((Object)$funcArgs).hashCode());
            return result;
        }

        public String toString() {
            return "MPJLambdaWrapper.SelectColumn(clazz=" + this.getClazz() + ", columnName=" + this.getColumnName() + ", alias=" + this.getAlias() + ", funcEnum=" + this.getFuncEnum() + ", funcArgs=" + this.getFuncArgs() + ")";
        }
    }
}

