/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.injector;

import com.baomidou.mybatisplus.core.MybatisPlusVersion;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.AbstractSqlInjector;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.injector.methods.Delete;
import com.baomidou.mybatisplus.core.injector.methods.DeleteBatchByIds;
import com.baomidou.mybatisplus.core.injector.methods.DeleteById;
import com.baomidou.mybatisplus.core.injector.methods.DeleteByMap;
import com.baomidou.mybatisplus.core.injector.methods.Insert;
import com.baomidou.mybatisplus.core.injector.methods.SelectBatchByIds;
import com.baomidou.mybatisplus.core.injector.methods.SelectById;
import com.baomidou.mybatisplus.core.injector.methods.SelectByMap;
import com.baomidou.mybatisplus.core.injector.methods.Update;
import com.baomidou.mybatisplus.core.injector.methods.UpdateById;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.github.yulichang.mapper.MPJTableMapperHelper;
import com.github.yulichang.method.SelectJoinCount;
import com.github.yulichang.method.SelectJoinList;
import com.github.yulichang.method.SelectJoinMap;
import com.github.yulichang.method.SelectJoinMaps;
import com.github.yulichang.method.SelectJoinMapsPage;
import com.github.yulichang.method.SelectJoinOne;
import com.github.yulichang.method.SelectJoinPage;
import com.github.yulichang.method.SqlMethod;
import com.github.yulichang.method.mp.SelectCount;
import com.github.yulichang.method.mp.SelectList;
import com.github.yulichang.method.mp.SelectMaps;
import com.github.yulichang.method.mp.SelectMapsPage;
import com.github.yulichang.method.mp.SelectObjs;
import com.github.yulichang.method.mp.SelectOne;
import com.github.yulichang.method.mp.SelectPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@ConditionalOnMissingBean(value={DefaultSqlInjector.class, AbstractSqlInjector.class, ISqlInjector.class})
public class MPJSqlInjector
extends DefaultSqlInjector {
    private static final List<String> METHOD_LIST = Arrays.asList("SelectOne", "SelectCount", "SelectMaps", "SelectMapsPage", "SelectObjs", "SelectList", "SelectPage");

    public List<AbstractMethod> getMethodList(Class<?> mapperClass) {
        List<AbstractMethod> list = Stream.of(new Insert(), new Delete(), new DeleteByMap(), new DeleteById(), new DeleteBatchByIds(), new Update(), new UpdateById(), new SelectById(), new SelectBatchByIds(), new SelectByMap()).collect(Collectors.toList());
        list.addAll(this.getJoinMethod());
        list.addAll(this.getSelectMethod());
        return list;
    }

    public List<AbstractMethod> getMethodList(Class<?> mapperClass, TableInfo tableInfo) {
        List list = super.getMethodList(mapperClass, tableInfo);
        list.removeIf(i -> METHOD_LIST.contains(i.getClass().getSimpleName()));
        list.addAll(this.getSelectMethod());
        list.addAll(this.getJoinMethod());
        return list;
    }

    private List<AbstractMethod> getJoinMethod() {
        int v2;
        int v1;
        ArrayList<AbstractMethod> list = new ArrayList<AbstractMethod>();
        try {
            String version = MybatisPlusVersion.getVersion();
            String[] split = version.split("\\.");
            v1 = Integer.parseInt(split[0]);
            v2 = Integer.parseInt(split[1]);
        }
        catch (Exception e) {
            v1 = 3;
            v2 = 4;
        }
        if (v1 == 3 && v2 >= 5 || v1 > 3) {
            list.add(new SelectJoinCount(SqlMethod.SELECT_JOIN_COUNT.getMethod()));
            list.add(new SelectJoinOne(SqlMethod.SELECT_JOIN_ONE.getMethod()));
            list.add(new SelectJoinList(SqlMethod.SELECT_JOIN_LIST.getMethod()));
            list.add(new SelectJoinPage(SqlMethod.SELECT_JOIN_PAGE.getMethod()));
            list.add(new SelectJoinMap(SqlMethod.SELECT_JOIN_MAP.getMethod()));
            list.add(new SelectJoinMaps(SqlMethod.SELECT_JOIN_MAPS.getMethod()));
            list.add(new SelectJoinMapsPage(SqlMethod.SELECT_JOIN_MAPS_PAGE.getMethod()));
        } else {
            list.add(new SelectJoinCount());
            list.add(new SelectJoinOne());
            list.add(new SelectJoinList());
            list.add(new SelectJoinPage());
            list.add(new SelectJoinMap());
            list.add(new SelectJoinMaps());
            list.add(new SelectJoinMapsPage());
        }
        return list;
    }

    private List<AbstractMethod> getSelectMethod() {
        ArrayList<AbstractMethod> list = new ArrayList<AbstractMethod>();
        list.add((AbstractMethod)new SelectOne());
        list.add((AbstractMethod)new SelectCount());
        list.add((AbstractMethod)new SelectMaps());
        list.add((AbstractMethod)new SelectMapsPage());
        list.add((AbstractMethod)new SelectObjs());
        list.add((AbstractMethod)new SelectList());
        list.add((AbstractMethod)new SelectPage());
        return list;
    }

    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Class<?> modelClass = MPJSqlInjector.getSuperClassGenericType(mapperClass, Mapper.class, 0);
        super.inspectInject(builderAssistant, mapperClass);
        MPJTableMapperHelper.init(modelClass, mapperClass);
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz, Class<?> genericIfc, int index) {
        Class[] typeArguments = GenericTypeResolver.resolveTypeArguments((Class)ClassUtils.getUserClass(clazz), genericIfc);
        return null == typeArguments ? null : typeArguments[index];
    }
}

