/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.toolkit.support.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.property.PropertyNamer;

public final class LambdaUtils {
    private static final Map<String, Map<String, ColumnCache>> COLUMN_CACHE_MAP = new ConcurrentHashMap<String, Map<String, ColumnCache>>();
    private static final Map<String, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap<String, WeakReference<SerializedLambda>>();

    public static <T> String getName(SFunction<T, ?> fn) {
        return PropertyNamer.methodToProperty((String)LambdaUtils.resolve(fn).getImplMethodName());
    }

    public static <T> Class<T> getEntityClass(SFunction<T, ?> fn) {
        return LambdaUtils.resolve(fn).getInstantiatedType();
    }

    public static <T> SerializedLambda resolve(SFunction<T, ?> func) {
        Class<?> clazz = func.getClass();
        String name = clazz.getName();
        return Optional.ofNullable(FUNC_CACHE.get(name)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.resolve(func);
            FUNC_CACHE.put(name, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static String formatKey(String key) {
        return key.toUpperCase(Locale.ENGLISH);
    }

    private static Map<String, ColumnCache> createColumnCacheMap(TableInfo info) {
        HashMap map;
        if (info.havePK()) {
            map = CollectionUtils.newHashMapWithExpectedSize((int)(info.getFieldList().size() + 1));
            map.put(LambdaUtils.formatKey(info.getKeyProperty()), new ColumnCache(info.getKeyColumn(), info.getKeySqlSelect(), null, info.getKeyProperty(), true, info.getKeyType()));
        } else {
            map = CollectionUtils.newHashMapWithExpectedSize((int)info.getFieldList().size());
        }
        info.getFieldList().forEach(i -> map.put(LambdaUtils.formatKey(i.getProperty()), new ColumnCache(i.getColumn(), i.getSqlSelect(), (TableFieldInfo)i, null, false, null)));
        return map;
    }

    public static Map<String, ColumnCache> getColumnMap(Class<?> clazz) {
        return (Map)CollectionUtils.computeIfAbsent(COLUMN_CACHE_MAP, (Object)clazz.getName(), key -> {
            TableInfo info = TableInfoHelper.getTableInfo((Class)clazz);
            return info == null ? null : LambdaUtils.createColumnCacheMap(info);
        });
    }
}

