/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.core.GenericTypeResolver;

public final class ReflectionKit {
    private static final Log logger = LogFactory.getLog(ReflectionKit.class);
    private static final Map<Class<?>, List<Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new IdentityHashMap(8);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_TO_WRAPPER_MAP = new IdentityHashMap(8);

    public static Object getFieldValue(Object entity, String fieldName) {
        Class<?> cls = entity.getClass();
        Map<String, Field> fieldMaps = ReflectionKit.getFieldMap(cls);
        try {
            Field field = fieldMaps.get(fieldName);
            Assert.notNull((Object)field, (String)"Error: NoSuchField in %s for %s.  Cause:", (Object[])new Object[]{cls.getSimpleName(), fieldName});
            field.setAccessible(true);
            return field.get(entity);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.mpe((String)"Error: Cannot read field in %s.  Cause:", (Throwable)e, (Object[])new Object[]{cls.getSimpleName()});
        }
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz, Class<?> genericIfc, int index) {
        Class[] typeArguments = GenericTypeResolver.resolveTypeArguments((Class)ClassUtils.getUserClass(clazz), genericIfc);
        return null == typeArguments ? null : typeArguments[index];
    }

    public static Class<?> getGenericType(Field field) {
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        Type argument = actualTypeArguments[0];
        if (argument instanceof WildcardType) {
            Type[] types = ((WildcardType)argument).getUpperBounds();
            return (Class)types[0];
        }
        return (Class)argument;
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        List<Field> fieldList = ReflectionKit.getFieldList(clazz);
        return CollectionUtils.isNotEmpty(fieldList) ? fieldList.stream().collect(Collectors.toMap(Field::getName, field -> field)) : Collections.emptyMap();
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        return (List)CollectionUtils.computeIfAbsent(CLASS_FIELD_CACHE, clazz, k -> {
            Field[] fields = k.getDeclaredFields();
            ArrayList<Field> superFields = new ArrayList<Field>();
            for (Class currentClass = k.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] declaredFields = currentClass.getDeclaredFields();
                Collections.addAll(superFields, declaredFields);
            }
            Map<String, Field> fieldMap = ReflectionKit.excludeOverrideSuperField(fields, superFields);
            return fieldMap.values().stream().filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList());
        });
    }

    public static Map<String, Field> excludeOverrideSuperField(Field[] fields, List<Field> superFieldList) {
        Map fieldMap = Stream.of(fields).collect(Collectors.toMap(Field::getName, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        superFieldList.stream().filter(field -> !fieldMap.containsKey(field.getName())).forEach(f -> fieldMap.put(f.getName(), f));
        return fieldMap;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null", (Object[])new Object[0]);
        return clazz.isPrimitive() || PRIMITIVE_WRAPPER_TYPE_MAP.containsKey(clazz);
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        return clazz.isPrimitive() && clazz != Void.TYPE ? PRIMITIVE_TYPE_TO_WRAPPER_MAP.get(clazz) : clazz;
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_WRAPPER_TYPE_MAP.entrySet()) {
            PRIMITIVE_TYPE_TO_WRAPPER_MAP.put(entry.getValue(), entry.getKey());
        }
    }
}

