/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.exception.MPJException;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.toolkit.ReflectionKit;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.toolkit.support.SelectColumn;
import com.github.yulichang.wrapper.MPJAbstractLambdaWrapper;
import com.github.yulichang.wrapper.enums.BaseFuncEnum;
import com.github.yulichang.wrapper.interfaces.LambdaJoin;
import com.github.yulichang.wrapper.interfaces.Query;
import com.github.yulichang.wrapper.interfaces.on.OnFunction;
import com.github.yulichang.wrapper.resultmap.LabelType;
import com.github.yulichang.wrapper.resultmap.MFunc;
import com.github.yulichang.wrapper.resultmap.MybatisLabel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MPJLambdaWrapper<T>
extends MPJAbstractLambdaWrapper<T, MPJLambdaWrapper<T>>
implements Query<MPJLambdaWrapper<T>>,
LambdaJoin<MPJLambdaWrapper<T>, T> {
    private final SharedString from = new SharedString();
    private final SharedString alias = new SharedString("t");
    private final List<SelectColumn> selectColumns = new ArrayList<SelectColumn>();
    private final List<MPJLambdaWrapper<?>> onWrappers = new ArrayList();
    private final List<MybatisLabel<?, ?>> resultMapMybatisLabel = new ArrayList();
    private boolean resultMap = false;
    private SharedString sqlSelect = new SharedString();
    private boolean selectDistinct = false;
    private int tableIndex = 1;
    private String keyWord;
    private Class<?> joinClass;

    public MPJLambdaWrapper() {
    }

    MPJLambdaWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, Map<Class<?>, Integer> subTable, String keyWord, Class<?> joinClass) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.subTable = subTable;
        this.keyWord = keyWord;
        this.joinClass = joinClass;
    }

    public MPJLambdaWrapper<T> distinct() {
        this.selectDistinct = true;
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    @SafeVarargs
    public final <S> MPJLambdaWrapper<T> select(SFunction<S, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<S, ?> s : columns) {
                ColumnCache cache = this.getCache(s);
                this.selectColumns.add(SelectColumn.of(LambdaUtils.getEntityClass(s), cache.getColumn(), cache.getTableFieldInfo(), null, cache.getTableFieldInfo() == null ? cache.getKeyProperty() : cache.getTableFieldInfo().getProperty(), cache.getKeyType(), false, null));
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    public <S, C, Z, F extends Collection<?>> MPJLambdaWrapper<T> selectCollection(Class<C> child, SFunction<S, F> dtoField) {
        MybatisLabel.Builder<C, Object> builder;
        String dtoFieldName = LambdaUtils.getName(dtoField);
        Class<S> dtoClass = LambdaUtils.getEntityClass(dtoField);
        Map<String, Field> fieldMap = ReflectionKit.getFieldMap(dtoClass);
        Field field = fieldMap.get(dtoFieldName);
        this.resultMap = true;
        Class<C> genericType = ReflectionKit.getGenericType(field);
        if (genericType == null || genericType.isAssignableFrom(child)) {
            builder = new MybatisLabel.Builder(LabelType.COLLECTION, dtoFieldName, child, field.getType());
        } else {
            Class<C> ofType = genericType;
            if (ReflectionKit.isPrimitiveOrWrapper(ofType)) {
                throw new MPJException("collection \u4e0d\u652f\u6301\u57fa\u672c\u6570\u636e\u7c7b\u578b");
            }
            builder = new MybatisLabel.Builder(LabelType.COLLECTION, dtoFieldName, child, field.getType(), ofType, true);
        }
        this.resultMapMybatisLabel.add(builder.build());
        return (MPJLambdaWrapper)this.typedThis;
    }

    public <S, C, Z, F extends Collection<Z>> MPJLambdaWrapper<T> selectCollection(Class<C> child, SFunction<S, F> dtoField, MFunc<MybatisLabel.Builder<C, Z>> collection) {
        Class<?> genericType;
        String dtoFieldName = LambdaUtils.getName(dtoField);
        Class<S> dtoClass = LambdaUtils.getEntityClass(dtoField);
        Field field = ReflectionKit.getFieldMap(dtoClass).get(dtoFieldName);
        this.resultMap = true;
        Class<?> ofType = genericType = ReflectionKit.getGenericType(field);
        MybatisLabel.Builder builder = new MybatisLabel.Builder(LabelType.COLLECTION, dtoFieldName, child, field.getType(), ofType, false);
        this.resultMapMybatisLabel.add(collection.apply(builder).build());
        return (MPJLambdaWrapper)this.typedThis;
    }

    public <S, C, F> MPJLambdaWrapper<T> selectAssociation(Class<C> child, SFunction<S, F> dtoField) {
        String dtoFieldName = LambdaUtils.getName(dtoField);
        Class<S> dtoClass = LambdaUtils.getEntityClass(dtoField);
        Map<String, Field> fieldMap = ReflectionKit.getFieldMap(dtoClass);
        Field field = fieldMap.get(dtoFieldName);
        Assert.isFalse((boolean)Collection.class.isAssignableFrom(field.getType()), (String)"association \u4e0d\u652f\u6301\u96c6\u5408\u7c7b", (Object[])new Object[0]);
        if (ReflectionKit.isPrimitiveOrWrapper(field.getType())) {
            throw new MPJException("association \u4e0d\u652f\u6301\u57fa\u672c\u6570\u636e\u7c7b\u578b");
        }
        this.resultMap = true;
        MybatisLabel.Builder builder = new MybatisLabel.Builder(LabelType.ASSOCIATION, dtoFieldName, child, field.getType(), field.getType(), true);
        this.resultMapMybatisLabel.add(builder.build());
        return (MPJLambdaWrapper)this.typedThis;
    }

    public <S, C, F> MPJLambdaWrapper<T> selectAssociation(Class<C> child, SFunction<S, F> dtoField, MFunc<MybatisLabel.Builder<C, F>> collection) {
        String dtoFieldName = LambdaUtils.getName(dtoField);
        Class<S> dtoClass = LambdaUtils.getEntityClass(dtoField);
        Field field = ReflectionKit.getFieldMap(dtoClass).get(dtoFieldName);
        this.resultMap = true;
        Assert.isFalse((boolean)Collection.class.isAssignableFrom(field.getType()), (String)"association \u4e0d\u652f\u6301\u96c6\u5408\u7c7b", (Object[])new Object[0]);
        if (ReflectionKit.isPrimitiveOrWrapper(field.getType())) {
            throw new MPJException("association \u4e0d\u652f\u6301\u57fa\u672c\u6570\u636e\u7c7b\u578b");
        }
        MybatisLabel.Builder<C, C> builder = new MybatisLabel.Builder<C, C>(LabelType.ASSOCIATION, dtoFieldName, child, field.getType(), child, false);
        this.resultMapMybatisLabel.add(collection.apply(builder).build());
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <E> MPJLambdaWrapper<T> select(Class<E> entityClass, Predicate<TableFieldInfo> predicate) {
        TableInfo info = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull((Object)info, (String)"table not find by class <%s>", (Object[])new Object[]{entityClass.getName()});
        info.getFieldList().stream().filter(predicate).collect(Collectors.toList()).forEach(i -> this.selectColumns.add(SelectColumn.of(entityClass, i.getColumn(), i, null, i.getProperty(), null, false, null)));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <E> MPJLambdaWrapper<T> selectAsClass(Class<E> source, Class<?> tag) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(source);
        Assert.notNull((Object)tableInfo, (String)"table not find by class <%s>", (Object[])new Object[]{source.getName()});
        List<Field> tagFields = ReflectionKit.getFieldList(tag);
        tableInfo.getFieldList().forEach(i -> {
            if (tagFields.stream().anyMatch(f -> f.getName().equals(i.getProperty()))) {
                this.selectColumns.add(SelectColumn.of(source, i.getColumn(), i, null, i.getProperty(), null, false, null));
            }
        });
        if (tableInfo.havePK() && tagFields.stream().anyMatch(i -> i.getName().equals(tableInfo.getKeyProperty()))) {
            this.selectColumns.add(SelectColumn.of(source, tableInfo.getKeyColumn(), null, null, tableInfo.getKeyProperty(), tableInfo.getKeyType(), false, null));
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <S> MPJLambdaWrapper<T> selectAs(SFunction<S, ?> column, String alias) {
        ColumnCache cache = this.getCache(column);
        this.selectColumns.add(SelectColumn.of(LambdaUtils.getEntityClass(column), cache.getColumn(), cache.getTableFieldInfo(), alias, null, cache.getKeyType(), false, null));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <S> MPJLambdaWrapper<T> selectFunc(boolean condition, BaseFuncEnum funcEnum, SFunction<S, ?> column, String alias) {
        if (condition) {
            ColumnCache cache = this.getCache(column);
            this.selectColumns.add(SelectColumn.of(LambdaUtils.getEntityClass(column), cache.getColumn(), cache.getTableFieldInfo(), alias, alias, cache.getKeyType(), false, funcEnum));
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public MPJLambdaWrapper<T> selectFunc(boolean condition, BaseFuncEnum funcEnum, Object column, String alias) {
        if (condition) {
            this.selectColumns.add(SelectColumn.of(null, column.toString(), null, alias, alias, null, false, funcEnum));
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public final MPJLambdaWrapper<T> selectAll(Class<?> clazz) {
        TableInfo info = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)info, (String)"table can not be find -> %s", (Object[])new Object[]{clazz});
        if (info.havePK()) {
            this.selectColumns.add(SelectColumn.of(clazz, info.getKeyColumn(), null, null, info.getKeyProperty(), info.getKeyType(), false, null));
        }
        info.getFieldList().forEach(c -> this.selectColumns.add(SelectColumn.of(clazz, c.getColumn(), c, null, c.getProperty(), null, false, null)));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue())) {
            String s = this.selectColumns.stream().map(i -> {
                String str = "t" + this.getDefault((Integer)this.subTable.get(i.getClazz())) + "." + i.getColumnName();
                return (i.getFuncEnum() == null ? str : String.format(i.getFuncEnum().getSql(), str)) + (StringUtils.isBlank((CharSequence)i.getAlias()) ? "" : " AS " + i.getAlias());
            }).collect(Collectors.joining(","));
            this.sqlSelect.setStringValue(s);
        }
        return this.sqlSelect.getStringValue();
    }

    public String getFrom() {
        if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
            StringBuilder value = new StringBuilder();
            for (MPJLambdaWrapper<?> wrapper : this.onWrappers) {
                String tableName = TableInfoHelper.getTableInfo(wrapper.getJoinClass()).getTableName();
                value.append(wrapper.getKeyWord()).append(tableName).append(" t").append(this.subTable.get(wrapper.getJoinClass())).append(" ON ").append(wrapper.getExpression().getNormal().getSqlSegment());
            }
            this.from.setStringValue(value.toString());
        }
        return this.from.getStringValue();
    }

    public String getAlias() {
        return this.alias.getStringValue();
    }

    public boolean getSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    protected MPJLambdaWrapper<T> instance() {
        return this.instance(null, null);
    }

    protected MPJLambdaWrapper<T> instance(String keyWord, Class<?> joinClass) {
        return new MPJLambdaWrapper(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), this.subTable, keyWord, joinClass);
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
        this.from.toNull();
        this.selectColumns.clear();
        this.subTable.clear();
    }

    @Override
    public <R> MPJLambdaWrapper<T> join(String keyWord, boolean condition, Class<R> clazz, OnFunction function) {
        if (condition) {
            MPJLambdaWrapper<?> apply = function.apply(this.instance(keyWord, clazz));
            this.onWrappers.add(apply);
            this.subTable.put(clazz, this.tableIndex);
            ++this.tableIndex;
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    public List<SelectColumn> getSelectColumns() {
        return this.selectColumns;
    }

    public List<MybatisLabel<?, ?>> getResultMapMybatisLabel() {
        return this.resultMapMybatisLabel;
    }

    public boolean isResultMap() {
        return this.resultMap;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public Class<?> getJoinClass() {
        return this.joinClass;
    }
}

