/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper.resultmap;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.toolkit.ReflectionKit;
import com.github.yulichang.wrapper.resultmap.LabelType;
import com.github.yulichang.wrapper.resultmap.Result;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MybatisLabel<E, T> {
    private LabelType labelType;
    private String property;
    private Class<E> entityClass;
    private Class<?> javaType;
    private Class<T> ofType;
    private List<Result> resultList;

    private MybatisLabel() {
    }

    public LabelType getLabelType() {
        return this.labelType;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Class<T> getOfType() {
        return this.ofType;
    }

    public List<Result> getResultList() {
        return this.resultList;
    }

    public static class Builder<E, T> {
        private final MybatisLabel<E, T> mybatisLabel = new MybatisLabel();

        public Builder(LabelType labelType, String property, Class<E> entityClass, Class<?> javaType) {
            ((MybatisLabel)this.mybatisLabel).labelType = labelType;
            ((MybatisLabel)this.mybatisLabel).property = property;
            ((MybatisLabel)this.mybatisLabel).entityClass = entityClass;
            ((MybatisLabel)this.mybatisLabel).javaType = javaType;
            ((MybatisLabel)this.mybatisLabel).ofType = entityClass;
            ((MybatisLabel)this.mybatisLabel).resultList = new ArrayList();
            this.autoBuild(true, entityClass, entityClass);
        }

        public Builder(LabelType labelType, String property, Class<E> entityClass, Class<?> javaType, Class<T> ofType, boolean auto) {
            ((MybatisLabel)this.mybatisLabel).labelType = labelType;
            ((MybatisLabel)this.mybatisLabel).property = property;
            ((MybatisLabel)this.mybatisLabel).entityClass = entityClass;
            ((MybatisLabel)this.mybatisLabel).javaType = javaType;
            ((MybatisLabel)this.mybatisLabel).ofType = ofType;
            ((MybatisLabel)this.mybatisLabel).resultList = new ArrayList();
            this.autoBuild(auto, entityClass, ofType);
        }

        public Builder<E, T> id(SFunction<E, ?> entity, SFunction<T, ?> tag) {
            Result.Builder builder = new Result.Builder(true);
            builder.column(entity).property(tag);
            ((MybatisLabel)this.mybatisLabel).resultList.add(builder.build());
            return this;
        }

        public Builder<E, T> id(SFunction<E, ?> entity) {
            Result.Builder builder = new Result.Builder(true);
            builder.column(entity);
            ((MybatisLabel)this.mybatisLabel).resultList.add(builder.build());
            return this;
        }

        public Builder<E, T> result(SFunction<E, ?> entity, SFunction<T, ?> tag) {
            Result.Builder builder = new Result.Builder(false);
            builder.column(entity).property(tag);
            ((MybatisLabel)this.mybatisLabel).resultList.add(builder.build());
            return this;
        }

        public Builder<E, T> result(SFunction<E, ?> entity) {
            Result.Builder builder = new Result.Builder(false);
            builder.column(entity);
            ((MybatisLabel)this.mybatisLabel).resultList.add(builder.build());
            return this;
        }

        public MybatisLabel<E, T> build() {
            return this.mybatisLabel;
        }

        private void autoBuild(boolean auto, Class<E> entityClass, Class<T> tagClass) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
            Map<String, Field> tagMap = ReflectionKit.getFieldMap(tagClass);
            if (auto && !tagMap.isEmpty()) {
                Function<TableFieldInfo, Result> build = field -> {
                    Result result = new Result();
                    result.setId(false);
                    result.setColumn(field.getColumn());
                    result.setProperty(field.getProperty());
                    result.setJavaType(field.getField().getType());
                    result.setJdbcType(field.getJdbcType());
                    result.setTypeHandle(field.getTypeHandler());
                    return result;
                };
                if (entityClass == tagClass) {
                    if (tableInfo.havePK()) {
                        ((MybatisLabel)this.mybatisLabel).resultList.add(this.pkBuild(tableInfo));
                    }
                    ((MybatisLabel)this.mybatisLabel).resultList.addAll(tableInfo.getFieldList().stream().map(build).collect(Collectors.toList()));
                } else {
                    if (tableInfo.havePK() && tagMap.containsKey(tableInfo.getKeyProperty())) {
                        ((MybatisLabel)this.mybatisLabel).resultList.add(this.pkBuild(tableInfo));
                    }
                    ((MybatisLabel)this.mybatisLabel).resultList.addAll(tableInfo.getFieldList().stream().filter(i -> tagMap.containsKey(i.getProperty())).map(build).collect(Collectors.toList()));
                }
            }
        }

        private Result pkBuild(TableInfo tableInfo) {
            Result result = new Result();
            result.setId(true);
            result.setColumn(tableInfo.getKeyColumn());
            result.setProperty(tableInfo.getKeyProperty());
            result.setJavaType(tableInfo.getKeyType());
            return result;
        }
    }
}

