/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper.resultmap;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.toolkit.LambdaUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class Result {
    private boolean isId;
    private String property;
    private String column;
    private TableFieldInfo tableFieldInfo;
    private Class<?> javaType;
    private JdbcType jdbcType;
    private Class<? extends TypeHandler<?>> typeHandle;

    public boolean isId() {
        return this.isId;
    }

    public String getProperty() {
        return this.property;
    }

    public String getColumn() {
        return this.column;
    }

    public TableFieldInfo getTableFieldInfo() {
        return this.tableFieldInfo;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Class<? extends TypeHandler<?>> getTypeHandle() {
        return this.typeHandle;
    }

    void setId(boolean isId) {
        this.isId = isId;
    }

    void setProperty(String property) {
        this.property = property;
    }

    void setColumn(String column) {
        this.column = column;
    }

    void setTableFieldInfo(TableFieldInfo tableFieldInfo) {
        this.tableFieldInfo = tableFieldInfo;
    }

    void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    void setTypeHandle(Class<? extends TypeHandler<?>> typeHandle) {
        this.typeHandle = typeHandle;
    }

    public static class Builder<E, T> {
        private final Result result = new Result();

        public Builder(boolean isId) {
            this.result.isId = isId;
        }

        public Builder<E, T> property(SFunction<T, ?> property) {
            this.result.property = LambdaUtils.getName(property);
            return this;
        }

        public Builder<E, T> column(SFunction<E, ?> column) {
            Class<E> entityClass = LambdaUtils.getEntityClass(column);
            String name = LambdaUtils.getName(column);
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
            Assert.notNull((Object)tableInfo, (String)"table not find by class <%s>", (Object[])new Object[]{tableInfo});
            if (tableInfo.havePK() && tableInfo.getKeyProperty().equals(name)) {
                this.result.column = tableInfo.getKeyColumn();
                if (StringUtils.isBlank((CharSequence)this.result.property)) {
                    this.result.property = tableInfo.getKeyProperty();
                }
                this.result.javaType = tableInfo.getKeyType();
            } else {
                TableFieldInfo fieldInfo = tableInfo.getFieldList().stream().filter(i -> i.getField().getName().equals(name)).findFirst().orElse(null);
                Assert.notNull((Object)fieldInfo, (String)"table <%s> not find column <%>", (Object[])new Object[]{tableInfo.getTableName(), name});
                this.result.column = fieldInfo.getColumn();
                this.result.tableFieldInfo = fieldInfo;
                if (StringUtils.isBlank((CharSequence)this.result.property)) {
                    this.result.property = fieldInfo.getProperty();
                }
                this.result.jdbcType = fieldInfo.getJdbcType();
                this.result.javaType = fieldInfo.getField().getType();
                this.result.typeHandle = fieldInfo.getTypeHandler();
            }
            return this;
        }

        public Builder<E, T> javaType(Class<?> javaType) {
            this.result.javaType = javaType;
            return this;
        }

        public Builder<E, T> jdbcType(JdbcType jdbcType) {
            this.result.jdbcType = jdbcType;
            return this;
        }

        public Result build() {
            return this.result;
        }
    }
}

