/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.core.transaction;

import com.magician.jdbc.core.constant.enums.TractionLevel;
import com.magician.jdbc.core.util.ThreadUtil;
import com.magician.jdbc.helper.manager.DataSourceManager;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static Logger logger = LoggerFactory.getLogger(TransactionManager.class);

    public static void beginTraction() {
        TransactionManager.beginTraction(TractionLevel.READ_COMMITTED);
    }

    public static void beginTraction(TractionLevel tractionLevel) {
        try {
            Map<String, DataSource> maps = DataSourceManager.getDruidDataSources();
            HashMap<String, Connection> connections = new HashMap<String, Connection>();
            for (String key : maps.keySet()) {
                Connection connection = maps.get(key).getConnection();
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(tractionLevel.getLevel());
                connections.put(key, connection);
            }
            ThreadUtil.getThreadLocal().set(connections);
        }
        catch (Exception e) {
            logger.error("\u5f00\u542f\u4e8b\u52a1\u51fa\u9519", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit() {
        try {
            Map connections = (Map)ThreadUtil.getThreadLocal().get();
            for (String key : connections.keySet()) {
                Connection connection = (Connection)connections.get(key);
                connection.commit();
                connection.close();
            }
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u4e8b\u52a1\u51fa\u9519", (Throwable)e);
        }
        finally {
            ThreadUtil.getThreadLocal().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback() {
        try {
            Map connections = (Map)ThreadUtil.getThreadLocal().get();
            for (String key : connections.keySet()) {
                Connection connection = (Connection)connections.get(key);
                connection.rollback();
                connection.close();
            }
        }
        catch (Exception ex) {
            logger.error("\u56de\u6eda\u4e8b\u52a1\u51fa\u9519", (Throwable)ex);
        }
        finally {
            ThreadUtil.getThreadLocal().remove();
        }
    }
}

