/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.core.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static Logger logger = LoggerFactory.getLogger(JSONUtil.class);

    public static <T> T toJavaObject(Object obj, Class<T> cls) {
        if (obj == null) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (obj instanceof String) {
                return (T)objectMapper.readValue(obj.toString(), cls);
            }
            return (T)objectMapper.readValue(objectMapper.writeValueAsString(obj), cls);
        }
        catch (Exception e) {
            logger.error("\u5c06\u5bf9\u8c61\u901a\u8fc7jackson\u8f6c\u6210\u53e6\u4e00\u4e2aJava\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> toMap(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        Map map = JSONUtil.toJavaObject(obj, HashMap.class);
        if (map == null) {
            return new HashMap<String, Object>();
        }
        return map;
    }

    public static String toJSONString(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (obj instanceof String) {
                return obj.toString();
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("\u5c06\u5bf9\u8c61\u8f6c\u6210JSON\u5b57\u7b26\u4e32\u5f02\u5e38", (Throwable)e);
            return "";
        }
    }
}

