/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.helper;

import com.magician.jdbc.core.util.JSONUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBHelper {
    private static Logger logger = LoggerFactory.getLogger(DBHelper.class);

    public static List<Map<String, Object>> selectList(String sql, Connection connection) throws Exception {
        return DBHelper.selectList(sql, connection, new Object[0]);
    }

    public static List<Map<String, Object>> selectList(String sql, Connection connection, Object[] params) throws Exception {
        ResultSet resultSet = DBHelper.select(sql, connection, params);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int count = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> rows = new HashMap<String, Object>();
            for (int i = 1; i <= count; ++i) {
                String key = resultSetMetaData.getColumnLabel(i);
                Object value = resultSet.getObject(i);
                rows.put(key, value);
            }
            list.add(rows);
        }
        return list;
    }

    public static ResultSet select(String sql, Connection connection, Object[] params) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("sql:{},params:{}", (Object)sql, (Object)JSONUtil.toJSONString(params));
        }
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                preparedStatement.setObject(i + 1, params[i]);
            }
        }
        return preparedStatement.executeQuery();
    }

    public static int update(String sql, Connection connection) throws Exception {
        return DBHelper.update(sql, connection, null);
    }

    public static int update(String sql, Connection connection, Object[] params) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("sql:{},params:{}", (Object)sql, (Object)JSONUtil.toJSONString(params));
        }
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                preparedStatement.setObject(i + 1, params[i]);
            }
        }
        return preparedStatement.executeUpdate();
    }
}

