/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.helper.templete;

import com.magician.jdbc.helper.templete.base.BaseSelect;
import com.magician.jdbc.helper.templete.model.PageModel;
import com.magician.jdbc.helper.templete.model.PageParamModel;
import java.util.List;
import java.util.Map;

public class JdbcPage {
    public static PageModel<Map> selectList(String sql, PageParamModel param, String dataSourceName) throws Exception {
        return JdbcPage.selectList(sql, param, Map.class, dataSourceName);
    }

    public static <T> PageModel<T> selectList(String sql, PageParamModel param, Class<T> cls, String dataSourceName) throws Exception {
        Map<String, Object> pageParam;
        String selectSql = JdbcPage.getSelectSql(sql);
        String countSql = JdbcPage.getCountSql(sql);
        List<Map> countList = BaseSelect.selectList(countSql, pageParam = JdbcPage.getParam(param), Map.class, dataSourceName);
        Object countNum = JdbcPage.getCountNum(countList);
        if (countNum == null) {
            return null;
        }
        List<T> dataList = BaseSelect.selectList(selectSql, pageParam, cls, dataSourceName);
        PageModel<T> pageModel = new PageModel<T>();
        pageModel.setPageCount(Integer.parseInt(countNum.toString()));
        pageModel.setDataList(dataList);
        pageModel.setCurrentPage(param.getCurrentPage());
        pageModel.setPageSize(param.getPageSize());
        int pageTotal = pageModel.getPageCount() / pageModel.getPageSize();
        if (pageModel.getPageCount() % pageModel.getPageSize() == 0) {
            pageModel.setPageTotal(pageTotal);
        } else {
            pageModel.setPageTotal(pageTotal + 1);
        }
        return pageModel;
    }

    private static Object getCountNum(List<Map> countList) {
        if (countList == null || countList.size() < 1) {
            return null;
        }
        Map countItem = countList.get(0);
        if (countItem == null || countItem.size() < 1) {
            return null;
        }
        Object countNum = countItem.get("countNum");
        if (countNum == null || countNum.equals("")) {
            return null;
        }
        return countNum;
    }

    private static String getCountSql(String sql) {
        StringBuffer sqlBuilder = new StringBuffer("select count(0) countNum from  ( ");
        sqlBuilder.append(sql);
        sqlBuilder.append(" ) tbl");
        return sqlBuilder.toString();
    }

    private static String getSelectSql(String sql) {
        StringBuffer sqlBuilder = new StringBuffer();
        sqlBuilder.append(sql);
        sqlBuilder.append(" limit #{pageStart},#{pageSize}");
        return sqlBuilder.toString();
    }

    private static Map<String, Object> getParam(PageParamModel param) {
        Map<String, Object> objectMap = param.getParam();
        objectMap.put("pageStart", (param.getCurrentPage() - 1) * param.getPageSize());
        objectMap.put("pageSize", param.getPageSize());
        return objectMap;
    }
}

