/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.helper.templete;

import com.magician.jdbc.helper.templete.JdbcPage;
import com.magician.jdbc.helper.templete.JdbcSelect;
import com.magician.jdbc.helper.templete.JdbcUpdate;
import com.magician.jdbc.helper.templete.base.BaseJdbcTemplate;
import com.magician.jdbc.helper.templete.model.PageModel;
import com.magician.jdbc.helper.templete.model.PageParamModel;
import java.util.List;
import java.util.Map;

public class JdbcTemplate
extends BaseJdbcTemplate {
    private String dataSourceName;

    private JdbcTemplate() {
    }

    public static JdbcTemplate create() {
        return JdbcTemplate.create(null);
    }

    public static JdbcTemplate create(String dataSourceName) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.dataSourceName = JdbcTemplate.getDataSourceName(dataSourceName);
        return jdbcTemplate;
    }

    public List<Map> selectList(String sql, Object param) throws Exception {
        return JdbcSelect.selectList(sql, param, this.dataSourceName);
    }

    public List<Map> selectList(String sql) throws Exception {
        return JdbcSelect.selectList(sql, this.dataSourceName);
    }

    public <T> List<T> selectList(String sql, Class<T> cls) throws Exception {
        return JdbcSelect.selectList(sql, cls, this.dataSourceName);
    }

    public <T> List<T> selectList(String sql, Object param, Class<T> cls) throws Exception {
        return JdbcSelect.selectList(sql, param, cls, this.dataSourceName);
    }

    public Map<String, Object> selectOne(String sql, Object param) throws Exception {
        return JdbcSelect.selectOne(sql, param, this.dataSourceName);
    }

    public Map<String, Object> selectOne(String sql) throws Exception {
        return JdbcSelect.selectOne(sql, this.dataSourceName);
    }

    public <T> T selectOne(String sql, Class<T> cls) throws Exception {
        return JdbcSelect.selectOne(sql, cls, this.dataSourceName);
    }

    public <T> T selectOne(String sql, Object param, Class<T> cls) throws Exception {
        return JdbcSelect.selectOne(sql, param, cls, this.dataSourceName);
    }

    public PageModel<Map> selectPageList(String sql, PageParamModel param) throws Exception {
        return JdbcPage.selectList(sql, param, this.dataSourceName);
    }

    public <T> PageModel<T> selectPageList(String sql, PageParamModel param, Class<T> cls) throws Exception {
        return JdbcPage.selectList(sql, param, cls, this.dataSourceName);
    }

    public int update(String sql, Object param) throws Exception {
        return JdbcUpdate.update(sql, param, this.dataSourceName);
    }

    public int update(String sql) throws Exception {
        return JdbcUpdate.update(sql, this.dataSourceName);
    }

    public Object getLastInsertID() throws Exception {
        Map<String, Object> result = this.selectOne("select LAST_INSERT_ID()");
        if (result == null || result.size() < 1) {
            return null;
        }
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Object obj = entry.getValue();
            if (obj == null) continue;
            return obj;
        }
        return null;
    }
}

