/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.helper.templete.base;

import com.magician.jdbc.core.util.JSONUtil;
import com.magician.jdbc.core.util.ThreadUtil;
import com.magician.jdbc.helper.manager.ConnectionManager;
import com.magician.jdbc.helper.manager.DataSourceManager;
import com.magician.jdbc.helper.templete.model.SqlBuilderModel;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseJdbcTemplate {
    public static ConnectionManager getConnection(String dataSourceName) throws Exception {
        ConnectionManager connectionManager = new ConnectionManager();
        Object obj = ThreadUtil.getThreadLocal().get();
        String dataSourceName2 = BaseJdbcTemplate.getDataSourceName(dataSourceName);
        if (obj != null) {
            Map connections = (Map)obj;
            connectionManager.setConnection((Connection)connections.get(dataSourceName2));
            connectionManager.setHasTraction(false);
        } else {
            connectionManager.setConnection(DataSourceManager.getConnection(dataSourceName2));
            connectionManager.setHasTraction(true);
        }
        return connectionManager;
    }

    public static String getDataSourceName(String dataSourceName) {
        if (dataSourceName == null) {
            dataSourceName = DataSourceManager.getDefaultDataSourceName();
        }
        return dataSourceName;
    }

    public static SqlBuilderModel builderSql(String sql, Object args) throws Exception {
        SqlBuilderModel sqlBuilderModel = new SqlBuilderModel();
        Map<String, Object> jsonObject = JSONUtil.toMap(args);
        ArrayList<Object> params = new ArrayList<Object>();
        sql = BaseJdbcTemplate.replaceMatcher(sql, params, jsonObject);
        sql = BaseJdbcTemplate.formatMatcher(sql, params, jsonObject);
        sqlBuilderModel.setSql(sql);
        sqlBuilderModel.setParams(params.toArray());
        return sqlBuilderModel;
    }

    private static String formatMatcher(String sql, List<Object> params, Map<String, Object> jsonObject) {
        Pattern pattern = Pattern.compile("(#\\{((?!}).)*\\})");
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            String matcherName = matcher.group();
            sql = sql.replace(matcherName, "?");
            String filedName = BaseJdbcTemplate.getFiledName(matcherName, "#");
            params.add(jsonObject.get(filedName));
        }
        return sql;
    }

    private static String replaceMatcher(String sql, List<Object> params, Map<String, Object> jsonObject) {
        Pattern pattern = Pattern.compile("(\\$\\{((?!}).)*\\})");
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            String matcherName = matcher.group();
            String filedName = BaseJdbcTemplate.getFiledName(matcherName, "$");
            sql = sql.replace(matcherName, String.valueOf(jsonObject.get(filedName)));
        }
        return sql;
    }

    private static String getFiledName(String matcherStr, String startStr) {
        return matcherStr.replace(startStr + "{", "").replace("}", "");
    }
}

