/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.helper.templete.base;

import com.magician.jdbc.core.util.JSONUtil;
import com.magician.jdbc.helper.DBHelper;
import com.magician.jdbc.helper.manager.ConnectionManager;
import com.magician.jdbc.helper.templete.base.BaseJdbcTemplate;
import com.magician.jdbc.helper.templete.model.SqlBuilderModel;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BaseSelect {
    public static <T> List<T> selectList(String sql, Object param, Class<T> cls, String dataSourceName) throws Exception {
        try (ConnectionManager connectionManager = BaseJdbcTemplate.getConnection(dataSourceName);){
            List<Map<String, Object>> result = BaseSelect.select(sql, param, connectionManager.getConnection());
            if (result != null && result.size() > 0) {
                ArrayList<T> resultList = new ArrayList<T>();
                for (Map<String, Object> item : result) {
                    resultList.add(JSONUtil.toJavaObject(item, cls));
                }
                ArrayList<T> arrayList = resultList;
                return arrayList;
            }
        }
        return null;
    }

    protected static List<Map<String, Object>> select(String sql, Object args, Connection connection) throws Exception {
        List<Map<String, Object>> result = null;
        if (args != null) {
            if (args instanceof Object[]) {
                result = DBHelper.selectList(sql, connection, (Object[])args);
            } else {
                SqlBuilderModel sqlBuilderModel = BaseJdbcTemplate.builderSql(sql, args);
                result = DBHelper.selectList(sqlBuilderModel.getSql(), connection, sqlBuilderModel.getParams());
            }
        } else {
            result = DBHelper.selectList(sql, connection);
        }
        return result;
    }
}

