/*
 * Decompiled with CFR 0.152.
 */
package com.magician.jdbc.sqlbuild;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.magician.jdbc.core.util.StringUtil;
import java.lang.reflect.Field;

public abstract class BaseSqlBuilder {
    private String tableName;
    private String where;

    public BaseSqlBuilder byPrimaryKey(String primaryKeyName) {
        StringBuffer where = new StringBuffer();
        where.append(" where ");
        where.append(primaryKeyName);
        where.append("=#{");
        where.append(primaryKeyName);
        where.append("}");
        this.where = where.toString();
        return this;
    }

    public BaseSqlBuilder where(String whereStr) {
        StringBuffer where = new StringBuffer();
        where.append(" where ");
        where.append(whereStr);
        this.where = where.toString();
        return this;
    }

    public abstract String builder() throws Exception;

    protected String getFieldName(Field field) {
        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
        if (jsonProperty == null || StringUtil.isNull(jsonProperty.value())) {
            return field.getName();
        }
        return jsonProperty.value();
    }

    protected boolean ignore(Field field) {
        JsonIgnore jsonIgnore = field.getAnnotation(JsonIgnore.class);
        return jsonIgnore != null;
    }

    protected StringBuffer getCol(Field[] fields) {
        StringBuffer sql = new StringBuffer();
        boolean isFirst = true;
        for (Field field : fields) {
            if (this.ignore(field)) continue;
            String fieldName = this.getFieldName(field);
            if (!isFirst) {
                sql.append(",");
            }
            sql.append(fieldName);
            isFirst = false;
        }
        return sql;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }
}

