/*
 * Decompiled with CFR 0.152.
 */
package com.martian.starter;

import com.alibaba.druid.pool.DruidDataSource;
import com.magician.jdbc.MagicianJDBC;
import com.martian.annotation.MartianScan;
import com.martian.cache.MartianConfigCache;
import com.martian.config.MartianConfig;
import com.martian.starter.load.LoadJDBC;
import com.martian.starter.load.LoadServer;
import com.martian.starter.load.LoadWeb;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartMartian {
    private static Logger logger = LoggerFactory.getLogger(StartMartian.class);

    public static void start(Class<?> cls, MartianConfig martianConfig) {
        try {
            MartianScan martianScan = cls.getAnnotation(MartianScan.class);
            if (martianScan == null) {
                throw new Exception("\u542f\u52a8\u7c7b\u4e0a\u7f3a\u5c11MartianScan\u6ce8\u89e3");
            }
            MartianConfigCache.setMartianScan(martianScan);
            MartianConfigCache.saveConfig(martianConfig);
            StartMartian.loadJDBC();
            StartMartian.loadWeb();
            StartMartian.loadServer();
        }
        catch (Exception e) {
            logger.error("\u542f\u52a8\u670d\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    private static void loadServer() throws Exception {
        logger.info("\u5f00\u59cb\u52a0\u8f7dServer\u6a21\u5757");
        LoadServer.load();
    }

    private static void loadWeb() throws Exception {
        logger.info("\u5f00\u59cb\u52a0\u8f7dWeb\u6a21\u5757");
        LoadWeb.load();
    }

    private static void loadJDBC() throws Exception {
        logger.info("\u5f00\u59cb\u52a0\u8f7dJDBC\u6a21\u5757");
        LoadJDBC.load();
        Map<String, DruidDataSource> druidDataSourceMap = LoadJDBC.getDruidDataSourceMap();
        MagicianJDBC magicianJDBC = MagicianJDBC.createJDBC();
        for (String name : druidDataSourceMap.keySet()) {
            magicianJDBC.addDataSource(name, (DataSource)druidDataSourceMap.get(name));
        }
        magicianJDBC.defaultDataSourceName(LoadJDBC.getDefaultName());
    }
}

