/*
 * Decompiled with CFR 0.152.
 */
package com.martian.starter.load;

import com.alibaba.druid.pool.DruidDataSource;
import com.martian.cache.MartianConfigCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class LoadJDBC {
    private static Map<String, DruidDataSource> druidDataSourceMap;
    private static String defaultName;

    public static Map<String, DruidDataSource> getDruidDataSourceMap() {
        return druidDataSourceMap;
    }

    public static String getDefaultName() {
        return defaultName;
    }

    public static void load() throws Exception {
        druidDataSourceMap = new HashMap<String, DruidDataSource>();
        List<Properties> propertiesList = MartianConfigCache.getMartianConfig().jdbcProperties();
        if (propertiesList == null || propertiesList.size() < 1) {
            return;
        }
        boolean settingDefault = false;
        for (Properties properties : propertiesList) {
            if (properties.getProperty("name") == null) {
                throw new Exception("jdbc\u914d\u7f6e\u7f3a\u5c11name\u5c5e\u6027");
            }
            if (!settingDefault) {
                defaultName = properties.get("name").toString();
                settingDefault = true;
            }
            DruidDataSource druidDataSource = LoadJDBC.initDataSource(properties);
            druidDataSourceMap.put(properties.get("name").toString(), druidDataSource);
        }
    }

    private static DruidDataSource initDataSource(Properties dataSource) throws Exception {
        DruidDataSource druidDataSource = new DruidDataSource();
        Properties properties = new Properties();
        Set<Object> proSet = dataSource.keySet();
        if (proSet == null) {
            throw new Exception("jdbc\u914d\u7f6e\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u5c5e\u6027");
        }
        for (Object key : proSet) {
            properties.put("druid." + key, dataSource.get(key));
        }
        druidDataSource.configFromPropety(properties);
        return druidDataSource;
    }
}

