/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.util.StrUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.annotation.AutoFullOssUrl;
import com.suke.zhjg.common.autofull.entity.OssEntity;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullOssUrl.class)
public class AutoFullOssURLService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullOssURLService.class);
    @Autowired
    public OssEntity ossEntity;

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            if (annotation instanceof AutoFullOssUrl) {
                field.setAccessible(true);
                String data = (String)field.get(obj);
                if (StrUtil.isNotEmpty((CharSequence)data) && StrUtil.isNotBlank((CharSequence)data)) {
                    String previewUrl = this.ossEntity.getPreviewUrl();
                    String bucketName = this.ossEntity.getBucketName();
                    if (data.contains(previewUrl)) {
                        field.set(obj, data);
                        return;
                    }
                    if (previewUrl != null && bucketName != null) {
                        String url = previewUrl + "/" + bucketName + "/" + data;
                        if (this.configProperties.isShowLog()) {
                            log.info("ID:{}, LEVEL:{}, \u586b\u5145\u5730\u5740:{}", new Object[]{sequence, level, url});
                        }
                        field.set(obj, url);
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145MinioURL\u5931\u8d25,{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

