/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.interceptor;

import cn.hutool.core.collection.CollUtil;
import com.suke.zhjg.common.autofull.cache.AutoFullRedisCache;
import com.suke.zhjg.common.autofull.util.SQLTableUtil;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SqlInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SqlInterceptor.class);
    public final String boundSqlStr = "delegate.boundSql.sql";

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        if (!(target instanceof Executor)) {
            StatementHandler statementHandler = (StatementHandler)target;
            if (null != args) {
                statementHandler = (StatementHandler)SqlInterceptor.realTarget(statementHandler);
                MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
                String originalSql = (String)metaStatementHandler.getValue("delegate.boundSql.sql");
                String sqlHead = originalSql.substring(0, originalSql.indexOf(" ")).toLowerCase();
                List<Object> tables = new ArrayList();
                switch (sqlHead) {
                    case "insert": {
                        Insert insert = (Insert)CCJSqlParserUtil.parse((String)originalSql);
                        tables = SQLTableUtil.getTableName((Statement)insert);
                        break;
                    }
                    case "update": {
                        Update update = (Update)CCJSqlParserUtil.parse((String)originalSql);
                        tables = SQLTableUtil.getTableName((Statement)update);
                        break;
                    }
                    case "delete": {
                        Delete delete = (Delete)CCJSqlParserUtil.parse((String)originalSql);
                        tables = SQLTableUtil.getTableName((Statement)delete);
                    }
                }
                if (CollUtil.isNotEmpty(tables)) {
                    tables.forEach(table -> AutoFullRedisCache.deleteData(null, table));
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor || target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return SqlInterceptor.realTarget(metaObject.getValue("h.target"));
        }
        return (T)target;
    }
}

