/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.sql;

import cn.hutool.core.util.ArrayUtil;
import com.suke.zhjg.common.autofull.config.ApplicationContextRegister;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public final class AutoFullSqlJdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(AutoFullSqlJdbcTemplate.class);

    private static JdbcTemplate getJdbcTemplate() {
        JdbcTemplate jdbcTemplate = (JdbcTemplate)ApplicationContextRegister.getApplicationContext().getBean(JdbcTemplate.class);
        return jdbcTemplate;
    }

    public static <T> T queryObj(String sql, Class<T> resultType, Object ... params) {
        JdbcTemplate jdbcTemplate = AutoFullSqlJdbcTemplate.getJdbcTemplate();
        if (ArrayUtil.isNotEmpty((Object[])params)) {
            try {
                return (T)jdbcTemplate.queryForObject(sql, resultType, params);
            }
            catch (EmptyResultDataAccessException e) {
                return null;
            }
        }
        try {
            return (T)jdbcTemplate.queryForObject(sql, resultType);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public static <T> List<T> queryList(String sql, RowMapper<T> resultType, Object ... params) {
        JdbcTemplate jdbcTemplate = AutoFullSqlJdbcTemplate.getJdbcTemplate();
        if (ArrayUtil.isNotEmpty((Object[])params)) {
            String name = ((BeanPropertyRowMapper)resultType).getMappedClass().getName();
            if (name != null) {
                if (name.equals("java.lang.Integer")) {
                    return jdbcTemplate.queryForList(sql, Integer.class, params);
                }
                if (name.equals("java.lang.Long")) {
                    return jdbcTemplate.queryForList(sql, Long.class, params);
                }
                return jdbcTemplate.query(sql, resultType, params);
            }
            return jdbcTemplate.query(sql, resultType, params);
        }
        return jdbcTemplate.query(sql, resultType);
    }

    private AutoFullSqlJdbcTemplate() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

