/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc;

import com.nway.spring.jdbc.bean.BeanHandler;
import com.nway.spring.jdbc.bean.BeanListHandler;
import com.nway.spring.jdbc.bean.processor.BeanProcessor;
import com.nway.spring.jdbc.bean.processor.ColumnMapRowMapper;
import com.nway.spring.jdbc.bean.processor.DefaultBeanProcessor;
import com.nway.spring.jdbc.pagination.MysqlPaginationSupport;
import com.nway.spring.jdbc.pagination.OraclePaginationSupport;
import com.nway.spring.jdbc.pagination.Page;
import com.nway.spring.jdbc.pagination.PageDialect;
import com.nway.spring.jdbc.pagination.PaginationSupport;
import com.nway.spring.jdbc.sql.SQL;
import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.BatchInsertBuilder;
import com.nway.spring.jdbc.sql.builder.BatchUpdateBuilder;
import com.nway.spring.jdbc.sql.builder.BatchUpdateByIdBuilder;
import com.nway.spring.jdbc.sql.builder.DeleteBuilder;
import com.nway.spring.jdbc.sql.builder.ISqlBuilder;
import com.nway.spring.jdbc.sql.builder.MultiValQueryBuilder;
import com.nway.spring.jdbc.sql.builder.QueryBuilder;
import com.nway.spring.jdbc.sql.builder.UpdateBeanBuilder;
import com.nway.spring.jdbc.sql.fill.incrementer.IdWorker;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.MultiValueColumnInfo;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class SqlExecutor
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final boolean isDebugEnabled = this.logger.isDebugEnabled();
    private PaginationSupport paginationSupport;
    private JdbcTemplate jdbcTemplate;
    private DataSource dataSource;
    private BeanProcessor beanProcessor;
    private static final ColumnMapRowMapper COLUMN_MAP_ROW_MAPPER = new ColumnMapRowMapper();

    public SqlExecutor() {
    }

    public SqlExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int update(ISqlBuilder sqlBuilder) {
        String sql = sqlBuilder.getSql();
        Object[] params = sqlBuilder.getParam().toArray();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(params)));
        }
        return this.jdbcTemplate.update(sql, params);
    }

    public int updateById(Object obj) {
        return this.updateById(obj, new String[0]);
    }

    @SafeVarargs
    public final <T, R> int updateById(Object obj, SFunction<T, R> ... columns) {
        Class<?> beanClass = obj.getClass();
        String[] columnArr = (String[])Arrays.stream(columns).map(column -> SqlBuilderUtils.getColumn(beanClass, column)).toArray(String[]::new);
        return this.updateById(obj, columnArr);
    }

    private int updateById(Object obj, String ... columns) {
        Class<?> beanClass = obj.getClass();
        UpdateBeanBuilder sqlBuilder = new UpdateBeanBuilder(obj).columns(columns);
        sqlBuilder.eq(SqlBuilderUtils.getIdName(beanClass), SqlBuilderUtils.getIdValue(beanClass, obj));
        int count = this.update(sqlBuilder);
        this.saveMultiValue(beanClass, Collections.singletonList(obj), columns, true);
        return count;
    }

    public <T> int batchUpdateById(List<?> objs) {
        return this.batchUpdateById(objs, new String[0]);
    }

    @SafeVarargs
    public final <T, R> int batchUpdateById(List<?> objs, SFunction<T, R> ... columns) {
        Class<?> beanClass = objs.get(0).getClass();
        String[] columnArr = (String[])Arrays.stream(columns).map(column -> SqlBuilderUtils.getColumn(beanClass, column)).toArray(String[]::new);
        return this.batchUpdateById(objs, columnArr);
    }

    public int batchUpdateById(List<?> objs, String ... columns) {
        if (objs == null || objs.size() == 0) {
            return 0;
        }
        Class<?> beanClass = objs.get(0).getClass();
        BatchUpdateByIdBuilder sqlBuilder = new BatchUpdateByIdBuilder(beanClass).columns(columns).use(objs);
        String sql = sqlBuilder.getSql();
        List<Object> params = sqlBuilder.getParam();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(params.toArray())));
        }
        this.saveMultiValue(beanClass, objs, columns, true);
        int[] effect = this.jdbcTemplate.batchUpdate(sql, params, params.size() == 0 ? new int[]{} : this.getSqlType((Object[])params.get(0)));
        return Arrays.stream(effect).filter(c -> c > 0).sum();
    }

    public int batchUpdate(ISqlBuilder sqlBuilder) {
        String sql = sqlBuilder.getSql();
        List<Object> params = sqlBuilder.getParam();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(params.toArray())));
        }
        if (sqlBuilder instanceof BatchUpdateBuilder) {
            this.saveMultiValue(sqlBuilder.getBeanClass(), ((BatchUpdateBuilder)sqlBuilder).getData(), null, true);
        }
        int[] effect = this.jdbcTemplate.batchUpdate(sql, params, params.size() == 0 ? new int[]{} : this.getSqlType((Object[])params.get(0)));
        return Arrays.stream(effect).filter(c -> c > 0).sum();
    }

    public int deleteById(Serializable id, Class<?> beanClass) {
        DeleteBuilder sqlBuilder = new DeleteBuilder(beanClass);
        sqlBuilder.eq(SqlBuilderUtils.getIdName(beanClass), (Object)id);
        return this.update(sqlBuilder);
    }

    public int delete(ISqlBuilder sqlBuilder) {
        return this.update(sqlBuilder);
    }

    public int batchDeleteById(Collection<? extends Serializable> ids, Class<?> beanClass) {
        DeleteBuilder sqlBuilder = new DeleteBuilder(beanClass);
        sqlBuilder.in(SqlBuilderUtils.getIdName(beanClass), ids);
        return this.update(sqlBuilder);
    }

    public int insert(Object obj) {
        Class<?> beanClass = obj.getClass();
        int count = this.update(SQL.insert(beanClass).use(obj));
        this.saveMultiValue(beanClass, Collections.singletonList(obj), null, false);
        return count;
    }

    public int batchInsert(List<?> objs) {
        if (objs == null || objs.size() == 0) {
            return 0;
        }
        BatchInsertBuilder sqlBuilder = new BatchInsertBuilder(objs.get(0).getClass()).use(objs);
        String sql = sqlBuilder.getSql();
        List<Object> params = sqlBuilder.getParam();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(params)));
        }
        int[] count = this.jdbcTemplate.batchUpdate(sql, params);
        this.saveMultiValue(sqlBuilder.getBeanClass(), objs, null, false);
        return count.length;
    }

    public <T> T queryById(Serializable id, Class<T> type) {
        Object queryBuilder = SQL.query(type).eq(SqlBuilderUtils.getIdName(type), (Object)id);
        String sql = queryBuilder.getSql();
        Object[] params = queryBuilder.getParam().toArray(new Object[0]);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(params)));
        }
        return (T)this.jdbcTemplate.query(sql, params, this.getSqlType(params), new BeanHandler<T>(type, this.beanProcessor));
    }

    public <T> T queryById(Serializable id, Class<T> type, String ... mvColNames) {
        QueryBuilder queryBuilder = (QueryBuilder)SQL.query(type).eq(SqlBuilderUtils.getIdName(type), (Object)id);
        queryBuilder.withMVColumn(mvColNames);
        T bean = this.queryById(id, type);
        this.fillMultiValue(queryBuilder, Collections.singletonList(bean));
        return bean;
    }

    @SafeVarargs
    public final <T> T queryById(Serializable id, Class<T> type, SFunction<T, ?> ... mvFields) {
        QueryBuilder queryBuilder = (QueryBuilder)SQL.query(type).eq(SqlBuilderUtils.getIdName(type), (Object)id);
        queryBuilder.withMVColumn(mvFields);
        T bean = this.queryById(id, type);
        this.fillMultiValue(queryBuilder, Collections.singletonList(bean));
        return bean;
    }

    public <T> T queryBean(String sql, Class<T> type, Object ... args) throws DataAccessException {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(args)));
        }
        return (T)this.jdbcTemplate.query(sql, args, this.getSqlType(args), new BeanHandler<T>(type, this.beanProcessor));
    }

    public <T> T queryFirst(ISqlBuilder sqlBuilder) throws DataAccessException {
        String sql = sqlBuilder.getSql();
        List params = Optional.ofNullable(sqlBuilder.getParam()).orElse(new ArrayList());
        PageDialect pageDialect = this.paginationSupport.buildPaginationSql(sql, 1, 1);
        params.add(pageDialect.getFirstParam());
        params.add(pageDialect.getSecondParam());
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + pageDialect.getSql()));
            this.logger.debug((Object)("params = " + this.objToStr(params)));
        }
        Object[] realParams = params.toArray();
        Object bean = this.jdbcTemplate.query(pageDialect.getSql(), realParams, this.getSqlType(realParams), new BeanHandler(sqlBuilder.getBeanClass(), this.beanProcessor));
        this.fillMultiValue(sqlBuilder, Collections.singletonList(bean));
        return (T)bean;
    }

    public <T> T queryOne(ISqlBuilder sqlBuilder) throws DataAccessException {
        String sql = sqlBuilder.getSql();
        List params = Optional.ofNullable(sqlBuilder.getParam()).orElse(new ArrayList());
        PageDialect pageDialect = this.paginationSupport.buildPaginationSql(sql, 1, 2);
        params.add(pageDialect.getFirstParam());
        params.add(pageDialect.getSecondParam());
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + pageDialect.getSql()));
            this.logger.debug((Object)("params = " + this.objToStr(params)));
        }
        Object[] realParams = params.toArray();
        Object bean = this.jdbcTemplate.query(pageDialect.getSql(), realParams, this.getSqlType(realParams), new BeanHandler(sqlBuilder.getBeanClass(), this.beanProcessor));
        this.fillMultiValue(sqlBuilder, Collections.singletonList(bean));
        return (T)bean;
    }

    public <T> List<T> queryList(ISqlBuilder queryBuilder) throws DataAccessException {
        List beanList = this.queryList(queryBuilder.getSql(), queryBuilder.getBeanClass(), queryBuilder.getParam().toArray());
        this.fillMultiValue(queryBuilder, beanList);
        return beanList;
    }

    public <T, R> Map<R, T> queryListMap(ISqlBuilder queryBuilder, Function<T, R> key) {
        List<T> dataList = this.queryList(queryBuilder);
        this.fillMultiValue(queryBuilder, dataList);
        return dataList.stream().collect(Collectors.toMap(key, Function.identity()));
    }

    public <T> List<T> queryList(Collection<? extends Serializable> ids, Class<T> type) {
        Object queryBuilder = SQL.query(type).in(SqlBuilderUtils.getIdName(type), ids);
        return this.queryList((ISqlBuilder)queryBuilder);
    }

    public <T, R> Map<R, T> queryListMap(Collection<? extends Serializable> ids, Class<T> type, Function<T, R> key) {
        List<T> dataList = this.queryList(ids, type);
        return dataList.stream().collect(Collectors.toMap(key, Function.identity()));
    }

    public <T> List<T> queryList(String sql, Class<T> type, Object ... args) throws DataAccessException {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(args)));
        }
        List retVal = (List)this.jdbcTemplate.query(sql, args, this.getSqlType(args), new BeanListHandler<T>(type, this.beanProcessor));
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("total = " + (retVal == null ? 0 : retVal.size())));
        }
        return retVal;
    }

    public <T> Page<T> queryPage(ISqlBuilder queryBuilder, int page, int pageSize) throws DataAccessException {
        Page pageData = this.queryPage(queryBuilder.getSql(), queryBuilder.getParam().toArray(), page, pageSize, queryBuilder.getBeanClass());
        this.fillMultiValue(queryBuilder, pageData.getPageData());
        return pageData;
    }

    public <T> Page<T> queryPage(String sql, Object[] params, int page, int pageSize, Class<T> beanClass) throws DataAccessException {
        List<Object> item = new ArrayList();
        String countSql = this.buildPaginationCountSql(sql);
        int totalCount = this.queryCount(countSql, params);
        if (totalCount != 0) {
            PageDialect pageDialect = this.paginationSupport.buildPaginationSql(sql, page, pageSize);
            Object[] realParam = new Object[params.length + 2];
            System.arraycopy(params, 0, realParam, 0, params.length);
            realParam[realParam.length - 2] = pageDialect.getFirstParam();
            realParam[realParam.length - 1] = pageDialect.getSecondParam();
            item = this.queryList(pageDialect.getSql(), beanClass, realParam);
        }
        return new Page(item, totalCount, page, pageSize);
    }

    public Page<Map<String, Object>> queryPage(String sql, Object[] params, int page, int pageSize) throws DataAccessException {
        List item = new ArrayList();
        String countSql = this.buildPaginationCountSql(sql);
        int totalCount = this.queryCount(countSql, params);
        if (totalCount != 0) {
            PageDialect pageDialect = this.paginationSupport.buildPaginationSql(sql, page, pageSize);
            int paramsLength = params == null ? 0 : params.length;
            Object[] realParam = new Object[paramsLength + 2];
            System.arraycopy(params == null ? new Object[]{} : params, 0, realParam, 0, paramsLength);
            realParam[realParam.length - 2] = pageDialect.getFirstParam();
            realParam[realParam.length - 1] = pageDialect.getSecondParam();
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("sql = " + pageDialect.getSql()));
                this.logger.debug((Object)("params = " + this.objToStr(realParam)));
            }
            item = this.jdbcTemplate.query(pageDialect.getSql(), realParam, this.getSqlType(realParam), (RowMapper)COLUMN_MAP_ROW_MAPPER);
        }
        return new Page<Map<String, Object>>(item, totalCount, page, pageSize);
    }

    public int count(ISqlBuilder queryBuilder) throws DataAccessException {
        String sql = this.buildPaginationCountSql(queryBuilder.getSql());
        Object[] params = queryBuilder.getParam().toArray();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(params)));
        }
        return (Integer)this.jdbcTemplate.queryForObject(sql, params, this.getSqlType(params), Integer.class);
    }

    public boolean exist(ISqlBuilder queryBuilder) {
        QueryBuilder queryBuilder1;
        if (queryBuilder instanceof QueryBuilder && CollectionUtils.isEmpty((queryBuilder1 = (QueryBuilder)queryBuilder).getColumns())) {
            queryBuilder1.withColumn(SqlBuilderUtils.getIdName(queryBuilder1.getBeanClass()));
        }
        PageDialect pageDialect = this.paginationSupport.buildPaginationSql(queryBuilder.getSql(), 1, 1);
        Object[] params = ((List)Optional.ofNullable(queryBuilder.getParam()).orElse(new ArrayList(0))).toArray();
        Object[] realParam = new Object[params.length + 2];
        System.arraycopy(params, 0, realParam, 0, params.length);
        realParam[realParam.length - 2] = pageDialect.getFirstParam();
        realParam[realParam.length - 1] = pageDialect.getSecondParam();
        String sql = pageDialect.getSql();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + sql));
            this.logger.debug((Object)("params = " + this.objToStr(realParam)));
        }
        return Boolean.TRUE.equals(this.jdbcTemplate.query(sql, realParam, this.getSqlType(realParam), ResultSet::next));
    }

    private String buildPaginationCountSql(String sql) {
        int lastFromIndex;
        int firstFromIndex;
        StringBuilder countSql = new StringBuilder(sql);
        int indexOfOrderBy = this.indexOfOrderBy(sql);
        if (indexOfOrderBy != -1) {
            countSql.delete(indexOfOrderBy - 8, countSql.length());
        }
        if ((firstFromIndex = countSql.indexOf(" from ")) != (lastFromIndex = countSql.lastIndexOf(" from "))) {
            countSql.insert(0, "select count(*) from (").append(") nway_count");
        } else if (this.indexOfDistinct(sql, firstFromIndex) == -1) {
            countSql.delete(0, firstFromIndex).insert(0, "select count(*) ");
        } else {
            countSql.insert(0, "select count(*) from (").append(") nway_count");
        }
        return countSql.toString();
    }

    private int indexOfOrderBy(String sql) {
        int idx = -1;
        char[] orderChar = new char[]{'r', 'e', 'd', 'r', 'o'};
        char[] sqlChars = sql.toCharArray();
        block0: for (int i = sqlChars.length - 1; i > -1 && sqlChars[i] != ')'; --i) {
            if (i + 2 >= sqlChars.length || sqlChars[i] != 'y' || sqlChars[i - 1] != 'b' || sqlChars[i + 1] != ' ' || sqlChars[i - 2] != ' ') continue;
            for (int n = 0; n < orderChar.length && sqlChars[i - n - 3] == orderChar[n]; ++n) {
                if (n != orderChar.length - 1 || sqlChars[i - n - 4] != ' ' && sqlChars[i - n - 4] != '\n') continue;
                idx = i;
                break block0;
            }
        }
        return idx;
    }

    private int indexOfDistinct(String sql, int end) {
        int idx = -1;
        char[] disChar = new char[]{'i', 's', 't', 'i', 'n', 'c', 't', ' '};
        char[] sqlChars = sql.toCharArray();
        block0: for (int i = 6; i < end; ++i) {
            if (i + 10 >= end || sqlChars[i] != ' ' || sqlChars[i + 1] != 'd') continue;
            for (int n = 0; n < disChar.length; ++n) {
                if (sqlChars[i + n + 2] == disChar[n]) continue;
                idx = i + n;
                break block0;
            }
        }
        return idx;
    }

    private void initPaginationSupport() {
        String databaseProductName;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            databaseProductName = conn.getMetaData().getDatabaseProductName().toUpperCase();
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("\u8bbf\u95ee\u6570\u636e\u5e93\u5931\u8d25", e);
        }
        finally {
            if (conn != null) {
                DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
            }
        }
        if (databaseProductName.contains("ORACLE")) {
            this.paginationSupport = new OraclePaginationSupport();
        } else if (databaseProductName.contains("MYSQL") || databaseProductName.contains("MARIADB")) {
            this.paginationSupport = new MysqlPaginationSupport();
        } else {
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u672c\u6570\u636e\u5e93\u7684\u5206\u9875\u64cd\u4f5c\uff0c\u8bf7\u5b9e\u73b0com.nway.spring.jdbc.pagination.PaginationSupport\u63a5\u53e3\uff0c\u901a\u8fc7\u672c\u7c7bsetPaginationSupport\u65b9\u6cd5\u5f15\u5165\u3002");
        }
    }

    private Integer queryCount(String countSql, Object[] params) {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("sql = " + countSql));
            this.logger.debug((Object)("params = " + this.objToStr(params)));
        }
        return (Integer)this.jdbcTemplate.query(countSql, params, this.getSqlType(params), (ResultSetExtractor)new IntegerResultSetExtractor(countSql));
    }

    public void afterPropertiesSet() {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
            this.jdbcTemplate.afterPropertiesSet();
        }
        if (this.getPaginationSupport() == null) {
            this.initPaginationSupport();
        }
        if (this.beanProcessor == null) {
            this.beanProcessor = new DefaultBeanProcessor();
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setPaginationSupport(PaginationSupport paginationSupport) {
        this.paginationSupport = paginationSupport;
    }

    public void setBeanProcessor(BeanProcessor beanProcessor) {
        this.beanProcessor = beanProcessor;
    }

    public BeanProcessor getBeanProcessor() {
        return this.beanProcessor;
    }

    private int firstFromIndex(StringBuilder sql) {
        int fromIndex = sql.indexOf(" from ");
        if (fromIndex == -1) {
            fromIndex = sql.indexOf(" FROM ");
        }
        return fromIndex;
    }

    private int lastFromIndex(StringBuilder sql) {
        int fromIndex = sql.lastIndexOf(" from ");
        if (fromIndex == -1) {
            fromIndex = sql.lastIndexOf(" FROM ");
        }
        return fromIndex;
    }

    private <T> void fillMultiValue(ISqlBuilder queryBuilder, List<T> beanList) {
        if (beanList == null || beanList.isEmpty() || beanList.size() == 1 && beanList.get(0) == null) {
            return;
        }
        List<String> multiValColumn = null;
        if (queryBuilder instanceof MultiValQueryBuilder) {
            multiValColumn = ((MultiValQueryBuilder)((Object)queryBuilder)).getMultiValColumn();
        }
        if (CollectionUtils.isEmpty(multiValColumn)) {
            return;
        }
        Class type = queryBuilder.getBeanClass();
        List<MultiValueColumnInfo> multiValueList = SqlBuilderUtils.getEntityInfo(type).getMultiValue();
        if (CollectionUtils.isEmpty(multiValColumn)) {
            multiValColumn = multiValueList.stream().map(ColumnInfo::getColumnName).collect(Collectors.toList());
        }
        if (!multiValueList.isEmpty()) {
            for (MultiValueColumnInfo columnInfo : multiValueList) {
                String columnName = columnInfo.getColumnName();
                if (!multiValColumn.contains(columnName)) continue;
                HashMap<Object, T> rows = new HashMap<Object, T>(beanList.size());
                for (T bean : beanList) {
                    rows.put(SqlBuilderUtils.getIdValue(type, bean), bean);
                }
                StringBuilder subSql = new StringBuilder(64).append("select ").append(columnInfo.getFk()).append(",").append(columnName).append(" from ").append(columnInfo.getTable()).append(" where ").append(columnInfo.getFk()).append(" in (");
                Object[] idValueArr = rows.keySet().toArray(new Object[0]);
                String placeholder = IntStream.range(0, idValueArr.length).mapToObj(a -> "?").collect(Collectors.joining(","));
                subSql.append(placeholder).append(") order by ").append(columnInfo.getIdx());
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("sql = " + subSql));
                    this.logger.debug((Object)("params = " + this.objToStr(idValueArr)));
                }
                List subVal = this.jdbcTemplate.queryForList(subSql.toString(), idValueArr);
                HashMap<Object, List> group = new HashMap<Object, List>(idValueArr.length);
                for (Map map : subVal) {
                    Object foreignKey = map.get(columnInfo.getFk());
                    List row = group.computeIfAbsent(foreignKey, k -> new ArrayList());
                    row.add(map.get(columnName));
                }
                try {
                    for (Map.Entry entry : group.entrySet()) {
                        columnInfo.getReadMethod().set(rows.get(entry.getKey()), entry.getValue());
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    protected <T> void saveMultiValue(Class<?> type, List<T> beanList, String[] expectColumns, boolean nedDel) {
        List<MultiValueColumnInfo> multiValueList = SqlBuilderUtils.getEntityInfo(type).getMultiValue();
        if (multiValueList.isEmpty()) {
            return;
        }
        List<String> columns = Arrays.asList(Optional.ofNullable(expectColumns).orElse(new String[0]));
        HashMap idValMap = new HashMap(beanList.size());
        for (MultiValueColumnInfo columnInfo : multiValueList) {
            String columnName = columnInfo.getColumnName();
            if (!columns.isEmpty() && !columns.contains(columnName)) continue;
            HashMap<Object, List> data = new HashMap<Object, List>();
            for (Object bean : beanList) {
                Object value = SqlBuilderUtils.getColumnValue(columnInfo, bean, SqlType.INSERT);
                if (value == null) continue;
                Object fk = Optional.ofNullable(idValMap.get(bean.hashCode())).orElseGet(() -> {
                    Object idValue = SqlBuilderUtils.getIdValue(type, bean);
                    idValMap.put(bean.hashCode(), idValue);
                    return idValue;
                });
                data.put(fk, (List)value);
            }
            if (data.isEmpty()) continue;
            if (nedDel) {
                StringBuilder delSql = new StringBuilder(64).append("delete from ").append(columnInfo.getTable()).append(" where ").append(columnInfo.getFk()).append(" in (");
                String placeholder = IntStream.range(0, data.size()).mapToObj(a -> "?").collect(Collectors.joining(","));
                delSql.append(placeholder).append(")");
                Object[] idValueArr = idValMap.values().toArray(new Object[0]);
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("sql = " + delSql));
                    this.logger.debug((Object)("params = " + this.objToStr(idValueArr)));
                }
                this.jdbcTemplate.update(delSql.toString(), idValueArr);
            }
            StringBuilder insertSql = new StringBuilder(64).append("insert into ").append(columnInfo.getTable()).append(" (").append(columnInfo.getKey()).append(",").append(columnInfo.getFk()).append(",").append(columnName).append(",").append(columnInfo.getIdx()).append(") values (?,?,?,?)");
            for (Map.Entry entry : data.entrySet()) {
                Collection entryValue = (Collection)entry.getValue();
                if (entryValue.isEmpty()) continue;
                ArrayList<Object[]> rows = new ArrayList<Object[]>(entryValue.size());
                int idx = 0;
                for (Object bizVal : entryValue) {
                    rows.add(new Object[]{IdWorker.getId(), entry.getKey(), bizVal, ++idx});
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("sql = " + insertSql));
                    this.logger.debug((Object)("params = " + this.objToStr(rows)));
                }
                this.jdbcTemplate.batchUpdate(insertSql.toString(), rows);
            }
        }
    }

    private String objToStr(Object obj) {
        if (ObjectUtils.isArray((Object)obj)) {
            return Arrays.deepToString((Object[])obj);
        }
        if (obj instanceof List) {
            return Arrays.deepToString(((List)obj).toArray());
        }
        return ObjectUtils.nullSafeToString((Object)obj);
    }

    private int[] getSqlType(Object[] objs) {
        if (objs == null) {
            return null;
        }
        if (objs.length == 0) {
            return new int[0];
        }
        return Arrays.stream(objs).map(obj -> {
            if (obj == null) {
                return Integer.MIN_VALUE;
            }
            return StatementCreatorUtils.javaTypeToSqlParameterType(obj.getClass());
        }).mapToInt(x -> x).toArray();
    }

    private static class IntegerResultSetExtractor
    implements ResultSetExtractor<Integer> {
        private final String sql;

        IntegerResultSetExtractor(String sql) {
            this.sql = sql;
        }

        public Integer extractData(ResultSet rs) {
            try {
                return rs.next() ? rs.getInt(1) : 0;
            }
            catch (SQLException e) {
                throw new InvalidResultSetAccessException("\u83b7\u53d6\u603b\u6570\u636e\u91cf\u5931\u8d25", this.sql, e);
            }
        }
    }
}

