/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.bean.processor;

import com.nway.spring.jdbc.bean.processor.BeanProcessor;
import com.nway.spring.jdbc.bean.processor.DefaultRowMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.support.JdbcUtils;

public class DefaultBeanProcessor
implements BeanProcessor {
    private static final ConcurrentMap<String, DefaultRowMapper> localCache = new ConcurrentHashMap<String, DefaultRowMapper>(256);

    @Override
    public <T> List<T> toBeanList(ResultSet rs, Class<T> mappedClass) throws SQLException {
        int rowNum = 0;
        Map<String, Integer> columnIndex = this.getColumnIndex(rs);
        String cacheKey = mappedClass.hashCode() + columnIndex.keySet().stream().sorted().collect(Collectors.joining());
        DefaultRowMapper mapper = Optional.ofNullable((DefaultRowMapper)localCache.get(cacheKey)).orElseGet(() -> {
            DefaultRowMapper rowMapper = new DefaultRowMapper(mappedClass);
            localCache.put(cacheKey, rowMapper);
            return rowMapper;
        }).setColumnIndexMap(columnIndex);
        ArrayList results = new ArrayList();
        while (rs.next()) {
            results.add(mapper.mapRow(rs, rowNum++));
        }
        return results;
    }

    @Override
    public <T> T toBean(ResultSet rs, Class<T> mappedClass) throws SQLException {
        Map<String, Integer> columnIndex = this.getColumnIndex(rs);
        String cacheKey = mappedClass.hashCode() + columnIndex.keySet().stream().sorted().collect(Collectors.joining());
        DefaultRowMapper mapper = Optional.ofNullable((DefaultRowMapper)localCache.get(cacheKey)).orElseGet(() -> {
            DefaultRowMapper rowMapper = new DefaultRowMapper(mappedClass);
            localCache.put(cacheKey, rowMapper);
            return rowMapper;
        }).setColumnIndexMap(columnIndex);
        Object row = mapper.mapRow(rs, 0);
        if (rs.next()) {
            throw new IncorrectResultSizeDataAccessException("\u67e5\u8be2\u5230\u591a\u6761\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e", 1);
        }
        return row;
    }

    private Map<String, Integer> getColumnIndex(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        HashMap<String, Integer> columnIndex = new HashMap<String, Integer>(columnCount);
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
            columnIndex.put(column, index);
        }
        return columnIndex;
    }
}

