/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.bean.processor;

import com.nway.spring.jdbc.annotation.Column;
import com.nway.spring.jdbc.sql.builder.SqlBuilderException;
import com.nway.spring.jdbc.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultRowMapper<T>
implements RowMapper<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private Class<T> mappedClass;
    @Nullable
    private Map<String, Field> mappedFields;
    @Nullable
    private Set<String> mappedProperties;
    private Map<String, Integer> columnIndexMap;

    public DefaultRowMapper(Class<T> mappedClass) {
        this.initialize(mappedClass);
    }

    public DefaultRowMapper<T> setColumnIndexMap(Map<String, Integer> columnIndexMap) {
        this.columnIndexMap = columnIndexMap;
        return this;
    }

    public void setMappedClass(Class<T> mappedClass) {
        if (this.mappedClass == null) {
            this.initialize(mappedClass);
        } else if (this.mappedClass != mappedClass) {
            throw new InvalidDataAccessApiUsageException("The mapped class can not be reassigned to map to " + mappedClass + " since it is already providing mapping for " + this.mappedClass);
        }
    }

    protected void initialize(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, Field>();
        this.mappedProperties = new HashSet<String>();
        for (Field field : ReflectionUtils.getAllFields(mappedClass)) {
            field.setAccessible(true);
            this.mappedFields.put(this.annotationName(field), field);
            this.mappedProperties.add(field.getName());
        }
    }

    protected String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('_').append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String annotationName(Field field) {
        Column columnAnnotation = field.getAnnotation(Column.class);
        if (columnAnnotation != null) {
            String columnName;
            String string = columnName = columnAnnotation.value().length() == 0 ? columnAnnotation.name() : columnAnnotation.value();
            if (columnName != null && columnName.length() != 0) {
                return columnName;
            }
        }
        return this.underscoreName(field.getName());
    }

    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        T mappedObject = this.getBeanInstance();
        for (Map.Entry<String, Integer> entry : this.columnIndexMap.entrySet()) {
            Field pd;
            String column = entry.getKey();
            Field field = pd = this.mappedFields != null ? this.mappedFields.get(column) : null;
            if (pd != null) {
                try {
                    Class<?> pdType = pd.getType();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Mapping column '" + column + "' to property '" + pd.getName() + "' of type '" + ClassUtils.getQualifiedName(pdType) + "' index " + entry.getValue()));
                    }
                    Object value = this.getColumnValue(rs, entry.getValue(), pdType);
                    this.setVal(mappedObject, pd, value);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new DataRetrievalFailureException("Unable to map column '" + column + "' to property '" + pd.getName() + "'", (Throwable)ex);
                }
            }
            if (rowNumber != 0 || !this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("No property found for column '" + column + "' mapped"));
        }
        return mappedObject;
    }

    @Nullable
    protected Object getColumnValue(ResultSet rs, int index, Class<?> paramType) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index, paramType);
    }

    protected T getBeanInstance() {
        try {
            return this.mappedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SqlBuilderException(e);
        }
    }

    protected void setVal(Object mappedObject, Field field, Object value) throws IllegalAccessException {
        field.set(mappedObject, value);
    }
}

