/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.bean.processor.asm;

import com.nway.spring.jdbc.bean.processor.BeanProcessor;
import com.nway.spring.jdbc.bean.processor.asm.AsmRowMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class AsmBeanProcessor
implements BeanProcessor {
    private static final ConcurrentMap<String, AsmRowMapper> localCache = new ConcurrentHashMap<String, AsmRowMapper>(256);
    private Function<ResultSet, String> sqlExtractor;

    @Override
    public <T> List<T> toBeanList(ResultSet rs, Class<T> mappedClass) throws SQLException {
        int rowNum = 0;
        RowMapper<T> mapper = this.getMapper(rs, mappedClass);
        ArrayList<Object> results = new ArrayList<Object>();
        while (rs.next()) {
            results.add(mapper.mapRow(rs, rowNum++));
        }
        return results;
    }

    @Override
    public <T> T toBean(ResultSet rs, Class<T> mappedClass) throws SQLException {
        RowMapper<T> mapper = this.getMapper(rs, mappedClass);
        Object row = mapper.mapRow(rs, 0);
        if (rs.next()) {
            throw new IncorrectResultSizeDataAccessException("\u67e5\u8be2\u5230\u591a\u6761\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e", 1);
        }
        return (T)row;
    }

    public void setSqlExtractor(Function<ResultSet, String> extractor) {
        this.sqlExtractor = extractor;
    }

    private <T> RowMapper<T> getMapper(ResultSet rs, Class<T> mappedClass) throws SQLException {
        AsmRowMapper<T> mapper;
        String cacheKey = null;
        if (this.sqlExtractor != null) {
            cacheKey = this.sqlExtractor.apply(rs);
        }
        LinkedHashMap<String, Integer> columnIndexMap = null;
        if (cacheKey == null) {
            columnIndexMap = this.getColumnIndex(rs);
            cacheKey = columnIndexMap.keySet().stream().sorted().collect(Collectors.joining()) + mappedClass.hashCode();
        }
        if ((mapper = (AsmRowMapper<T>)localCache.get(cacheKey)) == null) {
            columnIndexMap = columnIndexMap == null ? this.getColumnIndex(rs) : columnIndexMap;
            mapper = new AsmRowMapper<T>(mappedClass, columnIndexMap);
            localCache.put(cacheKey, mapper);
        }
        return mapper;
    }

    private LinkedHashMap<String, Integer> getColumnIndex(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        LinkedHashMap<String, Integer> columnIndex = new LinkedHashMap<String, Integer>(columnCount);
        for (int index = 1; index <= columnCount; ++index) {
            columnIndex.put(JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index), index);
        }
        return columnIndex;
    }
}

