/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.bean.processor.asm;

import com.nway.spring.jdbc.bean.processor.RowMapper;
import com.nway.spring.jdbc.bean.processor.asm.DynamicBeanClassLoader;
import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.springframework.util.ClassUtils;

public class AsmRowMapper<T>
implements org.springframework.jdbc.core.RowMapper<T> {
    private static final Log log = LogFactory.getLog(AsmRowMapper.class);
    private RowMapper<T> beanAccess;

    public AsmRowMapper(Class<T> mappedClass, LinkedHashMap<String, Integer> columnIndexMap) {
        this.beanAccess = this.createBeanAccess(mappedClass, columnIndexMap);
    }

    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        return this.beanAccess.mapRow(rs);
    }

    private RowMapper<T> createBeanAccess(Class<T> type, LinkedHashMap<String, Integer> columnIndexMap) {
        ClassWriter classWriter = new ClassWriter(0);
        String beanClassName = type.getCanonicalName().replace('.', '/');
        String randomName = UUID.randomUUID().toString().replace("-", "");
        String className = beanClassName + randomName + "Mapper";
        classWriter.visit(52, 33, className, "Lcom/nway/spring/jdbc/bean/processor/RowMapper<L" + beanClassName + ";>;", "com/nway/spring/jdbc/bean/processor/RowMapper", null);
        classWriter.visitSource(type.getSimpleName() + randomName + "Mapper.java", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(9, label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "com/nway/spring/jdbc/bean/processor/RowMapper", "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", "L" + className + ";", null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "mapRow", "(Ljava/sql/ResultSet;)L" + beanClassName + ";", null, new String[]{"java/sql/SQLException"});
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(14, label0);
        methodVisitor.visitTypeInsn(187, beanClassName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, beanClassName, "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 2);
        int rowNum = 16;
        Label labelFirst = new Label();
        Map<String, ColumnInfo> fieldMap = SqlBuilderUtils.getEntityInfo(type).getColumnMap();
        Map<String, Field> columnMap = fieldMap.values().stream().collect(Collectors.toMap(ColumnInfo::getColumnName, ColumnInfo::getReadMethod));
        for (Map.Entry<String, Field> column : columnMap.entrySet()) {
            Integer colIdx = columnIndexMap.get(column.getKey());
            if (colIdx == null) continue;
            Field field = column.getValue();
            Class<?> fieldType = field.getType();
            String localGetter = this.getLocalGetter(fieldType);
            Label label12 = colIdx == 1 ? labelFirst : new Label();
            methodVisitor.visitLabel(label12);
            methodVisitor.visitLineNumber(rowNum++, label12);
            methodVisitor.visitVarInsn(25, 2);
            if (localGetter != null) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
            } else {
                methodVisitor.visitVarInsn(25, 1);
            }
            switch (colIdx) {
                case 1: {
                    methodVisitor.visitInsn(4);
                    break;
                }
                case 2: {
                    methodVisitor.visitInsn(5);
                    break;
                }
                case 3: {
                    methodVisitor.visitInsn(6);
                    break;
                }
                case 4: {
                    methodVisitor.visitInsn(7);
                    break;
                }
                case 5: {
                    methodVisitor.visitInsn(8);
                    break;
                }
                default: {
                    methodVisitor.visitIntInsn(16, colIdx.intValue());
                }
            }
            if (localGetter != null) {
                methodVisitor.visitMethodInsn(182, className, localGetter, "(Ljava/sql/ResultSet;I)" + this.getDescriptor(fieldType, true), false);
                methodVisitor.visitMethodInsn(182, beanClassName, this.getSetter(field), "(" + this.getDescriptor(fieldType, false) + ")V", false);
                continue;
            }
            if (fieldType == Date.class) {
                methodVisitor.visitMethodInsn(185, "java/sql/ResultSet", "getTimestamp", "(I)Ljava/sql/Timestamp;", true);
                methodVisitor.visitMethodInsn(182, beanClassName, this.getSetter(field), "(" + this.getDescriptor(fieldType, false) + ")V", false);
                continue;
            }
            if (fieldType == LocalDate.class) {
                methodVisitor.visitMethodInsn(185, "java/sql/ResultSet", "getDate", "(I)Ljava/sql/Date;", true);
                methodVisitor.visitMethodInsn(184, "com/nway/spring/jdbc/util/DateUtils", "toLocalDate", "(Ljava/sql/Date;)Ljava/time/LocalDate;", false);
                methodVisitor.visitMethodInsn(182, beanClassName, this.getSetter(field), "(Ljava/time/LocalDate;)V", false);
                continue;
            }
            if (fieldType == LocalDateTime.class) {
                methodVisitor.visitMethodInsn(185, "java/sql/ResultSet", "getTimestamp", "(I)Ljava/sql/Timestamp;", true);
                methodVisitor.visitMethodInsn(184, "com/nway/spring/jdbc/util/DateUtils", "toLocalDateTime", "(Ljava/sql/Timestamp;)Ljava/time/LocalDateTime;", false);
                methodVisitor.visitMethodInsn(182, beanClassName, this.getSetter(field), "(Ljava/time/LocalDateTime;)V", false);
                continue;
            }
            if (fieldType == LocalTime.class) {
                methodVisitor.visitMethodInsn(185, "java/sql/ResultSet", "getTime", "(I)Ljava/sql/Time;", true);
                methodVisitor.visitMethodInsn(184, "com/nway/spring/jdbc/util/DateUtils", "toLocalTime", "(Ljava/sql/Time;)Ljava/time/LocalTime;", false);
                methodVisitor.visitMethodInsn(182, beanClassName, this.getSetter(field), "(Ljava/time/LocalTime;)V", false);
                continue;
            }
            methodVisitor.visitMethodInsn(185, "java/sql/ResultSet", "get" + fieldType.getSimpleName(), "(I)" + this.getDescriptor(fieldType, true), true);
            methodVisitor.visitMethodInsn(182, beanClassName, this.getSetter(field), "(" + this.getDescriptor(fieldType, false) + ")V", false);
        }
        Label label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitLineNumber(rowNum, label5);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitInsn(176);
        Label label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitLocalVariable("this", "L" + className + ";", null, label0, label6, 0);
        methodVisitor.visitLocalVariable("rs", "Ljava/sql/ResultSet;", null, label0, label6, 1);
        methodVisitor.visitLocalVariable("bean", "L" + beanClassName + ";", null, labelFirst, label6, 2);
        methodVisitor.visitMaxs(4, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "mapRow", "(Ljava/sql/ResultSet;)Ljava/lang/Object;", null, new String[]{"java/sql/SQLException"});
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(9, label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, className, "mapRow", "(Ljava/sql/ResultSet;)L" + beanClassName + ";", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", "L" + className + ";", null, label0, label1, 0);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        try {
            DynamicBeanClassLoader beanClassLoader = new DynamicBeanClassLoader(ClassUtils.getDefaultClassLoader());
            Class<?> processor = beanClassLoader.defineClass(className.replace('/', '.'), classWriter.toByteArray());
            return (RowMapper)processor.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4f7f\u7528ASM\u521b\u5efa [ " + className + " ] \u5931\u8d25", e);
        }
    }

    private String getLocalGetter(Class<?> clazz) {
        if (Integer.TYPE.equals(clazz)) {
            return "getPrimitiveInteger";
        }
        if (Integer.class.equals(clazz)) {
            return "getInteger";
        }
        if (Long.TYPE.equals(clazz)) {
            return "getPrimitiveLong";
        }
        if (Long.class.equals(clazz)) {
            return "getLong";
        }
        if (Float.TYPE.equals(clazz)) {
            return "getPrimitiveFloat";
        }
        if (Float.class.equals(clazz)) {
            return "getFloat";
        }
        if (Double.TYPE.equals(clazz)) {
            return "getPrimitiveDouble";
        }
        if (Double.class.equals(clazz)) {
            return "getDouble";
        }
        if (Short.TYPE.equals(clazz)) {
            return "getPrimitiveShort";
        }
        if (Short.class.equals(clazz)) {
            return "getShort";
        }
        if (Byte.TYPE.equals(clazz)) {
            return "getPrimitiveByte";
        }
        if (Byte.class.equals(clazz)) {
            return "getByte";
        }
        if (Boolean.TYPE.equals(clazz)) {
            return "getPrimitiveBoolean";
        }
        if (Boolean.class.equals(clazz)) {
            return "getBoolean";
        }
        if (byte[].class.equals(clazz)) {
            return "getByteArr";
        }
        return null;
    }

    private String getDescriptor(Class<?> clazz, boolean forRs) {
        if (Integer.TYPE.equals(clazz)) {
            return "I";
        }
        if (Long.TYPE.equals(clazz)) {
            return "J";
        }
        if (forRs && Date.class.equals(clazz)) {
            return "Ljava/sql/Date;";
        }
        if (Float.TYPE.equals(clazz)) {
            return "F";
        }
        if (Double.TYPE.equals(clazz)) {
            return "D";
        }
        if (Boolean.TYPE.equals(clazz)) {
            return "Z";
        }
        if (Byte.TYPE.equals(clazz)) {
            return "B";
        }
        if (Short.TYPE.equals(clazz)) {
            return "S";
        }
        if (byte[].class.equals(clazz)) {
            return "[B";
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    private String getSetter(Field field) {
        String fieldName = field.getName();
        if (field.getType() == Boolean.TYPE && fieldName.startsWith("is")) {
            return "set" + fieldName.substring(2);
        }
        return "set" + this.upperFirst(field.getName());
    }

    private String upperFirst(String name) {
        char[] chars = name.toCharArray();
        return Character.toUpperCase(chars[0]) + new String(chars, 1, chars.length - 1);
    }
}

