/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.bean.processor.asm;

import java.io.File;
import java.io.IOException;
import org.springframework.util.FileCopyUtils;

public class DynamicBeanClassLoader
extends ClassLoader {
    private String fileName;

    public DynamicBeanClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public DynamicBeanClassLoader(ClassLoader classLoader, String fileName) {
        super(classLoader);
        this.fileName = fileName;
    }

    public Class<?> defineClass(String name, byte[] classContent) throws IOException {
        if (this.fileName != null) {
            this.write(classContent, this.fileName + ".class");
        }
        Class<?> classz = super.defineClass(name, classContent, 0, classContent.length);
        this.resolveClass(classz);
        return classz;
    }

    private void write(byte[] b, String filePath) throws IOException {
        boolean isScc;
        File file = new File(filePath);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !(isScc = parentFile.mkdirs())) {
            throw new IOException("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6 " + parentFile.getAbsolutePath());
        }
        FileCopyUtils.copy((byte[])b, (File)file);
    }
}

