/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.pagination;

import java.util.List;

public class Page<T> {
    private List<T> pageData;
    private int pageSize;
    private int total;
    private int pageCount;
    private int currentPage;

    public Page() {
    }

    public Page(int pageSize, int currentPage) {
        this.pageSize = pageSize;
        this.currentPage = currentPage;
    }

    public Page(List<T> pageData, int totalCount, int page, int pageSize) {
        this.pageData = pageData;
        this.total = totalCount;
        this.pageSize = pageSize;
        this.currentPage = page;
        this.init();
    }

    private void init() {
        if (this.total > 0) {
            this.pageCount = this.total / this.pageSize;
            if (this.total % this.pageSize > 0) {
                ++this.pageCount;
            }
        }
    }

    public List<T> getPageData() {
        return this.pageData;
    }

    public void setPageData(List<T> pageData) {
        this.pageData = pageData;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Pagination [totalCount=");
        builder.append(this.total);
        builder.append(", pageCount=");
        builder.append(this.pageCount);
        builder.append(", currentPage=");
        builder.append(this.currentPage);
        builder.append(", pageSize=");
        builder.append(this.pageSize);
        builder.append(", pageData=");
        builder.append(this.pageData);
        builder.append("]");
        return builder.toString();
    }
}

