/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql;

import com.nway.spring.jdbc.annotation.Column;
import com.nway.spring.jdbc.annotation.MultiColumn;
import com.nway.spring.jdbc.annotation.Table;
import com.nway.spring.jdbc.annotation.enums.ColumnType;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.SqlBuilderException;
import com.nway.spring.jdbc.sql.fill.NoneFillStrategy;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.function.SSupplier;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import com.nway.spring.jdbc.sql.meta.MultiValueColumnInfo;
import com.nway.spring.jdbc.sql.permission.NonePermissionStrategy;
import com.nway.spring.jdbc.sql.permission.WhereCondition;
import com.nway.spring.jdbc.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class SqlBuilderUtils {
    private static final Map<Class<?>, EntityInfo> ENTITY_INFO_MAP = new ConcurrentHashMap(256);
    private static final Map<Class<?>, SerializedLambda> SERIALIZED_LAMBDA_MAP = new ConcurrentHashMap(256);

    private static void initEntityInfo(Class<?> claszz) {
        if (ENTITY_INFO_MAP.containsKey(claszz)) {
            return;
        }
        try {
            Field[] declaredFields = ReflectionUtils.getAllFields(claszz);
            EntityInfo entityInfo = new EntityInfo();
            entityInfo.setTableName(SqlBuilderUtils.getTableName(claszz));
            entityInfo.setColumnList(new ArrayList<String>(declaredFields.length));
            entityInfo.setMultiValue(new ArrayList<MultiValueColumnInfo>(8));
            entityInfo.setColumnMap(new HashMap<String, ColumnInfo>(declaredFields.length));
            Map<String, ColumnInfo> columnMap = entityInfo.getColumnMap();
            for (Field field : declaredFields) {
                Column column;
                if (Modifier.isStatic(field.getModifiers()) || (column = field.getAnnotation(Column.class)) != null && ColumnType.IGNORE.equals((Object)column.type())) continue;
                field.setAccessible(true);
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.setColumnName(SqlBuilderUtils.getColumnName(field));
                columnInfo.setReadMethod(field);
                if (column != null) {
                    columnInfo.setFillStrategy(column.fillStrategy().getConstructor(new Class[0]).newInstance(new Object[0]));
                    columnInfo.setPermissionStrategy(column.permissionStrategy().getConstructor(new Class[0]).newInstance(new Object[0]));
                    if (ColumnType.ID.equals((Object)column.type())) {
                        entityInfo.setId(columnInfo);
                    } else if (SqlBuilderUtils.isMultiVal(column)) {
                        MultiColumn multiColumn = field.getAnnotation(MultiColumn.class);
                        multiColumn = multiColumn == null ? column.sub() : multiColumn;
                        MultiValueColumnInfo multiValueColumnInfo = new MultiValueColumnInfo();
                        multiValueColumnInfo.setColumnName(columnInfo.getColumnName());
                        multiValueColumnInfo.setReadMethod(columnInfo.getReadMethod());
                        multiValueColumnInfo.setFillStrategy(columnInfo.getFillStrategy());
                        multiValueColumnInfo.setPermissionStrategy(columnInfo.getPermissionStrategy());
                        String defaultTableName = entityInfo.getTableName() + "_" + columnInfo.getColumnName();
                        if (multiColumn != null) {
                            multiValueColumnInfo.setTable(multiColumn.table().length() == 0 ? defaultTableName : multiColumn.table());
                            multiValueColumnInfo.setKey(multiColumn.key());
                            multiValueColumnInfo.setFk(multiColumn.fk());
                            multiValueColumnInfo.setIdx(multiColumn.idx());
                        }
                        entityInfo.getMultiValue().add(multiValueColumnInfo);
                    }
                } else {
                    columnInfo.setFillStrategy(new NoneFillStrategy());
                    columnInfo.setPermissionStrategy(new NonePermissionStrategy());
                }
                columnMap.put(field.getName(), columnInfo);
                if (column != null && SqlBuilderUtils.isMultiVal(column)) continue;
                entityInfo.getColumnList().add(columnInfo.getColumnName());
            }
            ENTITY_INFO_MAP.put(claszz, entityInfo);
        }
        catch (Exception e) {
            throw new SqlBuilderException(e);
        }
    }

    private static boolean isMultiVal(Column column) throws NoSuchMethodException {
        return ColumnType.MULTI_VALUE.equals((Object)column.type()) || !Column.class.getDeclaredMethod("sub", new Class[0]).getDefaultValue().equals(column.sub());
    }

    public static EntityInfo getEntityInfo(Class<?> claszz) {
        return Optional.ofNullable(ENTITY_INFO_MAP.get(claszz)).orElseGet(() -> {
            SqlBuilderUtils.initEntityInfo(claszz);
            return ENTITY_INFO_MAP.get(claszz);
        });
    }

    public static <T, R> EntityInfo getEntityInfo(SFunction<T, R> lambda) {
        SerializedLambda serializedLambda = SqlBuilderUtils.getSerializedLambda(lambda);
        try {
            Class<?> claszz = Class.forName(serializedLambda.getImplClass().replace("/", "."));
            return Optional.ofNullable(ENTITY_INFO_MAP.get(claszz)).orElseGet(() -> {
                SqlBuilderUtils.initEntityInfo(claszz);
                return ENTITY_INFO_MAP.get(claszz);
            });
        }
        catch (ClassNotFoundException e) {
            throw new SqlBuilderException(e);
        }
    }

    public static String getAllColumn(Class<?> beanClass) {
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(beanClass);
        return String.join((CharSequence)",", entityInfo.getColumnList());
    }

    public static List<String> getColumnsWithoutId(Class<?> beanClass) {
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(beanClass);
        ArrayList<String> columnList = new ArrayList<String>(entityInfo.getColumnList());
        columnList.remove(entityInfo.getId().getColumnName());
        return columnList;
    }

    public static <T> String getColumn(SSupplier<T> lambda) {
        try {
            SerializedLambda serializedLambda = SqlBuilderUtils.getSerializedLambda(lambda);
            return SqlBuilderUtils.methodToColumn(Class.forName(serializedLambda.getImplClass().replace("/", ".")), serializedLambda.getImplMethodName());
        }
        catch (Exception e) {
            throw new SqlBuilderException(e);
        }
    }

    public static <T> String getColumn(Class<?> beanClass, SSupplier<T> lambda) {
        try {
            SerializedLambda serializedLambda = SqlBuilderUtils.getSerializedLambda(lambda);
            return SqlBuilderUtils.methodToColumn(beanClass, serializedLambda.getImplMethodName());
        }
        catch (Exception e) {
            throw new SqlBuilderException(e);
        }
    }

    public static <T, R> String getColumn(SFunction<T, R> lambda) {
        try {
            SerializedLambda serializedLambda = SqlBuilderUtils.getSerializedLambda(lambda);
            return SqlBuilderUtils.methodToColumn(Class.forName(serializedLambda.getImplClass().replace("/", ".")), serializedLambda.getImplMethodName());
        }
        catch (Throwable e) {
            throw new SqlBuilderException(e);
        }
    }

    public static <T, R> String getColumn(Class<?> beanClass, SFunction<T, R> lambda) {
        try {
            SerializedLambda serializedLambda = SqlBuilderUtils.getSerializedLambda(lambda);
            return SqlBuilderUtils.methodToColumn(beanClass, serializedLambda.getImplMethodName());
        }
        catch (Throwable e) {
            throw new SqlBuilderException(e);
        }
    }

    public static WhereCondition getWhereCondition(SqlType sqlType, ColumnInfo columnInfo) {
        if (columnInfo.getPermissionStrategy().getClass() == NonePermissionStrategy.class) {
            return null;
        }
        return columnInfo.getPermissionStrategy().getSqlSegment(sqlType, columnInfo.getColumnName());
    }

    public static <T extends Serializable> SerializedLambda getSerializedLambda(T lambda) {
        Class<?> funcClass = lambda.getClass();
        return Optional.ofNullable(SERIALIZED_LAMBDA_MAP.get(funcClass)).orElseGet(() -> {
            try {
                Method writeReplace = funcClass.getDeclaredMethod("writeReplace", new Class[0]);
                writeReplace.setAccessible(true);
                SerializedLambda serializedLambda = MethodHandles.lookup().unreflect(writeReplace).invoke(lambda);
                SERIALIZED_LAMBDA_MAP.put(funcClass, serializedLambda);
                return serializedLambda;
            }
            catch (Throwable e) {
                throw new SqlBuilderException(e);
            }
        });
    }

    private static String getColumnName(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && (column.name().length() > 0 || column.value().length() > 0)) {
            return column.value().length() > 0 ? column.value() : column.name();
        }
        return SqlBuilderUtils.fieldNameToColumn(field.getName());
    }

    public static Object getColumnValue(ColumnInfo columnInfo, Object obj, SqlType sqlType) {
        Object objVal;
        try {
            objVal = columnInfo.getReadMethod().get(obj);
        }
        catch (IllegalAccessException e) {
            throw new SqlBuilderException(e);
        }
        if (columnInfo.getFillStrategy().isSupport(sqlType)) {
            objVal = columnInfo.getFillStrategy().getValue(sqlType, objVal);
            try {
                columnInfo.getReadMethod().set(obj, objVal);
            }
            catch (IllegalAccessException e) {
                throw new SqlBuilderException(e);
            }
        }
        return objVal;
    }

    public static String getTableNameFromCache(Class<?> entityClass) {
        return SqlBuilderUtils.getEntityInfo(entityClass).getTableName();
    }

    private static String getTableName(Class<?> entityClass) {
        String tableName = "";
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null) {
            String string = tableName = table.value().length() > 0 ? table.value() : table.name();
        }
        if (tableName.length() != 0) {
            return tableName;
        }
        return SqlBuilderUtils.fieldNameToColumn(entityClass.getSimpleName());
    }

    public static String fieldNameToColumn(String fieldName) {
        StringBuilder columnName = new StringBuilder();
        for (char c : fieldName.toCharArray()) {
            if (Character.isUpperCase(c)) {
                columnName.append('_').append(Character.toLowerCase(c));
                continue;
            }
            columnName.append(c);
        }
        return columnName.charAt(0) == '_' ? columnName.substring(1) : columnName.toString();
    }

    public static String columnToFieldName(String columnName) {
        StringBuilder str = new StringBuilder();
        char[] chars = columnName.toLowerCase().toCharArray();
        int underLineIdx = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '_') {
                underLineIdx = i + 1;
                continue;
            }
            if (i == underLineIdx) {
                str.append(String.valueOf(chars[i]).toUpperCase());
                continue;
            }
            str.append(chars[i]);
        }
        return str.toString();
    }

    public static String methodToColumn(Class<?> beanClass, String methodName) {
        String fieldName = "";
        if (methodName.startsWith("is")) {
            fieldName = methodName.substring(2);
        } else if (methodName.startsWith("get") || methodName.startsWith("set")) {
            fieldName = methodName.substring(3);
        } else {
            throw new RuntimeException("Error parsing property name '" + methodName + "'.  Didn't start with 'is', 'get' or 'set'.");
        }
        if (fieldName.length() == 1 || fieldName.length() > 1 && !Character.isUpperCase(fieldName.charAt(1))) {
            fieldName = fieldName.substring(0, 1).toLowerCase(Locale.ENGLISH) + fieldName.substring(1);
        }
        return SqlBuilderUtils.getEntityInfo(beanClass).getColumnMap().get(fieldName).getColumnName();
    }

    public static String getIdName(Class<?> beanClass) {
        EntityInfo entityInfo = ENTITY_INFO_MAP.get(beanClass);
        if (entityInfo == null) {
            SqlBuilderUtils.initEntityInfo(beanClass);
        }
        return ENTITY_INFO_MAP.get(beanClass).getId().getColumnName();
    }

    public static Object getIdValue(Class<?> beanClass, Object obj) {
        ColumnInfo columnInfo = SqlBuilderUtils.getEntityInfo(beanClass).getId();
        try {
            return columnInfo.getReadMethod().get(obj);
        }
        catch (IllegalAccessException e) {
            throw new SqlBuilderException(e);
        }
    }

    public static Object[] getIdValue(Class<?> beanClass, List<?> objs) {
        Object[] idValList = new Object[objs.size()];
        ColumnInfo columnInfo = SqlBuilderUtils.getEntityInfo(beanClass).getId();
        try {
            for (int i = 0; i < objs.size(); ++i) {
                idValList[i] = columnInfo.getReadMethod().get(objs.get(i));
            }
        }
        catch (IllegalAccessException e) {
            throw new SqlBuilderException(e);
        }
        return idValList;
    }
}

