/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.ISqlBuilder;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BatchInsertBuilder
implements ISqlBuilder {
    private List<String> columnList = new ArrayList<String>();
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> param = new ArrayList<Object>();
    private final Class beanClass;

    public BatchInsertBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BatchInsertBuilder use(List<?> objList) {
        ArrayList batchParam = new ArrayList(objList.size());
        for (int i = 0; i < objList.size(); ++i) {
            batchParam.add(new ArrayList());
        }
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        this.columnList = entityInfo.getColumnList();
        Map columnMap = entityInfo.getColumnMap().values().stream().collect(Collectors.toMap(ColumnInfo::getColumnName, Function.identity()));
        for (String column : this.columnList) {
            ColumnInfo columnInfo = (ColumnInfo)columnMap.get(column);
            for (int i = 0; i < objList.size(); ++i) {
                Object columnValue = SqlBuilderUtils.getColumnValue(columnInfo, objList.get(i), SqlType.INSERT);
                ((List)batchParam.get(i)).add(columnValue);
            }
        }
        this.param.addAll(batchParam);
        return this;
    }

    @Override
    public String getSql() {
        this.sql.append("insert into ").append(SqlBuilderUtils.getTableNameFromCache(this.beanClass)).append(" (").append(String.join((CharSequence)",", this.columnList)).append(") values (").append(this.columnList.stream().map(e -> "?").collect(Collectors.joining(","))).append(")");
        return this.sql.toString();
    }

    @Override
    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public List<Object> getParam() {
        return this.param.stream().map(e -> ((List)e).toArray()).collect(Collectors.toList());
    }
}

