/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.ISqlBuilder;
import com.nway.spring.jdbc.sql.builder.SqlOperator;
import com.nway.spring.jdbc.sql.fill.NoneFillStrategy;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import com.nway.spring.jdbc.sql.permission.NonePermissionStrategy;
import com.nway.spring.jdbc.sql.permission.WhereCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class BatchUpdateBuilder
implements ISqlBuilder {
    private Class beanClass;
    protected List<?> data;
    private final List<Object> param = new ArrayList<Object>();
    protected final List<String> columnNameList = new ArrayList<String>();
    protected final List<CondExp> whereCondList = new ArrayList<CondExp>();

    public BatchUpdateBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    @SafeVarargs
    public final <T, R> BatchUpdateBuilder columns(SFunction<T, R> ... columns) {
        for (SFunction<T, R> column : columns) {
            this.columnNameList.add(SqlBuilderUtils.getColumn(this.beanClass, column));
        }
        return this;
    }

    public BatchUpdateBuilder use(List<?> params) {
        this.data = params;
        return this;
    }

    public <T, R> BatchUpdateBuilder addCondition(SFunction<T, R> column, SqlOperator operator) {
        this.whereCondList.add(new CondExp(SqlBuilderUtils.getColumn(this.beanClass, column), operator));
        return this;
    }

    @Override
    public String getSql() {
        this.makeSqlParam();
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(SqlBuilderUtils.getTableNameFromCache(this.beanClass)).append(" set ");
        int initLength = sql.length();
        List<String> columnList = this.getColumnNameList(SqlBuilderUtils.getEntityInfo(this.beanClass));
        for (String col : columnList) {
            sql.append(col).append(" = ?,");
        }
        if (sql.length() > initLength) {
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(" where ");
        for (int i = 0; i < this.whereCondList.size(); ++i) {
            if (i != 0) {
                sql.append(" and ");
            }
            CondExp condExp = this.whereCondList.get(i);
            sql.append(condExp.column).append(' ').append(condExp.operator);
            if (SqlOperator.IS_NULL.getOperator().equals(condExp.operator) || SqlOperator.IS_NOT_NULL.getOperator().equals(condExp.operator)) continue;
            sql.append(' ').append('?');
        }
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            WhereCondition whereCondition;
            if (columnInfo.getPermissionStrategy().getClass() == NonePermissionStrategy.class || (whereCondition = SqlBuilderUtils.getWhereCondition(SqlType.UPDATE, columnInfo)) == null || whereCondition.getExpr().length() <= 0) continue;
            sql.append(this.whereCondList.isEmpty() ? " " : " and ").append(whereCondition.getExpr()).append(' ');
            for (int i = 0; i < this.data.size(); ++i) {
                if (whereCondition.getValue() instanceof Collection) {
                    ((List)this.param.get(i)).addAll((Collection)whereCondition.getValue());
                    continue;
                }
                if (ObjectUtils.isArray((Object)whereCondition.getValue())) {
                    ((List)this.param.get(i)).addAll(CollectionUtils.arrayToList((Object)whereCondition.getValue()));
                    continue;
                }
                ((List)this.param.get(i)).add(whereCondition.getValue());
            }
        }
        return sql.toString();
    }

    @Override
    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public List<Object> getParam() {
        return this.param.stream().map(e -> ((List)e).toArray()).collect(Collectors.toList());
    }

    public List<?> getData() {
        return this.data;
    }

    private void makeSqlParam() {
        Object columnValue;
        int i;
        ColumnInfo columnInfo;
        int dataSize = this.data.size();
        ArrayList batchParam = new ArrayList(dataSize);
        for (int i2 = 0; i2 < dataSize; ++i2) {
            batchParam.add(new ArrayList());
        }
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        List<String> columnList = this.getColumnNameList(entityInfo);
        Map columnMap = entityInfo.getColumnMap().values().stream().collect(Collectors.toMap(ColumnInfo::getColumnName, Function.identity()));
        for (String column : columnList) {
            columnInfo = (ColumnInfo)columnMap.get(column);
            for (i = 0; i < dataSize; ++i) {
                columnValue = SqlBuilderUtils.getColumnValue(columnInfo, this.data.get(i), SqlType.UPDATE);
                ((List)batchParam.get(i)).add(columnValue);
            }
        }
        for (CondExp condExp : this.whereCondList) {
            if (SqlOperator.IS_NULL.getOperator().equals(condExp.operator) || SqlOperator.IS_NOT_NULL.getOperator().equals(condExp.operator)) continue;
            columnInfo = (ColumnInfo)columnMap.get(condExp.column);
            for (i = 0; i < dataSize; ++i) {
                columnValue = SqlBuilderUtils.getColumnValue(columnInfo, this.data.get(i), SqlType.UPDATE);
                ((List)batchParam.get(i)).add(columnValue);
            }
        }
        this.param.addAll(batchParam);
    }

    private List<String> getColumnNameList(EntityInfo entityInfo) {
        List<String> columnList = this.columnNameList.size() != 0 ? this.columnNameList : SqlBuilderUtils.getColumnsWithoutId(this.beanClass);
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            if (NoneFillStrategy.class.equals(columnInfo.getFillStrategy().getClass()) || !columnInfo.getFillStrategy().isSupport(SqlType.UPDATE) || columnList.contains(columnInfo.getColumnName())) continue;
            columnList.add(columnInfo.getColumnName());
        }
        return columnList;
    }

    private static class CondExp {
        private final String column;
        private final String operator;

        public CondExp(String column, SqlOperator operator) {
            this.column = column;
            this.operator = operator.getOperator();
        }
    }
}

