/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.ISqlBuilder;
import com.nway.spring.jdbc.sql.builder.SqlBuilderException;
import com.nway.spring.jdbc.sql.fill.NoneFillStrategy;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.function.SSupplier;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import com.nway.spring.jdbc.sql.permission.NonePermissionStrategy;
import com.nway.spring.jdbc.sql.permission.WhereCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class BatchUpdateByIdBuilder
implements ISqlBuilder {
    protected List<?> data;
    protected List<Object> param = new ArrayList<Object>();
    private List<String> columnNameList = new ArrayList<String>();
    protected Class beanClass;

    public BatchUpdateByIdBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BatchUpdateByIdBuilder use(List<?> data) {
        this.data = data;
        ArrayList batchParam = new ArrayList(data.size());
        for (int i = 0; i < data.size(); ++i) {
            batchParam.add(new ArrayList());
        }
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        List<String> columnList = this.getColumnNameList(entityInfo);
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            if (NoneFillStrategy.class.equals(columnInfo.getFillStrategy().getClass()) || !columnInfo.getFillStrategy().isSupport(SqlType.UPDATE) || columnList.contains(columnInfo.getColumnName())) continue;
            columnList.add(columnInfo.getColumnName());
        }
        Map columnMap = entityInfo.getColumnMap().values().stream().collect(Collectors.toMap(ColumnInfo::getColumnName, Function.identity()));
        for (String column : columnList) {
            ColumnInfo columnInfo = (ColumnInfo)columnMap.get(column);
            for (int i = 0; i < data.size(); ++i) {
                Object columnValue = SqlBuilderUtils.getColumnValue(columnInfo, data.get(i), SqlType.UPDATE);
                ((List)batchParam.get(i)).add(columnValue);
            }
        }
        this.param.addAll(batchParam);
        return this;
    }

    public BatchUpdateByIdBuilder columns(String ... columns) {
        this.columnNameList.addAll(Arrays.asList(columns));
        return this;
    }

    @SafeVarargs
    public final <T> BatchUpdateByIdBuilder columns(SSupplier<T> ... columns) {
        for (SSupplier<T> column : columns) {
            this.columnNameList.add(SqlBuilderUtils.getColumn(this.beanClass, column));
        }
        return this;
    }

    @SafeVarargs
    public final <T, R> BatchUpdateByIdBuilder columns(SFunction<T, R> ... columns) {
        for (SFunction<T, R> column : columns) {
            this.columnNameList.add(SqlBuilderUtils.getColumn(this.beanClass, column));
        }
        return this;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(SqlBuilderUtils.getTableNameFromCache(this.beanClass)).append(" set ");
        int initLength = sql.length();
        List<String> columnList = this.getColumnNameList(SqlBuilderUtils.getEntityInfo(this.beanClass));
        for (String col : columnList) {
            sql.append(col).append(" = ?,");
        }
        if (sql.length() > initLength) {
            sql.deleteCharAt(sql.length() - 1);
        }
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        sql.append(" where ").append(entityInfo.getId().getColumnName()).append(" = ?");
        for (int i = 0; i < this.param.size(); ++i) {
            Object idVal = SqlBuilderUtils.getColumnValue(entityInfo.getId(), this.data.get(i), SqlType.UPDATE);
            if (idVal == null) {
                throw new SqlBuilderException("\u66f4\u65b0\u5931\u8d25\uff0c\u6279\u91cf\u66f4\u65b0\u65f6\u5b58\u5728\u4e3b\u952e\u4e3a\u7a7a\u7684\u6570\u636e\u3002");
            }
            ((List)this.param.get(i)).add(idVal);
        }
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            WhereCondition whereCondition;
            if (columnInfo.getPermissionStrategy().getClass() == NonePermissionStrategy.class || (whereCondition = SqlBuilderUtils.getWhereCondition(SqlType.UPDATE, columnInfo)) == null || whereCondition.getExpr().length() <= 0) continue;
            sql.append(" and ").append(whereCondition.getExpr()).append(' ');
            for (int i = 0; i < this.param.size(); ++i) {
                if (whereCondition.getValue() instanceof Collection) {
                    ((List)this.param.get(i)).addAll((Collection)whereCondition.getValue());
                    continue;
                }
                if (ObjectUtils.isArray((Object)whereCondition.getValue())) {
                    ((List)this.param.get(i)).addAll(CollectionUtils.arrayToList((Object)whereCondition.getValue()));
                    continue;
                }
                ((List)this.param.get(i)).add(whereCondition.getValue());
            }
        }
        return sql.toString();
    }

    @Override
    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public List<Object> getParam() {
        return this.param.stream().map(e -> ((List)e).toArray()).collect(Collectors.toList());
    }

    private List<String> getColumnNameList(EntityInfo entityInfo) {
        List<String> columnList = this.columnNameList.size() != 0 ? this.columnNameList : SqlBuilderUtils.getColumnsWithoutId(this.beanClass);
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            if (NoneFillStrategy.class.equals(columnInfo.getFillStrategy().getClass()) || !columnInfo.getFillStrategy().isSupport(SqlType.UPDATE) || columnList.contains(columnInfo.getColumnName())) continue;
            columnList.add(columnInfo.getColumnName());
        }
        return columnList;
    }
}

