/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.ISqlBuilder;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InsertBuilder
implements ISqlBuilder {
    private final List<String> columns = new ArrayList<String>();
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> param = new ArrayList<Object>();
    private final Class beanClass;

    public InsertBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public InsertBuilder use(Object obj) {
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        List<String> columnList = entityInfo.getColumnList();
        Map columnMap = entityInfo.getColumnMap().values().stream().collect(Collectors.toMap(ColumnInfo::getColumnName, Function.identity()));
        for (String column : columnList) {
            ColumnInfo columnInfo = (ColumnInfo)columnMap.get(column);
            Object value = SqlBuilderUtils.getColumnValue(columnInfo, obj, SqlType.INSERT);
            if (value == null) continue;
            this.columns.add(columnInfo.getColumnName());
            this.param.add(value);
        }
        return this;
    }

    @Override
    public String getSql() {
        this.sql.append("insert into ").append(SqlBuilderUtils.getTableNameFromCache(this.beanClass)).append(" (").append(String.join((CharSequence)",", this.columns)).append(") values (").append(this.columns.stream().map(e -> "?").collect(Collectors.joining(","))).append(")");
        return this.sql.toString();
    }

    @Override
    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public List<Object> getParam() {
        return this.param;
    }

    public Object getKeyValue() {
        int keyIdx = -1;
        Object keyVal = null;
        String idName = SqlBuilderUtils.getIdName(this.getBeanClass());
        for (int i = 0; i < this.columns.size(); ++i) {
            String columnName = this.columns.get(i);
            if (!columnName.equals(idName)) continue;
            keyIdx = i;
            break;
        }
        if (keyIdx != -1) {
            keyVal = this.getParam().get(keyIdx);
        }
        if (Long.valueOf(0L).equals(keyVal) || Integer.valueOf(0).equals(keyVal)) {
            keyVal = null;
        }
        return keyVal;
    }
}

