/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.MultiValQueryBuilder;
import com.nway.spring.jdbc.sql.builder.SqlBuilder;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import com.nway.spring.jdbc.sql.meta.MultiValueColumnInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QueryBuilder
extends SqlBuilder<QueryBuilder>
implements MultiValQueryBuilder {
    private String distinct = "";
    private final List<String> columns = new ArrayList<String>();
    private final List<String> excludeColumns = new ArrayList<String>();
    private final List<String> multiValColumn = new ArrayList<String>();
    private final Map<String, Collection<?>> selectMultiParamMap = new LinkedHashMap();

    public QueryBuilder(Class<?> beanClass) {
        super(beanClass);
    }

    @Override
    protected SqlType getSqlType() {
        return SqlType.SELECT;
    }

    public QueryBuilder distinct() {
        this.distinct = " distinct ";
        return this;
    }

    @SafeVarargs
    public final <T> QueryBuilder withColumn(SFunction<T, ?> ... fields) {
        for (SFunction<T, ?> field : fields) {
            this.columns.add(SqlBuilderUtils.getColumn(this.beanClass, field));
        }
        return this;
    }

    public QueryBuilder withColumn(String ... columnNames) {
        this.columns.addAll(Arrays.asList(columnNames));
        return this;
    }

    public QueryBuilder excludeColumn(String ... columnNames) {
        this.excludeColumns.addAll(Arrays.asList(columnNames));
        return this;
    }

    @SafeVarargs
    public final <T> QueryBuilder excludeColumn(SFunction<T, ?> ... fields) {
        for (SFunction<T, ?> field : fields) {
            this.excludeColumns.add(SqlBuilderUtils.getColumn(this.beanClass, field));
        }
        return this;
    }

    @SafeVarargs
    public final <T> QueryBuilder withMVColumn(SFunction<T, ?> ... fields) {
        for (SFunction<T, ?> field : fields) {
            this.multiValColumn.add(SqlBuilderUtils.getColumn(this.beanClass, field));
        }
        return this;
    }

    public QueryBuilder withMVColumn(String ... columnNames) {
        this.multiValColumn.addAll(Arrays.asList(columnNames));
        return this;
    }

    public <T> QueryBuilder mvIn(SFunction<T, ?> field, Collection<?> params) {
        if (!this.isInvalid(params)) {
            String column = SqlBuilderUtils.getColumn(this.beanClass, field);
            this.selectMultiParamMap.put(column, params);
        }
        return this;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getMultiValColumn() {
        return this.multiValColumn;
    }

    public QueryBuilder groupBy(String ... column) {
        this.afterWhere.append(" group by ").append(String.join((CharSequence)",", column));
        return this;
    }

    @SafeVarargs
    public final <T, R> QueryBuilder groupBy(SFunction<T, R> ... columns) {
        this.afterWhere.append(" group by ");
        for (SFunction<T, R> column : columns) {
            this.afterWhere.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(",");
        }
        this.afterWhere.deleteCharAt(this.afterWhere.length() - 1);
        return this;
    }

    @SafeVarargs
    public final <T, R> QueryBuilder orderBy(SFunction<T, R> ... columns) {
        this.afterWhere.append(" order by ");
        for (SFunction<T, R> column : columns) {
            this.afterWhere.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(",");
        }
        this.afterWhere.deleteCharAt(this.afterWhere.length() - 1);
        return this;
    }

    public QueryBuilder orderBy(String ... columns) {
        this.afterWhere.append(" order by ");
        for (String column : columns) {
            this.afterWhere.append(column).append(",");
        }
        this.afterWhere.deleteCharAt(this.afterWhere.length() - 1);
        return this;
    }

    public <T, R> QueryBuilder andOrderByAsc(SFunction<T, R> column) {
        this.afterWhere.append(",").append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" asc");
        return this;
    }

    public QueryBuilder andOrderByAsc(String ... columns) {
        for (String column : columns) {
            this.afterWhere.append(",").append(column).append(" asc");
        }
        return this;
    }

    @SafeVarargs
    public final <T, R> QueryBuilder orderByDesc(SFunction<T, R> ... columns) {
        this.afterWhere.append(" order by ");
        for (SFunction<T, R> column : columns) {
            this.afterWhere.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" desc,");
        }
        this.afterWhere.deleteCharAt(this.afterWhere.length() - 1);
        return this;
    }

    public QueryBuilder orderByDesc(String ... columns) {
        this.afterWhere.append(" order by ");
        for (String column : columns) {
            this.afterWhere.append(column).append(" desc,");
        }
        this.afterWhere.deleteCharAt(this.afterWhere.length() - 1);
        return this;
    }

    public <T, R> QueryBuilder andOrderByDesc(SFunction<T, R> column) {
        this.afterWhere.append(",").append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" desc");
        return this;
    }

    public QueryBuilder andOrderByDesc(String ... columns) {
        for (String column : columns) {
            this.afterWhere.append(",").append(column).append(" desc");
        }
        return this;
    }

    public QueryBuilder having(Consumer<QueryBuilder> whereBuilder) {
        QueryBuilder lq = new QueryBuilder(this.beanClass);
        whereBuilder.accept(lq);
        StringBuilder sql = lq.getWhere();
        if (sql.length() > 7) {
            this.afterWhere.append(" having ").append(lq.getWhere().substring(7));
            this.param.addAll(lq.getParam());
        }
        return (QueryBuilder)this.thisObj;
    }

    @Override
    public String getSql() {
        return this.getSelectStmt() + super.getSql();
    }

    private String getSelectStmt() {
        StringBuilder sql = new StringBuilder(64);
        if (this.getColumns().size() > 0) {
            sql.append("select ").append(this.distinct).append(String.join((CharSequence)",", this.getColumns())).append(" from ").append(SqlBuilderUtils.getTableNameFromCache(this.beanClass));
        } else {
            EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
            List<String> columnList = entityInfo.getColumnList();
            String columnStr = columnList.stream().filter(column -> !this.excludeColumns.contains(column)).collect(Collectors.joining(","));
            sql.append("select ").append(this.distinct).append(columnStr).append(" from ").append(SqlBuilderUtils.getTableNameFromCache(this.beanClass));
        }
        if (!this.selectMultiParamMap.isEmpty()) {
            List<MultiValueColumnInfo> multiValueList = SqlBuilderUtils.getEntityInfo(this.getBeanClass()).getMultiValue();
            Map mvColMap = multiValueList.stream().collect(Collectors.toMap(ColumnInfo::getColumnName, Function.identity()));
            int current = 0;
            for (Map.Entry<String, Collection<?>> entry : this.selectMultiParamMap.entrySet()) {
                int next = current + 1;
                String curAlias = "t" + current;
                String nextAlias = "t" + next;
                MultiValueColumnInfo multiValueColumnInfo = (MultiValueColumnInfo)mvColMap.get(entry.getKey());
                sql.append(" ").append(curAlias).append(" left join ").append(multiValueColumnInfo.getTable()).append(" ").append(nextAlias).append(" on ").append(curAlias).append('.').append(SqlBuilderUtils.getIdName(this.getBeanClass())).append(" = ").append(nextAlias).append('.').append(multiValueColumnInfo.getFk());
                super.in(nextAlias + "." + entry.getKey(), entry.getValue());
            }
        }
        return sql.toString();
    }
}

