/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.ISqlBuilder;
import com.nway.spring.jdbc.sql.builder.SqlBuilderException;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.function.SSupplier;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import com.nway.spring.jdbc.sql.permission.NonePermissionStrategy;
import com.nway.spring.jdbc.sql.permission.WhereCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class SqlBuilder<X extends SqlBuilder<X>>
implements ISqlBuilder {
    protected StringBuilder where = new StringBuilder(128);
    protected StringBuilder afterWhere = new StringBuilder(128);
    protected List<Object> param = new ArrayList<Object>();
    protected Class beanClass;
    private boolean canAppendAnd = false;
    private boolean canAppendWhere = true;
    private boolean ignoreInvalid = false;
    private boolean ignoreInvalidDeep = false;
    protected boolean ignorePower = false;
    protected final X thisObj = this;

    protected SqlBuilder(Class beanClass) {
        this.beanClass = beanClass;
    }

    protected abstract SqlType getSqlType();

    @Override
    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    protected X where() {
        if (this.canAppendWhere) {
            this.where.append(" where ");
        }
        this.canAppendWhere = false;
        return this.thisObj;
    }

    public X ignoreInvalid(boolean ignoreInvalid) {
        this.ignoreInvalid = ignoreInvalid;
        return this.thisObj;
    }

    public X ignoreInvalidDeep(boolean ignoreInvalidDeep) {
        this.ignoreInvalid = ignoreInvalidDeep;
        this.ignoreInvalidDeep = ignoreInvalidDeep;
        return this.thisObj;
    }

    public <T> X eq(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(val, " = ?");
        return this.thisObj;
    }

    public <T, R> X eq(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " = ?");
        return this.thisObj;
    }

    public X eq(String column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " = ?");
        return this.thisObj;
    }

    public <T> X ne(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(val, " <> ?");
        return this.thisObj;
    }

    public X ne(String column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " <> ?");
        return this.thisObj;
    }

    public <T, R> X ne(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " <> ?");
        return this.thisObj;
    }

    public <T> X gt(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(val, " > ?");
        return this.thisObj;
    }

    public X gt(String column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " > ?");
        return this.thisObj;
    }

    public <T, R> X gt(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " > ?");
        return this.thisObj;
    }

    public <T> X ge(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(val, " >= ?");
        return this.thisObj;
    }

    public X ge(String column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " >= ?");
        return this.thisObj;
    }

    public <T, R> X ge(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " >= ?");
        return this.thisObj;
    }

    public <T> X lt(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(val, " < ?");
        return this.thisObj;
    }

    public X lt(String column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " < ?");
        return this.thisObj;
    }

    public <T, R> X lt(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " < ?");
        return this.thisObj;
    }

    public <T> X le(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(val, " <= ?");
        return this.thisObj;
    }

    public X le(String column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " <= ?");
        return this.thisObj;
    }

    public <T, R> X le(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, val, " <= ?");
        return this.thisObj;
    }

    public X like(SSupplier<String> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, val), (Object)("%" + (String)val.get() + "%"), " like ?");
        return this.thisObj;
    }

    public X like(String column, String val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, (Object)("%" + val + "%"), " like ?");
        return this.thisObj;
    }

    public <T, R> X like(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)("%" + val + "%"), " like ?");
        return this.thisObj;
    }

    public <T, R> X like(SFunction<T, R> column, Supplier<String> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)("%" + val.get() + "%"), " like ?");
        return this.thisObj;
    }

    public X notLike(SSupplier<String> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, val), (Object)("%" + (String)val.get() + "%"), " not like ?");
        return this.thisObj;
    }

    public X notLike(String column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, (Object)("%" + val + "%"), " not like ?");
        return this.thisObj;
    }

    public <T, R> X notLike(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)("%" + val + "%"), " not like ?");
        return this.thisObj;
    }

    public <T, R> X notLike(SFunction<T, R> column, Supplier<String> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)("%" + val.get() + "%"), " not like ?");
        return this.thisObj;
    }

    public <T> X likeLeft(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, val), (Object)("%" + val.get()), " like ?");
        return this.thisObj;
    }

    public X likeLeft(String column, String val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, (Object)("%" + val), " like ?");
        return this.thisObj;
    }

    public <T, R> X likeLeft(SFunction<T, R> column, String val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)("%" + val), " like ?");
        return this.thisObj;
    }

    public <T, R> X likeLeft(SFunction<T, R> column, SSupplier<String> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)("%" + (String)val.get()), " like ?");
        return this.thisObj;
    }

    public X likeRight(SSupplier<String> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, val), (Object)((String)val.get() + "%"), " like ?");
        return this.thisObj;
    }

    public X likeRight(String column, String val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(column, (Object)(val + "%"), " like ?");
        return this.thisObj;
    }

    public <T, R> X likeRight(SFunction<T, R> column, String val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)(val + "%"), " like ?");
        return this.thisObj;
    }

    public <T, R> X likeRight(SFunction<T, R> column, SSupplier<String> val) {
        if (this.isInvalid(val.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.appendCondition(SqlBuilderUtils.getColumn(this.beanClass, column), (Object)((String)val.get() + "%"), " like ?");
        return this.thisObj;
    }

    public <T, R> X isNull(SFunction<T, R> column) {
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" is null");
        return this.thisObj;
    }

    public <T> X isNull(SSupplier<T> column) {
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" is null");
        return this.thisObj;
    }

    public X isNull(String column) {
        this.appendAnd();
        this.where.append(column).append(" is null");
        return this.thisObj;
    }

    public <T, R> X isNotNull(SFunction<T, R> column) {
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" is not null");
        return this.thisObj;
    }

    public <T> X isNotNull(SSupplier<T> column) {
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" is not null");
        return this.thisObj;
    }

    public X isNotNull(String column) {
        this.appendAnd();
        this.where.append(column).append(" is not null");
        return this.thisObj;
    }

    public <T> X between(SSupplier<T> column, Supplier<T> leftVal, Supplier<T> rightVal) {
        if (this.isInvalid(leftVal.get()) && this.isInvalid(rightVal.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" between").append(" ? and ?");
        this.param.add(leftVal.get());
        this.param.add(rightVal.get());
        return this.thisObj;
    }

    public <T, R> X between(SFunction<T, R> column, Object leftVal, Object rightVal) {
        if (this.isInvalid(leftVal) && this.isInvalid(rightVal)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" between").append(" ? and ?");
        this.param.add(leftVal);
        this.param.add(rightVal);
        return this.thisObj;
    }

    public <T, R, O> X between(SFunction<T, R> column, Supplier<O> leftVal, Supplier<O> rightVal) {
        if (this.isInvalid(leftVal.get()) && this.isInvalid(rightVal.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" between").append(" ? and ?");
        this.param.add(leftVal.get());
        this.param.add(rightVal.get());
        return this.thisObj;
    }

    public X between(String column, Object leftVal, Object rightVal) {
        if (this.isInvalid(leftVal) && this.isInvalid(rightVal)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(column).append(" between").append(" ? and ?");
        this.param.add(leftVal);
        this.param.add(rightVal);
        return this.thisObj;
    }

    public <T> X between(String column, Supplier<T> leftVal, Supplier<T> rightVal) {
        if (this.isInvalid(leftVal.get()) && this.isInvalid(rightVal.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(column).append(" between").append(" ? and ?");
        this.param.add(leftVal.get());
        this.param.add(rightVal.get());
        return this.thisObj;
    }

    public <T> X notBetween(SSupplier<T> column, Supplier<T> leftVal, Supplier<T> rightVal) {
        if (this.isInvalid(leftVal.get()) && this.isInvalid(rightVal.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" not between").append(" ? and ?");
        this.param.add(leftVal.get());
        this.param.add(rightVal.get());
        return this.thisObj;
    }

    public <T> X notBetween(String column, Supplier<T> leftVal, Supplier<T> rightVal) {
        if (this.isInvalid(leftVal.get()) && this.isInvalid(rightVal.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(column).append(" not between").append(" ? and ?");
        this.param.add(leftVal.get());
        this.param.add(rightVal.get());
        return this.thisObj;
    }

    public X notBetween(String column, Object leftVal, Object rightVal) {
        if (this.isInvalid(leftVal) && this.isInvalid(rightVal)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(column).append(" not between").append(" ? and ?");
        this.param.add(leftVal);
        this.param.add(rightVal);
        return this.thisObj;
    }

    public <T, R, O> X notBetween(SFunction<T, R> column, Supplier<O> leftVal, Supplier<O> rightVal) {
        if (this.isInvalid(leftVal.get()) && this.isInvalid(rightVal.get())) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" not between").append(" ? and ?");
        this.param.add(leftVal.get());
        this.param.add(rightVal.get());
        return this.thisObj;
    }

    public <T, R> X notBetween(SFunction<T, R> column, Object leftVal, Object rightVal) {
        if (this.isInvalid(leftVal) && this.isInvalid(rightVal)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" not between").append(" ? and ?");
        this.param.add(leftVal);
        this.param.add(rightVal);
        return this.thisObj;
    }

    public X and(Consumer<X> whereBuilder) {
        X lq = this.createObj();
        whereBuilder.accept(lq);
        StringBuilder sql = ((SqlBuilder)lq).getWhere();
        if (sql.length() > 7) {
            this.appendAnd();
            this.where.append("(").append(sql.substring(6)).append(")");
            this.param.addAll(((SqlBuilder)lq).getParam());
        }
        return this.thisObj;
    }

    public X or(Consumer<X> whereBuilder) {
        X lq = this.createObj();
        whereBuilder.accept(lq);
        StringBuilder sql = ((SqlBuilder)lq).getWhere();
        if (sql.length() > 7) {
            this.where();
            this.canAppendAnd = true;
            if (this.where.length() == 7) {
                this.where.append("(").append(sql.substring(6)).append(")");
            } else {
                this.where.append(" or (").append(sql.substring(6)).append(")");
            }
            this.param.addAll(((SqlBuilder)lq).getParam());
        }
        return this.thisObj;
    }

    public <T> X or() {
        this.where.append(" or ");
        this.canAppendAnd = false;
        return this.thisObj;
    }

    private X createObj() {
        SqlBuilder lq;
        try {
            Class<?> aClass = this.thisObj.getClass();
            lq = (SqlBuilder)aClass.getDeclaredConstructor(Class.class).newInstance(this.beanClass);
        }
        catch (Exception e) {
            throw new SqlBuilderException(e);
        }
        return (X)lq;
    }

    public X in(String column, Collection<?> val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(column).append(" in (");
        this.param.addAll(val);
        for (int i = 0; i < val.size(); ++i) {
            this.where.append("?,");
        }
        if (!val.isEmpty()) {
            this.where.setCharAt(this.where.length() - 1, ')');
        }
        return this.thisObj;
    }

    public <T, R> X in(SFunction<T, R> column, Collection<?> val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" in (");
        this.param.addAll(val);
        for (int i = 0; i < val.size(); ++i) {
            this.where.append("?,");
        }
        if (!val.isEmpty()) {
            this.where.setCharAt(this.where.length() - 1, ')');
        }
        return this.thisObj;
    }

    public X notIn(String column, Collection<?> val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(column).append(" not in (");
        this.param.addAll(val);
        for (int i = 0; i < val.size(); ++i) {
            this.where.append("?,");
        }
        if (!val.isEmpty()) {
            this.where.setCharAt(this.where.length() - 1, ')');
        }
        return this.thisObj;
    }

    public <T, R> X notIn(SFunction<T, R> column, Collection<?> val) {
        if (this.isInvalid(val)) {
            return this.thisObj;
        }
        this.appendAnd();
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(" not in (");
        this.param.addAll(val);
        for (int i = 0; i < val.size(); ++i) {
            this.where.append("?,");
        }
        if (!val.isEmpty()) {
            this.where.setCharAt(this.where.length() - 1, ')');
        }
        return this.thisObj;
    }

    private void appendAnd() {
        if (this.canAppendAnd) {
            this.where.append(" and ");
        } else {
            this.where();
        }
        this.canAppendAnd = true;
    }

    public X appendCondition(WhereCondition whereCondition) {
        if (whereCondition != null && whereCondition.getExpr().length() > 0) {
            this.appendWhereCondition(whereCondition.getExpr());
            if (whereCondition.getValue() instanceof Collection) {
                this.param.addAll((Collection)whereCondition.getValue());
            } else if (ObjectUtils.isArray((Object)whereCondition.getValue())) {
                this.param.addAll(CollectionUtils.arrayToList((Object)whereCondition.getValue()));
            } else {
                this.param.add(whereCondition.getValue());
            }
        }
        return this.thisObj;
    }

    private X appendWhereCondition(String whereCondition) {
        this.appendAnd();
        this.where.append(' ').append(whereCondition).append(' ');
        return this.thisObj;
    }

    private <T> void appendCondition(SSupplier<T> val, String op) {
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, val)).append(op);
        this.param.add(val.get());
    }

    private <T, R> void appendCondition(SFunction<T, R> column, Object val, String op) {
        this.where.append(SqlBuilderUtils.getColumn(this.beanClass, column)).append(op);
        this.param.add(val);
    }

    private void appendCondition(String column, Object val, String op) {
        this.where.append(column).append(op);
        this.param.add(val);
    }

    protected boolean isInvalid(Object val) {
        if (!this.ignoreInvalid) {
            return false;
        }
        if (val instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)val))) {
            return true;
        }
        if (this.ignoreInvalidDeep) {
            if (val instanceof String) {
                return val.toString().length() == 0;
            }
            if (val instanceof Collection) {
                return ((Collection)val).stream().noneMatch(Objects::nonNull);
            }
        }
        return val == null;
    }

    public void ignorePermission() {
        this.ignorePower = true;
    }

    protected void initPermission() {
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            if (columnInfo.getPermissionStrategy().getClass() == NonePermissionStrategy.class) continue;
            this.appendCondition(SqlBuilderUtils.getWhereCondition(this.getSqlType(), columnInfo));
        }
    }

    protected StringBuilder getWhere() {
        return this.where;
    }

    @Override
    public String getSql() {
        String sql;
        if (!this.ignorePower) {
            this.initPermission();
        }
        if ((sql = this.where.toString()).endsWith(" where ")) {
            sql = sql.substring(0, sql.length() - 8);
        }
        return sql + this.afterWhere.toString();
    }

    @Override
    public List<Object> getParam() {
        return this.param;
    }
}

