/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.SqlBuilder;
import com.nway.spring.jdbc.sql.fill.NoneFillStrategy;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UpdateBeanBuilder
extends SqlBuilder<UpdateBeanBuilder> {
    private final List<String> sets = new ArrayList<String>();
    private final List<Object> setsParam = new ArrayList<Object>();
    protected final List<String> columnNameList = new ArrayList<String>();
    private final Object obj;

    public UpdateBeanBuilder(Object obj) {
        super(obj.getClass());
        this.obj = obj;
    }

    @Override
    protected SqlType getSqlType() {
        return SqlType.UPDATE;
    }

    @SafeVarargs
    public final <T, R> UpdateBeanBuilder columns(SFunction<T, R> ... columns) {
        for (SFunction<T, R> column : columns) {
            this.columnNameList.add(SqlBuilderUtils.getColumn(this.beanClass, column));
        }
        return this;
    }

    public UpdateBeanBuilder columns(String ... columns) {
        this.columnNameList.addAll(Arrays.asList(columns));
        return this;
    }

    private void init() {
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        List<String> columnList = this.getColumnNameList(entityInfo);
        Map columnMap = entityInfo.getColumnMap().values().stream().collect(Collectors.toMap(ColumnInfo::getColumnName, Function.identity()));
        for (String column : columnList) {
            Object value;
            ColumnInfo columnInfo = (ColumnInfo)columnMap.get(column);
            if (entityInfo.getId() == columnInfo || (value = SqlBuilderUtils.getColumnValue(columnInfo, this.obj, SqlType.UPDATE)) == null) continue;
            this.sets.add(columnInfo.getColumnName() + " = ?");
            this.setsParam.add(value);
        }
    }

    private List<String> getColumnNameList(EntityInfo entityInfo) {
        List<String> columnList = this.columnNameList.size() != 0 ? this.columnNameList : SqlBuilderUtils.getColumnsWithoutId(this.beanClass);
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            if (NoneFillStrategy.class.equals(columnInfo.getFillStrategy().getClass()) || !columnInfo.getFillStrategy().isSupport(SqlType.UPDATE) || columnList.contains(columnInfo.getColumnName())) continue;
            columnList.add(columnInfo.getColumnName());
        }
        return columnList;
    }

    @Override
    public String getSql() {
        this.init();
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(SqlBuilderUtils.getTableNameFromCache(this.beanClass)).append(" set ").append(String.join((CharSequence)",", this.sets)).append(super.getSql());
        return sql.toString();
    }

    @Override
    public List<Object> getParam() {
        this.setsParam.addAll(super.getParam());
        return this.setsParam;
    }
}

