/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.builder;

import com.nway.spring.jdbc.sql.SqlBuilderUtils;
import com.nway.spring.jdbc.sql.SqlType;
import com.nway.spring.jdbc.sql.builder.SqlBuilder;
import com.nway.spring.jdbc.sql.fill.FillStrategy;
import com.nway.spring.jdbc.sql.fill.NoneFillStrategy;
import com.nway.spring.jdbc.sql.function.SFunction;
import com.nway.spring.jdbc.sql.function.SSupplier;
import com.nway.spring.jdbc.sql.meta.ColumnInfo;
import com.nway.spring.jdbc.sql.meta.EntityInfo;
import java.util.ArrayList;
import java.util.List;

public class UpdateBuilder
extends SqlBuilder<UpdateBuilder> {
    private final List<String> sets = new ArrayList<String>();

    @Override
    protected SqlType getSqlType() {
        return SqlType.UPDATE;
    }

    public UpdateBuilder(Class<?> beanClass) {
        super(beanClass);
        this.initFilled();
    }

    public <T> UpdateBuilder set(SSupplier<T> val) {
        if (this.isInvalid(val.get())) {
            return this;
        }
        this.sets.add(SqlBuilderUtils.getColumn(this.beanClass, val) + " = ?");
        this.param.add(val.get());
        return this;
    }

    public <T, R> UpdateBuilder set(SFunction<T, R> column, Object val) {
        if (this.isInvalid(val)) {
            return this;
        }
        this.sets.add(SqlBuilderUtils.getColumn(this.beanClass, column) + " = ?");
        this.param.add(val);
        return this;
    }

    public <T, R extends Number> UpdateBuilder increase(SFunction<T, R> column) {
        String columnName = SqlBuilderUtils.getColumn(this.beanClass, column);
        this.sets.add(columnName + " = " + columnName + " + 1");
        return this;
    }

    @Override
    public String getSql() {
        return "update " + SqlBuilderUtils.getTableNameFromCache(this.beanClass) + " set " + String.join((CharSequence)",", this.sets) + super.getSql();
    }

    private void initFilled() {
        EntityInfo entityInfo = SqlBuilderUtils.getEntityInfo(this.beanClass);
        for (ColumnInfo columnInfo : entityInfo.getColumnMap().values()) {
            if (NoneFillStrategy.class.equals(columnInfo.getFillStrategy().getClass()) || !columnInfo.getFillStrategy().isSupport(SqlType.UPDATE)) continue;
            Object value = columnInfo.getFillStrategy().getValue(SqlType.UPDATE, FillStrategy.DEFAULT_NONE);
            this.sets.add(columnInfo.getColumnName() + " = ?");
            this.param.add(value);
        }
    }
}

