/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.sql.fill.incrementer;

import com.nway.spring.jdbc.sql.fill.incrementer.Sequence;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class IdWorker {
    public static final DateTimeFormatter MILLISECOND = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final Sequence SEQUENCE = new Sequence();

    public static long getId() {
        return SEQUENCE.nextId();
    }

    public static String getIdStr() {
        return String.valueOf(SEQUENCE.nextId());
    }

    public static String getMillisecond() {
        return LocalDateTime.now().format(MILLISECOND);
    }

    public static String getTimeId() {
        return IdWorker.getMillisecond() + IdWorker.getIdStr();
    }

    public static String get32UUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new UUID(random.nextLong(), random.nextLong()).toString().replace("-", "");
    }
}

