/*
 * Decompiled with CFR 0.152.
 */
package com.nway.spring.jdbc.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class ReflectionUtils {
    private static final Map<Class<?>, Field[]> DECLARED_FIELD_CACHE = new ConcurrentReferenceHashMap(256);

    public static Field[] getAllFields(Class<?> clazz) {
        Field[] fieldArr = DECLARED_FIELD_CACHE.get(clazz);
        if (fieldArr != null) {
            return fieldArr;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        try {
            for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = searchType.getDeclaredFields()) {
                    if (fieldNameList.contains(field.getName())) continue;
                    fieldList.add(field);
                    fieldNameList.add(field.getName());
                }
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
        }
        fieldArr = fieldList.toArray(new Field[0]);
        DECLARED_FIELD_CACHE.put(clazz, fieldArr);
        return fieldArr;
    }
}

