/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.expressions;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.StringUtils;

public class ExpressionProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionProcessor.class);
    private static final Set<String> oldFragmentExpressions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final IExpressionContext context;

    public ExpressionProcessor(IExpressionContext iExpressionContext) {
        this.context = iExpressionContext;
    }

    public IStandardExpression parse(String string) {
        return StandardExpressions.getExpressionParser((IEngineConfiguration)this.context.getConfiguration()).parseExpression(this.context, string);
    }

    public FragmentExpression parseFragmentExpression(String string) {
        if (!StringUtils.isEmpty((String)string) && !string.matches("(?s)^~\\{.+\\}$")) {
            if (oldFragmentExpressions.add(string)) {
                logger.warn("Fragment expression \"{}\" is being wrapped as a Thymeleaf 3 fragment expression (~{...}) for backwards compatibility purposes.  This wrapping will be dropped in the next major version of the expression processor, so please rewrite as a Thymeleaf 3 fragment expression to future-proof your code.  See https://github.com/thymeleaf/thymeleaf/issues/451 for more information.", (Object)string);
            }
            return (FragmentExpression)this.parse("~{" + string + "}");
        }
        return (FragmentExpression)this.parse(string);
    }

    public Object process(String string) {
        return this.parse(string).execute(this.context);
    }

    public String processAsString(String string) {
        return String.valueOf(this.process(string));
    }

    public final IExpressionContext getContext() {
        return this.context;
    }
}

