/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.models.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nz.net.ultraq.thymeleaf.internal.ITemplateEventConsumer;
import nz.net.ultraq.thymeleaf.internal.ITemplateEventIntPredicate;
import nz.net.ultraq.thymeleaf.internal.ITemplateEventPredicate;
import nz.net.ultraq.thymeleaf.models.extensions.ChildModelIterator;
import nz.net.ultraq.thymeleaf.models.extensions.EventIterator;
import nz.net.ultraq.thymeleaf.models.extensions.IModelExtensions$$Lambda$1;
import nz.net.ultraq.thymeleaf.models.extensions.IModelExtensions$$Lambda$2;
import nz.net.ultraq.thymeleaf.models.extensions.ITemplateEventExtensions;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;

public class IModelExtensions {
    public static boolean asBoolean(@Nullable IModel iModel) {
        return iModel != null && iModel.size() > 0;
    }

    @Nullable
    public static ChildModelIterator childModelIterator(@Nonnull IModel iModel) {
        return IModelExtensions.isElement(iModel) ? new ChildModelIterator(iModel) : null;
    }

    public static void each(@Nullable IModel iModel, @Nonnull ITemplateEventConsumer iTemplateEventConsumer) {
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            iTemplateEventConsumer.accept(iterator.next());
        }
    }

    public static boolean equals(IModel iModel, Object object) {
        if (iModel != null && object instanceof IModel) {
            IModel iModel2 = (IModel)object;
            if (iModel.size() == iModel2.size()) {
                return IModelExtensions.everyWithIndex(iModel, IModelExtensions$$Lambda$1.lambdaFactory$(iModel2));
            }
        }
        return false;
    }

    public static boolean equalsIgnoreWhitespace(@Nullable IModel iModel, @Nullable IModel iModel2) {
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        Iterator<ITemplateEvent> iterator2 = IModelExtensions.maskNull(iModel2);
        while (true) {
            ITemplateEvent iTemplateEvent;
            if (!iterator.hasNext()) {
                do {
                    if (iterator2.hasNext()) continue;
                    return true;
                } while (ITemplateEventExtensions.isWhitespace(iterator2.next()));
                return false;
            }
            ITemplateEvent iTemplateEvent2 = iterator.next();
            if (ITemplateEventExtensions.isWhitespace(iTemplateEvent2)) continue;
            do {
                if (iterator2.hasNext()) continue;
                return false;
            } while (ITemplateEventExtensions.isWhitespace(iTemplateEvent = iterator2.next()));
            if (!ITemplateEventExtensions.equals(iTemplateEvent2, iTemplateEvent)) break;
        }
        return false;
    }

    public static boolean everyWithIndex(@Nullable IModel iModel, @Nonnull ITemplateEventIntPredicate iTemplateEventIntPredicate) {
        int n = 0;
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            if (!iTemplateEventIntPredicate.test(iterator.next(), n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Nullable
    public static ITemplateEvent find(@Nullable IModel iModel, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            ITemplateEvent iTemplateEvent = iterator.next();
            if (!iTemplateEventPredicate.test(iTemplateEvent)) continue;
            return iTemplateEvent;
        }
        return null;
    }

    @Nonnull
    public static List<ITemplateEvent> findAll(@Nullable IModel iModel, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        ArrayList<ITemplateEvent> arrayList = new ArrayList<ITemplateEvent>();
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            ITemplateEvent iTemplateEvent = iterator.next();
            if (!iTemplateEventPredicate.test(iTemplateEvent)) continue;
            arrayList.add(iTemplateEvent);
        }
        return arrayList;
    }

    public static int findIndexOf(@Nonnull IModel iModel, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        int n = iModel.size();
        for (int i = 0; i < n; ++i) {
            ITemplateEvent iTemplateEvent = iModel.get(i);
            boolean bl = iTemplateEventPredicate.test(iTemplateEvent);
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public static int findIndexOf(@Nonnull IModel iModel, int n, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        int n2 = iModel.size();
        for (int i = n; i < n2; ++i) {
            ITemplateEvent iTemplateEvent = iModel.get(i);
            boolean bl = iTemplateEventPredicate.test(iTemplateEvent);
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public static int findIndexOfModel(@Nonnull IModel iModel, IModel iModel2) {
        ITemplateEvent iTemplateEvent = IModelExtensions.first(iModel2);
        return IModelExtensions.findIndexOf(iModel, IModelExtensions$$Lambda$2.lambdaFactory$(iTemplateEvent));
    }

    public static IModel findModel(@Nonnull IModel iModel, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        return IModelExtensions.getModel(iModel, IModelExtensions.findIndexOf(iModel, iTemplateEventPredicate));
    }

    public static ITemplateEvent first(@Nonnull IModel iModel) {
        return iModel.get(0);
    }

    @Nullable
    public static IModel getModel(@Nonnull IModel iModel, int n) {
        if (0 <= n && n < iModel.size()) {
            IModel iModel2 = iModel.getConfiguration().getModelFactory(iModel.getTemplateMode()).createModel();
            int n2 = IModelExtensions.sizeOfModelAt(iModel, n);
            while (n2-- > 0) {
                iModel2.add(iModel.get(n));
                ++n;
            }
            return iModel2;
        }
        return null;
    }

    public static void insertModelWithWhitespace(@Nonnull IModel iModel, int n, @Nullable IModel iModel2, @Nonnull IModelFactory iModelFactory) {
        if (0 <= n && n <= iModel.size()) {
            IModel iModel3 = IModelExtensions.getModel(iModel, n);
            if (IModelExtensions.asBoolean(iModel3) && IModelExtensions.isWhitespace(iModel3)) {
                iModel.insertModel(n, iModel2);
                iModel.insertModel(n, iModel3);
                return;
            }
            if (n > 0 && IModelExtensions.asBoolean(iModel3 = IModelExtensions.getModel(iModel, n - 1)) && IModelExtensions.isWhitespace(iModel3)) {
                iModel.insertModel(n, iModel3);
                iModel.insertModel(n, iModel2);
                return;
            }
            iModel3 = iModelFactory.createModel((ITemplateEvent)iModelFactory.createText((CharSequence)"\n\t"));
            iModel.insertModel(n, iModel3);
            iModel.insertModel(n, iModel2);
            iModel.insertModel(n, iModel3);
        }
    }

    public static void insertWithWhitespace(@Nonnull IModel iModel, int n, @Nullable ITemplateEvent iTemplateEvent, @Nonnull IModelFactory iModelFactory) {
        if (0 <= n && n <= iModel.size()) {
            IModel iModel2 = IModelExtensions.getModel(iModel, n);
            if (IModelExtensions.asBoolean(iModel2) && IModelExtensions.isWhitespace(iModel2)) {
                iModel.insert(n, iTemplateEvent);
                iModel.insertModel(n, iModel2);
            } else {
                IText iText = iModelFactory.createText((CharSequence)"\n");
                if (n == 0) {
                    iModel.insert(n, (ITemplateEvent)iText);
                    iModel.insert(n, iTemplateEvent);
                } else if (n == iModel.size()) {
                    iModel.insert(n, (ITemplateEvent)iText);
                    iModel.insert(n, iTemplateEvent);
                    iModel.insert(n, (ITemplateEvent)iText);
                }
            }
        }
    }

    public static boolean isElement(@Nonnull IModel iModel) {
        return IModelExtensions.first(iModel) instanceof IOpenElementTag && IModelExtensions.last(iModel) instanceof ICloseElementTag;
    }

    public static boolean isElementOf(@Nonnull IModel iModel, String string) {
        return IModelExtensions.isElement(iModel) && Objects.equals(((IElementTag)IModelExtensions.first(iModel)).getElementCompleteName(), string);
    }

    public static boolean isWhitespace(@Nonnull IModel iModel) {
        return iModel.size() == 1 && ITemplateEventExtensions.isWhitespace(IModelExtensions.first(iModel));
    }

    @Nonnull
    public static EventIterator iterator(@Nonnull IModel iModel) {
        return new EventIterator(iModel);
    }

    private static Iterator<ITemplateEvent> maskNull(@Nullable IModel iModel) {
        EventIterator eventIterator = iModel != null ? IModelExtensions.iterator(iModel) : null;
        return eventIterator != null ? eventIterator : Collections.emptyIterator();
    }

    public static ITemplateEvent last(@Nonnull IModel iModel) {
        return iModel.get(iModel.size() - 1);
    }

    public static void removeChildren(@Nonnull IModel iModel) {
        if (IModelExtensions.isElement(iModel)) {
            while (iModel.size() > 2) {
                iModel.remove(1);
            }
        }
    }

    public static void removeFirst(@Nonnull IModel iModel) {
        iModel.remove(0);
    }

    public static void removeLast(@Nonnull IModel iModel) {
        iModel.remove(iModel.size() - 1);
    }

    public static void removeModel(@Nonnull IModel iModel, int n) {
        if (0 <= n && n < iModel.size()) {
            for (int i = IModelExtensions.sizeOfModelAt(iModel, n); i > 0; --i) {
                iModel.remove(n);
            }
        }
    }

    public static void replaceModel(@Nonnull IModel iModel, int n, @Nullable IModel iModel2) {
        if (0 <= n && n < iModel.size()) {
            IModelExtensions.removeModel(iModel, n);
            iModel.insertModel(n, iModel2);
        }
    }

    public static int sizeOfModelAt(@Nonnull IModel iModel, int n) {
        ITemplateEvent iTemplateEvent;
        int n2 = n;
        if ((iTemplateEvent = iModel.get(n2++)) instanceof IOpenElementTag) {
            int n3 = 0;
            while (true) {
                if ((iTemplateEvent = iModel.get(n2++)) instanceof IOpenElementTag) {
                    ++n3;
                    continue;
                }
                if (!(iTemplateEvent instanceof ICloseElementTag) || ((ICloseElementTag)iTemplateEvent).isUnmatched()) continue;
                if (n3 == 0) break;
                --n3;
            }
            return n2 - n;
        }
        return 1;
    }

    public static void trim(@Nonnull IModel iModel) {
        while (ITemplateEventExtensions.isWhitespace(IModelExtensions.first(iModel))) {
            IModelExtensions.removeFirst(iModel);
        }
        while (ITemplateEventExtensions.isWhitespace(IModelExtensions.last(iModel))) {
            IModelExtensions.removeLast(iModel);
        }
    }

    static /* synthetic */ boolean lambda$findIndexOfModel$1(ITemplateEvent iTemplateEvent, ITemplateEvent iTemplateEvent2) {
        return ITemplateEventExtensions.equals(iTemplateEvent2, iTemplateEvent);
    }

    static /* synthetic */ boolean lambda$equals$0(IModel iModel, ITemplateEvent iTemplateEvent, int n) {
        return ITemplateEventExtensions.equals(iTemplateEvent, iModel.get(n));
    }
}

