/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect.fragments;

import java.util.concurrent.atomic.AtomicBoolean;
import nz.net.ultraq.thymeleaf.layoutdialect.fragments.extensions.FragmentExtensions;
import nz.net.ultraq.thymeleaf.layoutdialect.models.ElementMerger;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.IModelExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class FragmentProcessor
extends AbstractAttributeTagProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FragmentProcessor.class);
    private static final AtomicBoolean warned = new AtomicBoolean();
    public static final String PROCESSOR_NAME = "fragment";
    public static final int PROCESSOR_PRECEDENCE = 1;

    public FragmentProcessor(TemplateMode templateMode, String string) {
        super(templateMode, string, null, false, PROCESSOR_NAME, true, 1, true);
    }

    protected void doProcess(ITemplateContext iTemplateContext, IProcessableElementTag iProcessableElementTag, AttributeName attributeName, String string, IElementTagStructureHandler iElementTagStructureHandler) {
        IProcessableElementTag iProcessableElementTag2;
        Object object;
        if (this.getTemplateMode() == TemplateMode.HTML) {
            object = iTemplateContext.getElementStack().iterator();
            while (object.hasNext()) {
                iProcessableElementTag2 = (IProcessableElementTag)object.next();
                if (!"head".equals(iProcessableElementTag2.getElementCompleteName())) continue;
                if (!warned.compareAndSet(false, true)) break;
                logger.warn("You don't need to put the layout:fragment/data-layout-fragment attribute into the <head> section - the decoration process will automatically copy the <head> section of your content templates into your layout page.");
                break;
            }
        }
        if ((object = FragmentExtensions.getFragmentCollection(iTemplateContext).get(string)) != null && !object.isEmpty()) {
            iProcessableElementTag2 = (IModel)object.get(object.size() - 1);
            IModelFactory iModelFactory = iTemplateContext.getModelFactory();
            IModel iModel = new ElementMerger(iTemplateContext).merge(iModelFactory.createModel((ITemplateEvent)iProcessableElementTag), (IModel)iProcessableElementTag2);
            iModel.replace(0, (ITemplateEvent)iModelFactory.removeAttribute((IProcessableElementTag)IModelExtensions.first(iModel), this.getDialectPrefix(), PROCESSOR_NAME));
            iElementTagStructureHandler.replaceWith(iModel, true);
        }
    }
}

