/*
 * Decompiled with CFR 0.152.
 */
package capstone;

import capstone.Capstone;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import java.util.Arrays;
import java.util.List;

public class Arm64 {

    public static class OpInfo
    implements capstone.api.arm64.OpInfo {
        public int cc;
        public boolean updateFlags;
        public boolean writeback;
        public Operand[] operands;

        public OpInfo(UnionOpInfo op_info) {
            this.cc = op_info.cc;
            this.updateFlags = op_info._update_flags > 0;
            this.writeback = op_info._writeback > 0;
            this.operands = op_info.op;
        }

        @Override
        public boolean isWriteBack() {
            return this.writeback;
        }

        @Override
        public boolean isUpdateFlags() {
            return this.updateFlags;
        }

        @Override
        public int getCodeCondition() {
            return this.cc;
        }

        public Operand[] getOperands() {
            return this.operands;
        }
    }

    public static class UnionOpInfo
    extends Capstone.UnionOpInfo {
        public int cc;
        public byte _update_flags;
        public byte _writeback;
        public byte op_count;
        public Operand[] op = new Operand[8];

        public void read() {
            this.readField("cc");
            this.readField("_update_flags");
            this.readField("_writeback");
            this.readField("op_count");
            this.op = new Operand[this.op_count];
            if (this.op_count != 0) {
                this.readField("op");
            }
        }

        public List getFieldOrder() {
            return Arrays.asList("cc", "_update_flags", "_writeback", "op_count", "op");
        }
    }

    public static class Operand
    extends Structure
    implements capstone.api.arm64.Operand {
        public int vector_index;
        public int vas;
        public int vess;
        public OpShift shift;
        public int ext;
        public int type;
        public OpValue value;
        public byte access;

        public void read() {
            this.readField("type");
            if (this.type == 3) {
                this.value.setType(MemType.class);
            }
            if (this.type == 4) {
                this.value.setType(Double.TYPE);
            }
            if (this.type == 2 || this.type == 64 || this.type == 1 || this.type == 65 || this.type == 66 || this.type == 67 || this.type == 68 || this.type == 69 || this.type == 70) {
                this.value.setType(Integer.TYPE);
            }
            if (this.type == 0) {
                return;
            }
            this.readField("access");
            this.readField("value");
            this.readField("ext");
            this.readField("shift");
            this.readField("vess");
            this.readField("vas");
            this.readField("vector_index");
        }

        public List<String> getFieldOrder() {
            return Arrays.asList("vector_index", "vas", "vess", "shift", "ext", "type", "value", "access");
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getExt() {
            return this.ext;
        }

        @Override
        public int getVas() {
            return this.vas;
        }

        @Override
        public int getVess() {
            return this.vess;
        }

        @Override
        public int getVectorIndex() {
            return this.vector_index;
        }

        @Override
        public OpValue getValue() {
            return this.value;
        }

        @Override
        public OpShift getShift() {
            return this.shift;
        }
    }

    public static class OpShift
    extends Structure
    implements capstone.api.OpShift {
        public int type;
        public int value;

        public List<String> getFieldOrder() {
            return Arrays.asList("type", "value");
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static class OpValue
    extends Union
    implements capstone.api.arm64.OpValue {
        public int reg;
        public long imm;
        public double fp;
        public MemType mem;
        public int pstate;
        public int sys;
        public int prefetch;
        public int barrier;

        public List<String> getFieldOrder() {
            return Arrays.asList("reg", "imm", "fp", "mem", "pstate", "sys", "prefetch", "barrier");
        }

        @Override
        public int getReg() {
            return this.reg;
        }

        @Override
        public long getImm() {
            return this.imm;
        }

        @Override
        public double getFp() {
            return this.fp;
        }

        @Override
        public MemType getMem() {
            return this.mem;
        }
    }

    public static class MemType
    extends Structure
    implements capstone.api.arm64.MemType {
        public int base;
        public int index;
        public int disp;

        public List<String> getFieldOrder() {
            return Arrays.asList("base", "index", "disp");
        }

        @Override
        public int getBase() {
            return this.base;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getDisp() {
            return this.disp;
        }
    }
}

