/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler;

import de.fearlesstobi.demangler.ast.ArraySubscriptingExpression;
import de.fearlesstobi.demangler.ast.ArrayType;
import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.BinaryExpression;
import de.fearlesstobi.demangler.ast.BracedExpression;
import de.fearlesstobi.demangler.ast.BracedRangeExpression;
import de.fearlesstobi.demangler.ast.CallExpression;
import de.fearlesstobi.demangler.ast.CastExpression;
import de.fearlesstobi.demangler.ast.ConditionalExpression;
import de.fearlesstobi.demangler.ast.ConversionExpression;
import de.fearlesstobi.demangler.ast.ConversionOperatorType;
import de.fearlesstobi.demangler.ast.CtorDtorNameType;
import de.fearlesstobi.demangler.ast.CtorVtableSpecialName;
import de.fearlesstobi.demangler.ast.CvType;
import de.fearlesstobi.demangler.ast.DeleteExpression;
import de.fearlesstobi.demangler.ast.DtorName;
import de.fearlesstobi.demangler.ast.DynamicExceptionSpec;
import de.fearlesstobi.demangler.ast.ElaboratedType;
import de.fearlesstobi.demangler.ast.EnclosedExpression;
import de.fearlesstobi.demangler.ast.EncodedFunction;
import de.fearlesstobi.demangler.ast.FoldExpression;
import de.fearlesstobi.demangler.ast.ForwardTemplateReference;
import de.fearlesstobi.demangler.ast.FunctionParameter;
import de.fearlesstobi.demangler.ast.FunctionType;
import de.fearlesstobi.demangler.ast.GlobalQualifiedName;
import de.fearlesstobi.demangler.ast.InitListExpression;
import de.fearlesstobi.demangler.ast.IntegerCastExpression;
import de.fearlesstobi.demangler.ast.IntegerLiteral;
import de.fearlesstobi.demangler.ast.LiteralOperator;
import de.fearlesstobi.demangler.ast.LocalName;
import de.fearlesstobi.demangler.ast.MemberExpression;
import de.fearlesstobi.demangler.ast.NameType;
import de.fearlesstobi.demangler.ast.NameTypeWithTemplateArguments;
import de.fearlesstobi.demangler.ast.NestedName;
import de.fearlesstobi.demangler.ast.NewExpression;
import de.fearlesstobi.demangler.ast.NodeArray;
import de.fearlesstobi.demangler.ast.NodeType;
import de.fearlesstobi.demangler.ast.NoexceptSpec;
import de.fearlesstobi.demangler.ast.PackedTemplateParameter;
import de.fearlesstobi.demangler.ast.PackedTemplateParameterExpansion;
import de.fearlesstobi.demangler.ast.PointerType;
import de.fearlesstobi.demangler.ast.PostfixExpression;
import de.fearlesstobi.demangler.ast.PostfixQualifiedType;
import de.fearlesstobi.demangler.ast.PrefixExpression;
import de.fearlesstobi.demangler.ast.QualifiedName;
import de.fearlesstobi.demangler.ast.ReferenceType;
import de.fearlesstobi.demangler.ast.SimpleReferenceType;
import de.fearlesstobi.demangler.ast.SpecialName;
import de.fearlesstobi.demangler.ast.SpecialSubstitution;
import de.fearlesstobi.demangler.ast.StdQualifiedName;
import de.fearlesstobi.demangler.ast.TemplateArguments;
import de.fearlesstobi.demangler.ast.ThrowExpression;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Demangler {
    private static final String base36 = "0123456789abcdefghijklmnopqrstuvwxyz";
    private final List<BaseNode> substitutionList = new LinkedList<BaseNode>();
    private List<BaseNode> templateParamList = new LinkedList<BaseNode>();
    private final String mangled;
    private int position;
    private final int length;
    private boolean canForwardTemplateReference;
    private boolean canParseTemplateArgs;

    private Demangler(String mangled) {
        this.mangled = mangled;
        this.position = 0;
        this.length = mangled.length();
        this.canParseTemplateArgs = true;
    }

    private boolean consumeIf(String toConsume) {
        String mangledPart = this.mangled.substring(this.position);
        if (mangledPart.startsWith(toConsume)) {
            this.position += toConsume.length();
            return true;
        }
        return false;
    }

    private String peekString(int offset, int length) {
        if (this.position + offset >= length) {
            return null;
        }
        return this.mangled.substring(this.position + offset, this.position + offset + length);
    }

    private char peek() {
        return this.peek(0);
    }

    private char peek(int offset) {
        if (this.position + offset >= this.length) {
            return '\u0000';
        }
        return this.mangled.charAt(this.position + offset);
    }

    private char consume() {
        if (this.position < this.length) {
            return this.mangled.charAt(this.position++);
        }
        return '\u0000';
    }

    private int count() {
        return this.length - this.position;
    }

    private static int fromBase36(String encoded) {
        char[] encodedArray = encoded.toLowerCase().toCharArray();
        char[] reversedEncoded = new char[encodedArray.length];
        for (int i = 0; i < encodedArray.length; ++i) {
            reversedEncoded[encodedArray.length - i - 1] = encodedArray[i];
        }
        int result = 0;
        for (int i = 0; i < reversedEncoded.length; ++i) {
            int value = base36.indexOf(reversedEncoded[i]);
            if (value == -1) {
                return -1;
            }
            result += value * (int)Math.pow(36.0, i);
        }
        return result;
    }

    private int parseSeqId() {
        int seqIdLen;
        String part = this.mangled.substring(this.position);
        for (seqIdLen = 0; seqIdLen < part.length() && Character.isLetterOrDigit(part.charAt(seqIdLen)); ++seqIdLen) {
        }
        this.position += seqIdLen;
        return Demangler.fromBase36(part.substring(0, seqIdLen));
    }

    private BaseNode parseSubstitution() {
        if (!this.consumeIf("S")) {
            return null;
        }
        char substitutionSecondChar = this.peek();
        if (Character.isLowerCase(substitutionSecondChar)) {
            switch (substitutionSecondChar) {
                case 'a': {
                    ++this.position;
                    return new SpecialSubstitution(SpecialSubstitution.SpecialType.Allocator);
                }
                case 'b': {
                    ++this.position;
                    return new SpecialSubstitution(SpecialSubstitution.SpecialType.BasicString);
                }
                case 's': {
                    ++this.position;
                    return new SpecialSubstitution(SpecialSubstitution.SpecialType.String);
                }
                case 'i': {
                    ++this.position;
                    return new SpecialSubstitution(SpecialSubstitution.SpecialType.IStream);
                }
                case 'o': {
                    ++this.position;
                    return new SpecialSubstitution(SpecialSubstitution.SpecialType.OStream);
                }
                case 'd': {
                    ++this.position;
                    return new SpecialSubstitution(SpecialSubstitution.SpecialType.IOStream);
                }
            }
            return null;
        }
        if (this.consumeIf("_")) {
            if (!this.substitutionList.isEmpty()) {
                return this.substitutionList.get(0);
            }
            return null;
        }
        int seqId = this.parseSeqId();
        if (seqId < 0) {
            return null;
        }
        if (!this.consumeIf("_") || ++seqId >= this.substitutionList.size()) {
            return null;
        }
        return this.substitutionList.get(seqId);
    }

    private boolean parseCallOffset() {
        if (this.consumeIf("h")) {
            return this.parseNumber(true).length() == 0 || !this.consumeIf("_");
        }
        if (this.consumeIf("v")) {
            return this.parseNumber(true).length() == 0 || !this.consumeIf("_") || this.parseNumber(true).length() == 0 || !this.consumeIf("_");
        }
        return true;
    }

    private BaseNode parseClassEnumType() {
        String elaboratedType = null;
        if (this.consumeIf("Ts")) {
            elaboratedType = "struct";
        } else if (this.consumeIf("Tu")) {
            elaboratedType = "union";
        } else if (this.consumeIf("Te")) {
            elaboratedType = "enum";
        }
        BaseNode name = this.parseName();
        if (name == null) {
            return null;
        }
        if (elaboratedType == null) {
            return name;
        }
        return new ElaboratedType(elaboratedType, name);
    }

    private BaseNode parseFunctionType() {
        int cvQualifiers = this.parseCvQualifiers();
        BaseNode exceptionSpec = null;
        if (this.consumeIf("Do")) {
            exceptionSpec = new NameType("noexcept");
        } else if (this.consumeIf("DO")) {
            BaseNode expression = this.parseExpression();
            if (expression == null || !this.consumeIf("E")) {
                return null;
            }
            exceptionSpec = new NoexceptSpec(expression);
        } else if (this.consumeIf("Dw")) {
            ArrayList<BaseNode> types = new ArrayList<BaseNode>();
            while (!this.consumeIf("E")) {
                BaseNode type = this.parseType();
                if (type == null) {
                    return null;
                }
                types.add(type);
            }
            exceptionSpec = new DynamicExceptionSpec(new NodeArray(types));
        }
        this.consumeIf("Dx");
        if (!this.consumeIf("F")) {
            return null;
        }
        this.consumeIf("Y");
        BaseNode returnType = this.parseType();
        if (returnType == null) {
            return null;
        }
        int referenceQualifier = 0;
        ArrayList<BaseNode> params = new ArrayList<BaseNode>();
        while (!this.consumeIf("E")) {
            if (this.consumeIf("v")) continue;
            if (this.consumeIf("RE")) {
                referenceQualifier = 2;
                break;
            }
            if (this.consumeIf("OE")) {
                referenceQualifier = 1;
                break;
            }
            BaseNode type = this.parseType();
            if (type == null) {
                return null;
            }
            params.add(type);
        }
        return new FunctionType(returnType, new NodeArray(params), new CvType(cvQualifiers, null), new SimpleReferenceType(referenceQualifier, null), exceptionSpec);
    }

    private BaseNode parseArrayType() {
        if (!this.consumeIf("A")) {
            return null;
        }
        if (Character.isDigit(this.peek())) {
            String dimension = this.parseNumber();
            if (dimension.length() == 0 || !this.consumeIf("_")) {
                return null;
            }
            BaseNode elementType = this.parseType();
            if (elementType == null) {
                return null;
            }
            return new ArrayType(elementType, dimension);
        }
        if (!this.consumeIf("_")) {
            BaseNode dimensionExpression = this.parseExpression();
            if (dimensionExpression == null || !this.consumeIf("_")) {
                return null;
            }
            BaseNode elementType = this.parseType();
            if (elementType == null) {
                return null;
            }
            return new ArrayType(elementType, dimensionExpression);
        }
        BaseNode elementType = this.parseType();
        if (elementType == null) {
            return null;
        }
        return new ArrayType(elementType);
    }

    private BaseNode parseType() {
        return this.parseType(null);
    }

    private BaseNode parseType(NameparserContext context) {
        BaseNode result;
        if (context == null) {
            context = new NameparserContext();
        }
        block0 : switch (this.peek()) {
            case 'K': 
            case 'V': 
            case 'r': {
                int typePos = 0;
                if (this.peek(typePos) == 'r') {
                    ++typePos;
                }
                if (this.peek(typePos) == 'V') {
                    ++typePos;
                }
                if (this.peek(typePos) == 'K') {
                    ++typePos;
                }
                if (this.peek(typePos) == 'F' || this.peek(typePos) == 'D' && (this.peek(typePos + 1) == 'o' || this.peek(typePos + 1) == 'O' || this.peek(typePos + 1) == 'w' || this.peek(typePos + 1) == 'x')) {
                    result = this.parseFunctionType();
                    break;
                }
                int cv = this.parseCvQualifiers();
                result = this.parseType(context);
                if (result == null) {
                    return null;
                }
                result = new CvType(cv, result);
                break;
            }
            case 'U': {
                return null;
            }
            case 'v': {
                ++this.position;
                return new NameType("void");
            }
            case 'w': {
                ++this.position;
                return new NameType("wchar_t");
            }
            case 'b': {
                ++this.position;
                return new NameType("boolean");
            }
            case 'c': {
                ++this.position;
                return new NameType("char");
            }
            case 'a': {
                ++this.position;
                return new NameType("signed char");
            }
            case 'h': {
                ++this.position;
                return new NameType("unsigned char");
            }
            case 's': {
                ++this.position;
                return new NameType("short");
            }
            case 't': {
                ++this.position;
                return new NameType("unsigned short");
            }
            case 'i': {
                ++this.position;
                return new NameType("int");
            }
            case 'j': {
                ++this.position;
                return new NameType("unsigned int");
            }
            case 'l': {
                ++this.position;
                return new NameType("long");
            }
            case 'm': {
                ++this.position;
                return new NameType("unsigned long");
            }
            case 'x': {
                ++this.position;
                return new NameType("long long");
            }
            case 'y': {
                ++this.position;
                return new NameType("unsigned long long");
            }
            case 'n': {
                ++this.position;
                return new NameType("__int128");
            }
            case 'o': {
                ++this.position;
                return new NameType("unsigned __int128");
            }
            case 'f': {
                ++this.position;
                return new NameType("float");
            }
            case 'd': {
                ++this.position;
                return new NameType("double");
            }
            case 'e': {
                ++this.position;
                return new NameType("long double");
            }
            case 'g': {
                ++this.position;
                return new NameType("__float128");
            }
            case 'z': {
                ++this.position;
                return new NameType("...");
            }
            case 'u': {
                ++this.position;
                return this.parseSourceName();
            }
            case 'D': {
                switch (this.peek(1)) {
                    case 'd': {
                        this.position += 2;
                        return new NameType("decimal64");
                    }
                    case 'e': {
                        this.position += 2;
                        return new NameType("decimal128");
                    }
                    case 'f': {
                        this.position += 2;
                        return new NameType("decimal32");
                    }
                    case 'h': {
                        this.position += 2;
                        return new NameType("half");
                    }
                    case 'i': {
                        this.position += 2;
                        return new NameType("char32_t");
                    }
                    case 's': {
                        this.position += 2;
                        return new NameType("char16_t");
                    }
                    case 'a': {
                        this.position += 2;
                        return new NameType("decltype(auto)");
                    }
                    case 'n': {
                        this.position += 2;
                        return new NameType("decltype(nullptr)");
                    }
                    case 'T': 
                    case 't': {
                        this.position += 2;
                        result = this.parseDecltype();
                        break block0;
                    }
                    case 'O': 
                    case 'o': 
                    case 'w': 
                    case 'x': {
                        result = this.parseFunctionType();
                        break block0;
                    }
                }
                return null;
            }
            case 'F': {
                result = this.parseFunctionType();
                break;
            }
            case 'A': {
                return this.parseArrayType();
            }
            case 'M': {
                ++this.position;
                return null;
            }
            case 'T': {
                if (this.peek(1) == 's' || this.peek(1) == 'u' || this.peek(1) == 'e') {
                    result = this.parseClassEnumType();
                    break;
                }
                result = this.parseTemplateParam();
                if (result == null) {
                    return null;
                }
                if (!this.canParseTemplateArgs || this.peek() != 'I') break;
                BaseNode templateArguments = this.parseTemplateArguments();
                if (templateArguments == null) {
                    return null;
                }
                result = new NameTypeWithTemplateArguments(result, templateArguments);
                break;
            }
            case 'P': {
                ++this.position;
                result = this.parseType(context);
                if (result == null) {
                    return null;
                }
                result = new PointerType(result);
                break;
            }
            case 'R': {
                ++this.position;
                result = this.parseType(context);
                if (result == null) {
                    return null;
                }
                result = new ReferenceType("&", result);
                break;
            }
            case 'O': {
                ++this.position;
                result = this.parseType(context);
                if (result == null) {
                    return null;
                }
                result = new ReferenceType("&&", result);
                break;
            }
            case 'C': {
                ++this.position;
                result = this.parseType(context);
                if (result == null) {
                    return null;
                }
                result = new PostfixQualifiedType(" complex", result);
                break;
            }
            case 'G': {
                ++this.position;
                result = this.parseType(context);
                if (result == null) {
                    return null;
                }
                result = new PostfixQualifiedType(" imaginary", result);
                break;
            }
            case 'S': {
                if (this.peek(1) != 't') {
                    BaseNode substitution = this.parseSubstitution();
                    if (substitution == null) {
                        return null;
                    }
                    if (this.canParseTemplateArgs && this.peek() == 'I') {
                        BaseNode templateArgument = this.parseTemplateArgument();
                        if (templateArgument == null) {
                            return null;
                        }
                        result = new NameTypeWithTemplateArguments(substitution, templateArgument);
                        break;
                    }
                    return substitution;
                }
                result = this.parseClassEnumType();
                break;
            }
            default: {
                result = this.parseClassEnumType();
            }
        }
        if (result != null) {
            this.substitutionList.add(result);
        }
        return result;
    }

    private BaseNode parseSpecialName(NameparserContext context) {
        boolean isVirtual;
        if (this.peek() != 'T') {
            if (this.consumeIf("GV")) {
                BaseNode name = this.parseName();
                if (name == null) {
                    return null;
                }
                return new SpecialName("guard variable for ", name);
            }
            return null;
        }
        switch (this.peek(1)) {
            case 'V': {
                this.position += 2;
                BaseNode node = this.parseType(context);
                if (node == null) {
                    return null;
                }
                return new SpecialName("vtable for ", node);
            }
            case 'T': {
                this.position += 2;
                BaseNode node = this.parseType(context);
                if (node == null) {
                    return null;
                }
                return new SpecialName("VTT for ", node);
            }
            case 'I': {
                this.position += 2;
                BaseNode node = this.parseType(context);
                if (node == null) {
                    return null;
                }
                return new SpecialName("typeinfo for ", node);
            }
            case 'S': {
                this.position += 2;
                BaseNode node = this.parseType(context);
                if (node == null) {
                    return null;
                }
                return new SpecialName("typeinfo name for ", node);
            }
            case 'c': {
                this.position += 2;
                if (this.parseCallOffset() || this.parseCallOffset()) {
                    return null;
                }
                BaseNode node = this.parseEncoding();
                if (node == null) {
                    return null;
                }
                return new SpecialName("covariant return thunk to ", node);
            }
            case 'C': {
                this.position += 2;
                BaseNode firstType = this.parseType();
                if (firstType == null || this.parseNumber(true).length() == 0 || !this.consumeIf("_")) {
                    return null;
                }
                BaseNode secondType = this.parseType();
                return new CtorVtableSpecialName(secondType, firstType);
            }
            case 'H': {
                this.position += 2;
                BaseNode node = this.parseName();
                if (node == null) {
                    return null;
                }
                return new SpecialName("thread-local initialization routine for ", node);
            }
            case 'W': {
                this.position += 2;
                BaseNode node = this.parseName();
                if (node == null) {
                    return null;
                }
                return new SpecialName("thread-local wrapper routine for ", node);
            }
        }
        ++this.position;
        boolean bl = isVirtual = this.peek() == 'v';
        if (this.parseCallOffset()) {
            return null;
        }
        BaseNode node = this.parseEncoding();
        if (node == null) {
            return null;
        }
        if (isVirtual) {
            return new SpecialName("virtual thunk to ", node);
        }
        return new SpecialName("non-virtual thunk to ", node);
    }

    private int parseCvQualifiers() {
        int qualifiers = 0;
        if (this.consumeIf("r")) {
            qualifiers |= 4;
        }
        if (this.consumeIf("V")) {
            qualifiers |= 2;
        }
        if (this.consumeIf("K")) {
            qualifiers |= 1;
        }
        return qualifiers;
    }

    private SimpleReferenceType parseRefQualifiers() {
        int result = 0;
        if (this.consumeIf("O")) {
            result = 1;
        } else if (this.consumeIf("R")) {
            result = 2;
        }
        return new SimpleReferenceType(result, null);
    }

    private BaseNode createNameNode(BaseNode prev, BaseNode name, NameparserContext context) {
        BaseNode result = name;
        if (prev != null) {
            result = new NestedName(name, prev);
        }
        if (context != null) {
            context.finishWithTemplateArguments = false;
        }
        return result;
    }

    private int parsePositiveNumber() {
        int numberLength;
        String part = this.mangled.substring(this.position);
        for (numberLength = 0; numberLength < part.length() && Character.isDigit(part.charAt(numberLength)); ++numberLength) {
        }
        this.position += numberLength;
        if (numberLength == 0) {
            return -1;
        }
        return Integer.parseInt(part.substring(0, numberLength));
    }

    private String parseNumber() {
        return this.parseNumber(false);
    }

    private String parseNumber(boolean isSigned) {
        int numberLength;
        if (isSigned) {
            this.consumeIf("n");
        }
        if (this.count() == 0 || !Character.isDigit(this.mangled.charAt(this.position))) {
            return null;
        }
        String part = this.mangled.substring(this.position);
        for (numberLength = 0; numberLength < part.length() && Character.isDigit(part.charAt(numberLength)); ++numberLength) {
        }
        this.position += numberLength;
        return part.substring(0, numberLength);
    }

    private BaseNode parseSourceName() {
        int length = this.parsePositiveNumber();
        if (this.count() < length || length <= 0) {
            return null;
        }
        String name = this.mangled.substring(this.position, this.position + length);
        this.position += length;
        if (name.startsWith("_GLOBAL__N")) {
            return new NameType("(anonymous namespace)");
        }
        return new NameType(name);
    }

    private BaseNode parseOperatorName(NameparserContext context) {
        switch (this.peek()) {
            case 'a': {
                switch (this.peek(1)) {
                    case 'a': {
                        this.position += 2;
                        return new NameType("operator&&");
                    }
                    case 'd': 
                    case 'n': {
                        this.position += 2;
                        return new NameType("operator&");
                    }
                    case 'N': {
                        this.position += 2;
                        return new NameType("operator&=");
                    }
                    case 'S': {
                        this.position += 2;
                        return new NameType("operator=");
                    }
                }
                return null;
            }
            case 'c': {
                switch (this.peek(1)) {
                    case 'l': {
                        this.position += 2;
                        return new NameType("operator()");
                    }
                    case 'm': {
                        this.position += 2;
                        return new NameType("operator,");
                    }
                    case 'o': {
                        this.position += 2;
                        return new NameType("operator~");
                    }
                    case 'v': {
                        this.position += 2;
                        boolean canparseTemplateArgsBackup = this.canParseTemplateArgs;
                        boolean canForwardTemplateReferenceBackup = this.canForwardTemplateReference;
                        this.canParseTemplateArgs = false;
                        this.canForwardTemplateReference = canForwardTemplateReferenceBackup || context != null;
                        BaseNode type = this.parseType();
                        this.canParseTemplateArgs = canparseTemplateArgsBackup;
                        this.canForwardTemplateReference = canForwardTemplateReferenceBackup;
                        if (type == null) {
                            return null;
                        }
                        if (context != null) {
                            context.ctorDtorConversion = true;
                        }
                        return new ConversionOperatorType(type);
                    }
                }
                return null;
            }
            case 'd': {
                switch (this.peek(1)) {
                    case 'a': {
                        this.position += 2;
                        return new NameType("operator delete[]");
                    }
                    case 'e': {
                        this.position += 2;
                        return new NameType("operator*");
                    }
                    case 'l': {
                        this.position += 2;
                        return new NameType("operator delete");
                    }
                    case 'v': {
                        this.position += 2;
                        return new NameType("operator/");
                    }
                    case 'V': {
                        this.position += 2;
                        return new NameType("operator/=");
                    }
                }
                return null;
            }
            case 'e': {
                switch (this.peek(1)) {
                    case 'o': {
                        this.position += 2;
                        return new NameType("operator^");
                    }
                    case 'O': {
                        this.position += 2;
                        return new NameType("operator^=");
                    }
                    case 'q': {
                        this.position += 2;
                        return new NameType("operator==");
                    }
                }
                return null;
            }
            case 'g': {
                switch (this.peek(1)) {
                    case 'e': {
                        this.position += 2;
                        return new NameType("operator>=");
                    }
                    case 't': {
                        this.position += 2;
                        return new NameType("operator>");
                    }
                }
                return null;
            }
            case 'i': {
                if (this.peek(1) == 'x') {
                    this.position += 2;
                    return new NameType("operator[]");
                }
                return null;
            }
            case 'l': {
                switch (this.peek(1)) {
                    case 'e': {
                        this.position += 2;
                        return new NameType("operator<=");
                    }
                    case 'i': {
                        this.position += 2;
                        BaseNode sourceName = this.parseSourceName();
                        if (sourceName == null) {
                            return null;
                        }
                        return new LiteralOperator(sourceName);
                    }
                    case 's': {
                        this.position += 2;
                        return new NameType("operator<<");
                    }
                    case 'S': {
                        this.position += 2;
                        return new NameType("operator<<=");
                    }
                    case 't': {
                        this.position += 2;
                        return new NameType("operator<");
                    }
                }
                return null;
            }
            case 'm': {
                switch (this.peek(1)) {
                    case 'i': {
                        this.position += 2;
                        return new NameType("operator-");
                    }
                    case 'I': {
                        this.position += 2;
                        return new NameType("operator-=");
                    }
                    case 'l': {
                        this.position += 2;
                        return new NameType("operator*");
                    }
                    case 'L': {
                        this.position += 2;
                        return new NameType("operator*=");
                    }
                    case 'm': {
                        this.position += 2;
                        return new NameType("operator--");
                    }
                }
                return null;
            }
            case 'n': {
                switch (this.peek(1)) {
                    case 'a': {
                        this.position += 2;
                        return new NameType("operator new[]");
                    }
                    case 'e': {
                        this.position += 2;
                        return new NameType("operator!=");
                    }
                    case 'g': {
                        this.position += 2;
                        return new NameType("operator-");
                    }
                    case 't': {
                        this.position += 2;
                        return new NameType("operator!");
                    }
                    case 'w': {
                        this.position += 2;
                        return new NameType("operator new");
                    }
                }
                return null;
            }
            case 'o': {
                switch (this.peek(1)) {
                    case 'o': {
                        this.position += 2;
                        return new NameType("operator||");
                    }
                    case 'r': {
                        this.position += 2;
                        return new NameType("operator|");
                    }
                    case 'R': {
                        this.position += 2;
                        return new NameType("operator|=");
                    }
                }
                return null;
            }
            case 'p': {
                switch (this.peek(1)) {
                    case 'm': {
                        this.position += 2;
                        return new NameType("operator->*");
                    }
                    case 'l': 
                    case 's': {
                        this.position += 2;
                        return new NameType("operator+");
                    }
                    case 'L': {
                        this.position += 2;
                        return new NameType("operator+=");
                    }
                    case 'p': {
                        this.position += 2;
                        return new NameType("operator++");
                    }
                    case 't': {
                        this.position += 2;
                        return new NameType("operator->");
                    }
                }
                return null;
            }
            case 'q': {
                if (this.peek(1) == 'u') {
                    this.position += 2;
                    return new NameType("operator?");
                }
                return null;
            }
            case 'r': {
                switch (this.peek(1)) {
                    case 'm': {
                        this.position += 2;
                        return new NameType("operator%");
                    }
                    case 'M': {
                        this.position += 2;
                        return new NameType("operator%=");
                    }
                    case 's': {
                        this.position += 2;
                        return new NameType("operator>>");
                    }
                    case 'S': {
                        this.position += 2;
                        return new NameType("operator>>=");
                    }
                }
                return null;
            }
            case 's': {
                if (this.peek(1) == 's') {
                    this.position += 2;
                    return new NameType("operator<=>");
                }
                return null;
            }
            case 'v': {
                return null;
            }
        }
        return null;
    }

    private BaseNode parseUnqualifiedName(NameparserContext context) {
        BaseNode result = null;
        char c = this.peek();
        if (c != 'U') {
            if (Character.isDigit(c)) {
                result = this.parseSourceName();
            } else if (!this.consumeIf("DC")) {
                result = this.parseOperatorName(context);
            }
        }
        if (result != null) {
            // empty if block
        }
        return result;
    }

    private BaseNode parseCtorDtorName(NameparserContext context, BaseNode prev) {
        if (prev.type == NodeType.SpecialSubstitution && prev instanceof SpecialSubstitution) {
            ((SpecialSubstitution)prev).SetExtended();
        }
        if (this.consumeIf("C")) {
            boolean isInherited = this.consumeIf("I");
            char ctorDtorType = this.peek();
            if (ctorDtorType != '1' && ctorDtorType != '2' && ctorDtorType != '3') {
                return null;
            }
            ++this.position;
            if (context != null) {
                context.ctorDtorConversion = true;
            }
            if (isInherited && this.parseName(context) == null) {
                return null;
            }
            return new CtorDtorNameType(prev, false);
        }
        if (this.consumeIf("D")) {
            char c = this.peek();
            if (c != '0' && c != '1' && c != '2') {
                return null;
            }
            ++this.position;
            if (context != null) {
                context.ctorDtorConversion = true;
            }
            return new CtorDtorNameType(prev, true);
        }
        return null;
    }

    private BaseNode parseFunctionParameter() {
        if (this.consumeIf("fp")) {
            this.parseCvQualifiers();
            if (!this.consumeIf("_")) {
                return null;
            }
            return new FunctionParameter(this.parseNumber());
        }
        if (this.consumeIf("fL")) {
            String l1Number = this.parseNumber();
            if (l1Number == null || l1Number.length() == 0) {
                return null;
            }
            if (!this.consumeIf("p")) {
                return null;
            }
            this.parseCvQualifiers();
            if (!this.consumeIf("_")) {
                return null;
            }
            return new FunctionParameter(this.parseNumber());
        }
        return null;
    }

    private BaseNode parseFoldExpression() {
        String operatorName;
        boolean isLeftFold;
        if (!this.consumeIf("f")) {
            return null;
        }
        char foldKind = this.peek();
        boolean hasInitializer = foldKind == 'L' || foldKind == 'R';
        boolean bl = isLeftFold = foldKind == 'l' || foldKind == 'L';
        if (!isLeftFold && foldKind != 'r' && foldKind != 'R') {
            return null;
        }
        ++this.position;
        switch (this.peekString(0, 2)) {
            case "aa": {
                operatorName = "&&";
                break;
            }
            case "an": {
                operatorName = "&";
                break;
            }
            case "aN": {
                operatorName = "&=";
                break;
            }
            case "aS": {
                operatorName = "=";
                break;
            }
            case "cm": {
                operatorName = ",";
                break;
            }
            case "ds": {
                operatorName = ".*";
                break;
            }
            case "dv": {
                operatorName = "/";
                break;
            }
            case "dV": {
                operatorName = "/=";
                break;
            }
            case "eo": {
                operatorName = "^";
                break;
            }
            case "eO": {
                operatorName = "^=";
                break;
            }
            case "eq": {
                operatorName = "==";
                break;
            }
            case "ge": {
                operatorName = ">=";
                break;
            }
            case "gt": {
                operatorName = ">";
                break;
            }
            case "le": {
                operatorName = "<=";
                break;
            }
            case "ls": {
                operatorName = "<<";
                break;
            }
            case "lS": {
                operatorName = "<<=";
                break;
            }
            case "lt": {
                operatorName = "<";
                break;
            }
            case "mi": {
                operatorName = "-";
                break;
            }
            case "mI": {
                operatorName = "-=";
                break;
            }
            case "ml": {
                operatorName = "*";
                break;
            }
            case "mL": {
                operatorName = "*=";
                break;
            }
            case "ne": {
                operatorName = "!=";
                break;
            }
            case "oo": {
                operatorName = "||";
                break;
            }
            case "or": {
                operatorName = "|";
                break;
            }
            case "oR": {
                operatorName = "|=";
                break;
            }
            case "pl": {
                operatorName = "+";
                break;
            }
            case "pL": {
                operatorName = "+=";
                break;
            }
            case "rm": {
                operatorName = "%";
                break;
            }
            case "rM": {
                operatorName = "%=";
                break;
            }
            case "rs": {
                operatorName = ">>";
                break;
            }
            case "rS": {
                operatorName = ">>=";
                break;
            }
            default: {
                return null;
            }
        }
        this.position += 2;
        BaseNode expression = this.parseExpression();
        if (expression == null) {
            return null;
        }
        BaseNode initializer = null;
        if (hasInitializer && (initializer = this.parseExpression()) == null) {
            return null;
        }
        if (isLeftFold && initializer != null) {
            BaseNode temp = expression;
            expression = initializer;
            initializer = temp;
        }
        return new FoldExpression(isLeftFold, operatorName, new PackedTemplateParameterExpansion(expression), initializer);
    }

    private BaseNode parseConversionExpression() {
        if (!this.consumeIf("cv")) {
            return null;
        }
        boolean canparseTemplateArgsBackup = this.canParseTemplateArgs;
        this.canParseTemplateArgs = false;
        BaseNode type = this.parseType();
        this.canParseTemplateArgs = canparseTemplateArgsBackup;
        if (type == null) {
            return null;
        }
        ArrayList<BaseNode> expressions = new ArrayList<BaseNode>();
        if (this.consumeIf("_")) {
            while (!this.consumeIf("E")) {
                BaseNode expression = this.parseExpression();
                if (expression == null) {
                    return null;
                }
                expressions.add(expression);
            }
        } else {
            BaseNode expression = this.parseExpression();
            if (expression == null) {
                return null;
            }
            expressions.add(expression);
        }
        return new ConversionExpression(type, new NodeArray(expressions));
    }

    private BaseNode parseBinaryExpression(String name) {
        BaseNode leftPart = this.parseExpression();
        if (leftPart == null) {
            return null;
        }
        BaseNode rightPart = this.parseExpression();
        if (rightPart == null) {
            return null;
        }
        return new BinaryExpression(leftPart, name, rightPart);
    }

    private BaseNode parsePrefixExpression(String name) {
        BaseNode expression = this.parseExpression();
        if (expression == null) {
            return null;
        }
        return new PrefixExpression(name, expression);
    }

    private BaseNode parseBracedExpression() {
        if (this.peek() == 'd') {
            switch (this.peek(1)) {
                case 'i': {
                    this.position += 2;
                    BaseNode field = this.parseSourceName();
                    if (field == null) {
                        return null;
                    }
                    BaseNode bracedExpressionNode = this.parseBracedExpression();
                    if (bracedExpressionNode == null) {
                        return null;
                    }
                    return new BracedExpression(field, bracedExpressionNode, false);
                }
                case 'x': {
                    this.position += 2;
                    BaseNode index = this.parseExpression();
                    if (index == null) {
                        return null;
                    }
                    BaseNode bracedExpressionNode = this.parseBracedExpression();
                    if (bracedExpressionNode == null) {
                        return null;
                    }
                    return new BracedExpression(index, bracedExpressionNode, true);
                }
                case 'X': {
                    this.position += 2;
                    BaseNode rangeBeginExpression = this.parseExpression();
                    if (rangeBeginExpression == null) {
                        return null;
                    }
                    BaseNode rangeEndExpression = this.parseExpression();
                    if (rangeEndExpression == null) {
                        return null;
                    }
                    BaseNode bracedExpressionNode = this.parseBracedExpression();
                    if (bracedExpressionNode == null) {
                        return null;
                    }
                    return new BracedRangeExpression(rangeBeginExpression, rangeEndExpression, bracedExpressionNode);
                }
            }
        }
        return this.parseExpression();
    }

    private BaseNode parseNewExpression() {
        boolean isArray;
        boolean isGlobal = this.consumeIf("gs");
        boolean bl = isArray = this.peek(1) == 'a';
        if (!this.consumeIf("nw") || !this.consumeIf("na")) {
            return null;
        }
        ArrayList<BaseNode> expressions = new ArrayList<BaseNode>();
        ArrayList<BaseNode> initializers = new ArrayList<BaseNode>();
        while (!this.consumeIf("_")) {
            BaseNode expression = this.parseExpression();
            if (expression == null) {
                return null;
            }
            expressions.add(expression);
        }
        BaseNode typeNode = this.parseType();
        if (typeNode == null) {
            return null;
        }
        if (this.consumeIf("pi")) {
            while (!this.consumeIf("E")) {
                BaseNode initializer = this.parseExpression();
                if (initializer == null) {
                    return null;
                }
                initializers.add(initializer);
            }
        } else if (!this.consumeIf("E")) {
            return null;
        }
        return new NewExpression(new NodeArray(expressions), typeNode, new NodeArray(initializers), isGlobal, isArray);
    }

    private BaseNode parseExpression() {
        boolean isGlobal = this.consumeIf("gs");
        if (this.count() < 2) {
            return null;
        }
        switch (this.peek()) {
            case 'L': {
                return this.parseExpressionPrimary();
            }
            case 'T': {
                return this.parseTemplateParam();
            }
            case 'f': {
                char c = this.peek(1);
                if (c == 'p' || c == 'L' && Character.isDigit(this.peek(2))) {
                    return this.parseFunctionParameter();
                }
                return this.parseFoldExpression();
            }
            case 'a': {
                switch (this.peek(1)) {
                    case 'a': {
                        this.position += 2;
                        return this.parseBinaryExpression("&&");
                    }
                    case 'd': 
                    case 'n': {
                        this.position += 2;
                        return this.parseBinaryExpression("&");
                    }
                    case 'N': {
                        this.position += 2;
                        return this.parseBinaryExpression("&=");
                    }
                    case 'S': {
                        this.position += 2;
                        return this.parseBinaryExpression("=");
                    }
                    case 't': {
                        this.position += 2;
                        BaseNode type = this.parseType();
                        if (type == null) {
                            return null;
                        }
                        return new EnclosedExpression("alignof (", type, ")");
                    }
                    case 'z': {
                        this.position += 2;
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new EnclosedExpression("alignof (", expression, ")");
                    }
                }
                return null;
            }
            case 'c': {
                switch (this.peek(1)) {
                    case 'c': {
                        this.position += 2;
                        BaseNode to = this.parseType();
                        if (to == null) {
                            return null;
                        }
                        BaseNode from = this.parseExpression();
                        if (from == null) {
                            return null;
                        }
                        return new CastExpression("const_cast", to, from);
                    }
                    case 'l': {
                        this.position += 2;
                        BaseNode callee = this.parseExpression();
                        if (callee == null) {
                            return null;
                        }
                        ArrayList<BaseNode> names = new ArrayList<BaseNode>();
                        while (!this.consumeIf("E")) {
                            BaseNode expression = this.parseExpression();
                            if (expression == null) {
                                return null;
                            }
                            names.add(expression);
                        }
                        return new CallExpression(callee, names);
                    }
                    case 'm': {
                        this.position += 2;
                        return this.parseBinaryExpression(",");
                    }
                    case 'o': {
                        this.position += 2;
                        return this.parsePrefixExpression("~");
                    }
                    case 'v': {
                        return this.parseConversionExpression();
                    }
                }
                return null;
            }
            case 'd': {
                switch (this.peek(1)) {
                    case 'a': {
                        this.position += 2;
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new DeleteExpression(expression, isGlobal, true);
                    }
                    case 'c': {
                        this.position += 2;
                        BaseNode type = this.parseType();
                        if (type == null) {
                            return null;
                        }
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new CastExpression("dynamic_cast", type, expression);
                    }
                    case 'e': {
                        this.position += 2;
                        return this.parsePrefixExpression("*");
                    }
                    case 'l': {
                        this.position += 2;
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new DeleteExpression(expression, isGlobal, false);
                    }
                    case 'n': {
                        return this.parseUnresolvedName();
                    }
                    case 's': {
                        this.position += 2;
                        BaseNode leftNode = this.parseExpression();
                        if (leftNode == null) {
                            return null;
                        }
                        BaseNode rightNode = this.parseExpression();
                        if (rightNode == null) {
                            return null;
                        }
                        return new MemberExpression(leftNode, ".*", rightNode);
                    }
                    case 't': {
                        this.position += 2;
                        BaseNode leftNode = this.parseExpression();
                        if (leftNode == null) {
                            return null;
                        }
                        BaseNode rightNode = this.parseExpression();
                        if (rightNode == null) {
                            return null;
                        }
                        return new MemberExpression(leftNode, ".", rightNode);
                    }
                    case 'v': {
                        this.position += 2;
                        return this.parseBinaryExpression("/");
                    }
                    case 'V': {
                        this.position += 2;
                        return this.parseBinaryExpression("/=");
                    }
                }
                return null;
            }
            case 'e': {
                switch (this.peek(1)) {
                    case 'o': {
                        this.position += 2;
                        return this.parseBinaryExpression("^");
                    }
                    case 'O': {
                        this.position += 2;
                        return this.parseBinaryExpression("^=");
                    }
                    case 'q': {
                        this.position += 2;
                        return this.parseBinaryExpression("==");
                    }
                }
                return null;
            }
            case 'g': {
                switch (this.peek(1)) {
                    case 'e': {
                        this.position += 2;
                        return this.parseBinaryExpression(">=");
                    }
                    case 't': {
                        this.position += 2;
                        return this.parseBinaryExpression(">");
                    }
                }
                return null;
            }
            case 'i': {
                switch (this.peek(1)) {
                    case 'x': {
                        this.position += 2;
                        BaseNode baseNode = this.parseExpression();
                        if (baseNode == null) {
                            return null;
                        }
                        BaseNode subscript = this.parseExpression();
                        return new ArraySubscriptingExpression(baseNode, subscript);
                    }
                    case 'l': {
                        this.position += 2;
                        ArrayList<BaseNode> bracedExpressions = new ArrayList<BaseNode>();
                        while (!this.consumeIf("E")) {
                            BaseNode expression = this.parseBracedExpression();
                            if (expression == null) {
                                return null;
                            }
                            bracedExpressions.add(expression);
                        }
                        return new InitListExpression(null, bracedExpressions);
                    }
                }
                return null;
            }
            case 'l': {
                switch (this.peek(1)) {
                    case 'e': {
                        this.position += 2;
                        return this.parseBinaryExpression("<=");
                    }
                    case 's': {
                        this.position += 2;
                        return this.parseBinaryExpression("<<");
                    }
                    case 'S': {
                        this.position += 2;
                        return this.parseBinaryExpression("<<=");
                    }
                    case 't': {
                        this.position += 2;
                        return this.parseBinaryExpression("<");
                    }
                }
                return null;
            }
            case 'm': {
                switch (this.peek(1)) {
                    case 'i': {
                        this.position += 2;
                        return this.parseBinaryExpression("-");
                    }
                    case 'I': {
                        this.position += 2;
                        return this.parseBinaryExpression("-=");
                    }
                    case 'l': {
                        this.position += 2;
                        return this.parseBinaryExpression("*");
                    }
                    case 'L': {
                        this.position += 2;
                        return this.parseBinaryExpression("*=");
                    }
                    case 'm': {
                        this.position += 2;
                        if (this.consumeIf("_")) {
                            return this.parsePrefixExpression("--");
                        }
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new PostfixExpression(expression, "--");
                    }
                }
                return null;
            }
            case 'n': {
                switch (this.peek(1)) {
                    case 'a': 
                    case 'w': {
                        this.position += 2;
                        return this.parseNewExpression();
                    }
                    case 'e': {
                        this.position += 2;
                        return this.parseBinaryExpression("!=");
                    }
                    case 'g': {
                        this.position += 2;
                        return this.parsePrefixExpression("-");
                    }
                    case 't': {
                        this.position += 2;
                        return this.parsePrefixExpression("!");
                    }
                    case 'x': {
                        this.position += 2;
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new EnclosedExpression("noexcept (", expression, ")");
                    }
                }
                return null;
            }
            case 'o': {
                switch (this.peek(1)) {
                    case 'n': {
                        return this.parseUnresolvedName();
                    }
                    case 'o': {
                        this.position += 2;
                        return this.parseBinaryExpression("||");
                    }
                    case 'r': {
                        this.position += 2;
                        return this.parseBinaryExpression("|");
                    }
                    case 'R': {
                        this.position += 2;
                        return this.parseBinaryExpression("|=");
                    }
                }
                return null;
            }
            case 'p': {
                switch (this.peek(1)) {
                    case 'm': {
                        this.position += 2;
                        return this.parseBinaryExpression("->*");
                    }
                    case 'l': 
                    case 's': {
                        this.position += 2;
                        return this.parseBinaryExpression("+");
                    }
                    case 'L': {
                        this.position += 2;
                        return this.parseBinaryExpression("+=");
                    }
                    case 'p': {
                        this.position += 2;
                        if (this.consumeIf("_")) {
                            return this.parsePrefixExpression("++");
                        }
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new PostfixExpression(expression, "++");
                    }
                    case 't': {
                        this.position += 2;
                        BaseNode leftNode = this.parseExpression();
                        if (leftNode == null) {
                            return null;
                        }
                        BaseNode rightNode = this.parseExpression();
                        if (rightNode == null) {
                            return null;
                        }
                        return new MemberExpression(leftNode, "->", rightNode);
                    }
                }
                return null;
            }
            case 'q': {
                if (this.peek(1) == 'u') {
                    this.position += 2;
                    BaseNode condition = this.parseExpression();
                    if (condition == null) {
                        return null;
                    }
                    BaseNode leftNode = this.parseExpression();
                    if (leftNode == null) {
                        return null;
                    }
                    BaseNode rightNode = this.parseExpression();
                    if (rightNode == null) {
                        return null;
                    }
                    return new ConditionalExpression(condition, leftNode, rightNode);
                }
                return null;
            }
            case 'r': {
                switch (this.peek(1)) {
                    case 'c': {
                        this.position += 2;
                        BaseNode to = this.parseType();
                        if (to == null) {
                            return null;
                        }
                        BaseNode from = this.parseExpression();
                        if (from == null) {
                            return null;
                        }
                        return new CastExpression("reinterpret_cast", to, from);
                    }
                    case 'M': 
                    case 'm': {
                        this.position += 2;
                        return this.parseBinaryExpression("%");
                    }
                    case 's': {
                        this.position += 2;
                        return this.parseBinaryExpression(">>");
                    }
                    case 'S': {
                        this.position += 2;
                        return this.parseBinaryExpression(">>=");
                    }
                }
                return null;
            }
            case 's': {
                switch (this.peek(1)) {
                    case 'c': {
                        this.position += 2;
                        BaseNode to = this.parseType();
                        if (to == null) {
                            return null;
                        }
                        BaseNode from = this.parseExpression();
                        if (from == null) {
                            return null;
                        }
                        return new CastExpression("static_cast", to, from);
                    }
                    case 'p': {
                        this.position += 2;
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new PackedTemplateParameterExpansion(expression);
                    }
                    case 'r': {
                        return this.parseUnresolvedName();
                    }
                    case 't': {
                        this.position += 2;
                        BaseNode enclosedType = this.parseType();
                        if (enclosedType == null) {
                            return null;
                        }
                        return new EnclosedExpression("sizeof (", enclosedType, ")");
                    }
                    case 'z': {
                        this.position += 2;
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new EnclosedExpression("sizeof (", expression, ")");
                    }
                    case 'Z': {
                        this.position += 2;
                        switch (this.peek()) {
                            case 'T': {
                                BaseNode sizeofParamNode = this.parseFunctionParameter();
                                if (sizeofParamNode == null) {
                                    return null;
                                }
                                return new EnclosedExpression("sizeof...(", new PackedTemplateParameterExpansion(sizeofParamNode), ")");
                            }
                            case 'f': {
                                BaseNode sizeofParamNode = this.parseFunctionParameter();
                                if (sizeofParamNode == null) {
                                    return null;
                                }
                                return new EnclosedExpression("sizeof...(", sizeofParamNode, ")");
                            }
                        }
                        return null;
                    }
                    case 'P': {
                        this.position += 2;
                        ArrayList<BaseNode> arguments = new ArrayList<BaseNode>();
                        while (!this.consumeIf("E")) {
                            BaseNode argument = this.parseTemplateArgument();
                            if (argument == null) {
                                return null;
                            }
                            arguments.add(argument);
                        }
                        return new EnclosedExpression("sizeof...(", new NodeArray(arguments), ")");
                    }
                }
                return null;
            }
            case 't': {
                switch (this.peek(1)) {
                    case 'e': {
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new EnclosedExpression("typeid (", expression, ")");
                    }
                    case 't': {
                        BaseNode enclosedType = this.parseExpression();
                        if (enclosedType == null) {
                            return null;
                        }
                        return new EnclosedExpression("typeid (", enclosedType, ")");
                    }
                    case 'l': {
                        this.position += 2;
                        BaseNode typeNode = this.parseType();
                        if (typeNode == null) {
                            return null;
                        }
                        ArrayList<BaseNode> bracedExpressions = new ArrayList<BaseNode>();
                        while (!this.consumeIf("E")) {
                            BaseNode expression = this.parseBracedExpression();
                            if (expression == null) {
                                return null;
                            }
                            bracedExpressions.add(expression);
                        }
                        return new InitListExpression(typeNode, bracedExpressions);
                    }
                    case 'r': {
                        this.position += 2;
                        return new NameType("throw");
                    }
                    case 'w': {
                        this.position += 2;
                        BaseNode expression = this.parseExpression();
                        if (expression == null) {
                            return null;
                        }
                        return new ThrowExpression(expression);
                    }
                }
                return null;
            }
        }
        if (Character.isDigit(this.peek())) {
            return this.parseUnresolvedName();
        }
        return null;
    }

    private BaseNode parseIntegerLiteral(String literalName) {
        String number = this.parseNumber(true);
        if (number == null || number.length() == 0 || !this.consumeIf("E")) {
            return null;
        }
        return new IntegerLiteral(literalName, number);
    }

    private BaseNode parseExpressionPrimary() {
        if (!this.consumeIf("L")) {
            return null;
        }
        switch (this.peek()) {
            case 'w': {
                ++this.position;
                return this.parseIntegerLiteral("wchar_t");
            }
            case 'b': {
                if (this.consumeIf("b0E")) {
                    return new NameType("false", NodeType.BooleanExpression);
                }
                if (this.consumeIf("b1E")) {
                    return new NameType("true", NodeType.BooleanExpression);
                }
                return null;
            }
            case 'c': {
                ++this.position;
                return this.parseIntegerLiteral("char");
            }
            case 'a': {
                ++this.position;
                return this.parseIntegerLiteral("signed char");
            }
            case 'h': {
                ++this.position;
                return this.parseIntegerLiteral("unsigned char");
            }
            case 's': {
                ++this.position;
                return this.parseIntegerLiteral("short");
            }
            case 't': {
                ++this.position;
                return this.parseIntegerLiteral("unsigned short");
            }
            case 'i': {
                ++this.position;
                return this.parseIntegerLiteral("");
            }
            case 'j': {
                ++this.position;
                return this.parseIntegerLiteral("u");
            }
            case 'l': {
                ++this.position;
                return this.parseIntegerLiteral("l");
            }
            case 'm': {
                ++this.position;
                return this.parseIntegerLiteral("ul");
            }
            case 'x': {
                ++this.position;
                return this.parseIntegerLiteral("ll");
            }
            case 'y': {
                ++this.position;
                return this.parseIntegerLiteral("ull");
            }
            case 'n': {
                ++this.position;
                return this.parseIntegerLiteral("__int128");
            }
            case 'o': {
                ++this.position;
                return this.parseIntegerLiteral("unsigned __int128");
            }
            case 'd': 
            case 'e': 
            case 'f': {
                return null;
            }
            case '_': {
                BaseNode encoding;
                if (this.consumeIf("_Z") && (encoding = this.parseEncoding()) != null && this.consumeIf("E")) {
                    return encoding;
                }
                return null;
            }
            case 'T': {
                return null;
            }
        }
        BaseNode type = this.parseType();
        if (type == null) {
            return null;
        }
        String number = this.parseNumber();
        if (number == null || number.length() == 0 || !this.consumeIf("E")) {
            return null;
        }
        return new IntegerCastExpression(type, number);
    }

    private BaseNode parseDecltype() {
        if (!this.consumeIf("D") || !this.consumeIf("t") && !this.consumeIf("T")) {
            return null;
        }
        BaseNode expression = this.parseExpression();
        if (expression == null) {
            return null;
        }
        if (!this.consumeIf("E")) {
            return null;
        }
        return new EnclosedExpression("decltype(", expression, ")");
    }

    private BaseNode parseTemplateParam() {
        if (!this.consumeIf("T")) {
            return null;
        }
        int index = 0;
        if (!this.consumeIf("_")) {
            index = this.parsePositiveNumber();
            if (index < 0) {
                return null;
            }
            ++index;
            if (!this.consumeIf("_")) {
                return null;
            }
        }
        if (this.canForwardTemplateReference) {
            return new ForwardTemplateReference();
        }
        if (index >= this.templateParamList.size()) {
            return null;
        }
        return this.templateParamList.get(index);
    }

    private BaseNode parseTemplateArguments() {
        return this.parseTemplateArguments(false);
    }

    private BaseNode parseTemplateArguments(boolean hasContext) {
        if (!this.consumeIf("I")) {
            return null;
        }
        if (hasContext) {
            this.templateParamList.clear();
        }
        ArrayList<BaseNode> args = new ArrayList<BaseNode>();
        while (!this.consumeIf("E")) {
            if (hasContext) {
                ArrayList<BaseNode> templateParamListTemp = new ArrayList<BaseNode>(this.templateParamList);
                BaseNode templateArgument = this.parseTemplateArgument();
                this.templateParamList = templateParamListTemp;
                if (templateArgument == null) {
                    return null;
                }
                args.add(templateArgument);
                if (templateArgument.type == NodeType.PackedTemplateArgument) {
                    templateArgument = new PackedTemplateParameter(((NodeArray)templateArgument).nodes);
                }
                this.templateParamList.add(templateArgument);
                continue;
            }
            BaseNode templateArgument = this.parseTemplateArgument();
            if (templateArgument == null) {
                return null;
            }
            args.add(templateArgument);
        }
        return new TemplateArguments(args);
    }

    private BaseNode parseTemplateArgument() {
        switch (this.peek()) {
            case 'X': {
                ++this.position;
                BaseNode expression = this.parseExpression();
                if (expression == null || !this.consumeIf("E")) {
                    return null;
                }
                return expression;
            }
            case 'L': {
                return this.parseExpressionPrimary();
            }
            case 'J': {
                ++this.position;
                ArrayList<BaseNode> templateArguments = new ArrayList<BaseNode>();
                while (!this.consumeIf("E")) {
                    BaseNode templateArgument = this.parseTemplateArgument();
                    if (templateArgument == null) {
                        return null;
                    }
                    templateArguments.add(templateArgument);
                }
                return new NodeArray(templateArguments, NodeType.PackedTemplateArgument);
            }
        }
        return this.parseType();
    }

    private BaseNode parseUnresolvedType() {
        if (this.peek() == 'T') {
            BaseNode templateParam = this.parseTemplateParam();
            if (templateParam == null) {
                return null;
            }
            this.substitutionList.add(templateParam);
            return templateParam;
        }
        if (this.peek() == 'D') {
            BaseNode declType = this.parseDecltype();
            if (declType == null) {
                return null;
            }
            this.substitutionList.add(declType);
            return declType;
        }
        return this.parseSubstitution();
    }

    private BaseNode parseSimpleId() {
        BaseNode sourceName = this.parseSourceName();
        if (sourceName == null) {
            return null;
        }
        if (this.peek() == 'I') {
            BaseNode templateArguments = this.parseTemplateArguments();
            if (templateArguments == null) {
                return null;
            }
            return new NameTypeWithTemplateArguments(sourceName, templateArguments);
        }
        return sourceName;
    }

    private BaseNode parseDestructorName() {
        BaseNode node = Character.isDigit(this.peek()) ? this.parseSimpleId() : this.parseUnresolvedType();
        if (node == null) {
            return null;
        }
        return new DtorName(node);
    }

    private BaseNode parseBaseUnresolvedName() {
        if (Character.isDigit(this.peek())) {
            return this.parseSimpleId();
        }
        if (this.consumeIf("dn")) {
            return this.parseDestructorName();
        }
        this.consumeIf("on");
        BaseNode operatorName = this.parseOperatorName(null);
        if (operatorName == null) {
            return null;
        }
        if (this.peek() == 'I') {
            BaseNode templateArguments = this.parseTemplateArguments();
            if (templateArguments == null) {
                return null;
            }
            return new NameTypeWithTemplateArguments(operatorName, templateArguments);
        }
        return operatorName;
    }

    private BaseNode parseUnresolvedName() {
        BaseNode result = null;
        if (this.consumeIf("srN")) {
            result = this.parseUnresolvedType();
            if (result == null) {
                return null;
            }
            if (this.peek() == 'I') {
                BaseNode templateArguments = this.parseTemplateArguments();
                if (templateArguments == null) {
                    return null;
                }
                result = new NameTypeWithTemplateArguments(result, templateArguments);
            }
            while (!this.consumeIf("E")) {
                BaseNode simpleId = this.parseSimpleId();
                if (simpleId == null) {
                    return null;
                }
                result = new QualifiedName(result, simpleId);
            }
            BaseNode baseName = this.parseBaseUnresolvedName();
            if (baseName == null) {
                return null;
            }
            return new QualifiedName(result, baseName);
        }
        boolean isGlobal = this.consumeIf("gs");
        if (!this.consumeIf("sr")) {
            result = this.parseBaseUnresolvedName();
            if (result == null) {
                return null;
            }
            if (isGlobal) {
                result = new GlobalQualifiedName(result);
            }
            return result;
        }
        if (Character.isDigit(this.peek())) {
            do {
                BaseNode qualifier;
                if ((qualifier = this.parseSimpleId()) == null) {
                    return null;
                }
                result = result != null ? new QualifiedName(result, qualifier) : (isGlobal ? new GlobalQualifiedName(qualifier) : qualifier);
            } while (!this.consumeIf("E"));
        } else {
            result = this.parseUnresolvedType();
            if (result == null) {
                return null;
            }
            if (this.peek() == 'I') {
                BaseNode templateArguments = this.parseTemplateArguments();
                if (templateArguments == null) {
                    return null;
                }
                result = new NameTypeWithTemplateArguments(result, templateArguments);
            }
        }
        BaseNode baseUnresolvedName = this.parseBaseUnresolvedName();
        if (baseUnresolvedName == null) {
            return null;
        }
        return new QualifiedName(result, baseUnresolvedName);
    }

    private BaseNode parseUnscopedName() {
        if (this.consumeIf("St")) {
            BaseNode unresolvedName = this.parseUnresolvedName();
            if (unresolvedName == null) {
                return null;
            }
            return new StdQualifiedName(unresolvedName);
        }
        return this.parseUnresolvedName();
    }

    private BaseNode parseNestedName(NameparserContext context) {
        if (this.consume() != 'N') {
            return null;
        }
        BaseNode result = null;
        CvType cv = new CvType(this.parseCvQualifiers(), null);
        if (context != null) {
            context.cvType = cv;
        }
        SimpleReferenceType ref = this.parseRefQualifiers();
        if (context != null) {
            context.ref = ref;
        }
        if (this.consumeIf("St")) {
            result = new NameType("std");
        }
        while (!this.consumeIf("E")) {
            if (this.consumeIf("M")) {
                if (result != null) continue;
                return null;
            }
            char c = this.peek();
            if (c == 'T') {
                BaseNode templateParam = this.parseTemplateParam();
                if (templateParam == null) {
                    return null;
                }
                result = this.createNameNode(result, templateParam, context);
                this.substitutionList.add(result);
                continue;
            }
            if (c == 'I') {
                BaseNode templateArgument = this.parseTemplateArguments(context != null);
                if (templateArgument == null || result == null) {
                    return null;
                }
                result = new NameTypeWithTemplateArguments(result, templateArgument);
                if (context != null) {
                    context.finishWithTemplateArguments = true;
                }
                this.substitutionList.add(result);
                continue;
            }
            if (c == 'D' && (this.peek(1) == 't' || this.peek(1) == 'T')) {
                BaseNode decltype = this.parseDecltype();
                if (decltype == null) {
                    return null;
                }
                result = this.createNameNode(result, decltype, context);
                this.substitutionList.add(result);
                continue;
            }
            if (c == 'S' && this.peek(1) != 't') {
                BaseNode substitution = this.parseSubstitution();
                if (substitution == null) {
                    return null;
                }
                if ((result = this.createNameNode(result, substitution, context)) == substitution) continue;
                this.substitutionList.add(substitution);
                continue;
            }
            if (c == 'C' || c == 'D' && this.peek(1) != 'C') {
                if (result == null) {
                    return null;
                }
                BaseNode ctOrDtorName = this.parseCtorDtorName(context, result);
                if (ctOrDtorName == null) {
                    return null;
                }
                if ((result = this.createNameNode(result, ctOrDtorName, context)) == null) {
                    return null;
                }
                this.substitutionList.add(result);
                continue;
            }
            BaseNode unqualifiedName = this.parseUnqualifiedName(context);
            if (unqualifiedName == null) {
                return null;
            }
            result = this.createNameNode(result, unqualifiedName, context);
            this.substitutionList.add(result);
        }
        if (result == null || this.substitutionList.size() == 0) {
            return null;
        }
        this.substitutionList.remove(this.substitutionList.size() - 1);
        return result;
    }

    private void parseDiscriminator() {
        if (this.count() == 0) {
            return;
        }
        if (this.consumeIf("_")) {
            this.consumeIf("_");
            while (Character.isDigit(this.peek()) && this.count() != 0) {
                this.consume();
            }
            this.consumeIf("_");
        }
    }

    private BaseNode parseLocalName(NameparserContext context) {
        if (!this.consumeIf("Z")) {
            return null;
        }
        BaseNode encoding = this.parseEncoding();
        if (encoding == null || !this.consumeIf("E")) {
            return null;
        }
        if (this.consumeIf("s")) {
            this.parseDiscriminator();
            return new LocalName(encoding, new NameType("String literal"));
        }
        if (this.consumeIf("d")) {
            this.parseNumber(true);
            if (!this.consumeIf("_")) {
                return null;
            }
            BaseNode entityName = this.parseName(context);
            if (entityName == null) {
                return null;
            }
            return new LocalName(encoding, entityName);
        }
        BaseNode entityName = this.parseName(context);
        if (entityName == null) {
            return null;
        }
        this.parseDiscriminator();
        return new LocalName(encoding, entityName);
    }

    private BaseNode parseName() {
        return this.parseName(null);
    }

    private BaseNode parseName(NameparserContext context) {
        this.consumeIf("L");
        if (this.peek() == 'N') {
            return this.parseNestedName(context);
        }
        if (this.peek() == 'Z') {
            return this.parseLocalName(context);
        }
        if (this.peek() == 'S' && this.peek(1) != 't') {
            BaseNode substitution = this.parseSubstitution();
            if (substitution == null) {
                return null;
            }
            if (this.peek() != 'I') {
                return null;
            }
            BaseNode templateArguments = this.parseTemplateArguments(context != null);
            if (templateArguments == null) {
                return null;
            }
            if (context != null) {
                context.finishWithTemplateArguments = true;
            }
            return new NameTypeWithTemplateArguments(substitution, templateArguments);
        }
        BaseNode result = this.parseUnscopedName();
        if (result == null) {
            return null;
        }
        if (this.peek() == 'I') {
            this.substitutionList.add(result);
            BaseNode templateArguments = this.parseTemplateArguments(context != null);
            if (templateArguments == null) {
                return null;
            }
            if (context != null) {
                context.finishWithTemplateArguments = true;
            }
            return new NameTypeWithTemplateArguments(result, templateArguments);
        }
        return result;
    }

    private boolean isEncodingEnd() {
        char c = this.peek();
        return this.count() == 0 || c == 'E' || c == '.' || c == '_';
    }

    private BaseNode parseEncoding() {
        NameparserContext context = new NameparserContext();
        if (this.peek() == 'T' || this.peek() == 'G' && this.peek(1) == 'V') {
            return this.parseSpecialName(context);
        }
        BaseNode name = this.parseName(context);
        if (name == null) {
            return null;
        }
        if (this.isEncodingEnd()) {
            return name;
        }
        BaseNode returnType = null;
        if (!context.ctorDtorConversion && context.finishWithTemplateArguments && (returnType = this.parseType()) == null) {
            return null;
        }
        if (this.consumeIf("v")) {
            return new EncodedFunction(name, null, context.cvType, context.ref, null, returnType);
        }
        ArrayList<BaseNode> params = new ArrayList<BaseNode>();
        CvType cv = context.cvType;
        SimpleReferenceType ref = context.ref;
        while (!this.isEncodingEnd()) {
            BaseNode param = this.parseType();
            if (param == null) {
                return null;
            }
            params.add(param);
        }
        return new EncodedFunction(name, new NodeArray(params), cv, ref, null, returnType);
    }

    private BaseNode parse() {
        if (this.consumeIf("_Z")) {
            BaseNode encoding = this.parseEncoding();
            if (encoding != null && this.count() == 0) {
                return encoding;
            }
            return null;
        }
        BaseNode type = this.parseType();
        if (type != null && this.count() == 0) {
            return type;
        }
        return null;
    }

    public static String parse(String originalMangled) {
        Demangler instance = new Demangler(originalMangled);
        BaseNode resNode = instance.parse();
        if (resNode != null) {
            StringWriter writer = new StringWriter();
            resNode.print(writer);
            return writer.toString();
        }
        return originalMangled;
    }

    class NameparserContext {
        CvType cvType;
        SimpleReferenceType ref;
        boolean finishWithTemplateArguments;
        boolean ctorDtorConversion;

        NameparserContext() {
        }
    }
}

