/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeType;
import java.io.StringWriter;

public class ReferenceType
extends BaseNode {
    private final String reference;
    private final BaseNode child;

    public ReferenceType(String reference, BaseNode child) {
        super(NodeType.ReferenceType);
        this.reference = reference;
        this.child = child;
    }

    @Override
    public boolean hasRightPart() {
        return this.child.hasRightPart();
    }

    @Override
    public void printLeft(StringWriter writer) {
        this.child.printLeft(writer);
        if (this.child.isArray()) {
            writer.write(" ");
        }
        if (this.child.isArray() || this.child.hasFunctions()) {
            writer.write("(");
        }
        writer.write(this.reference);
    }

    @Override
    public void printRight(StringWriter writer) {
        if (this.child.isArray() || this.child.hasFunctions()) {
            writer.write(")");
        }
        this.child.printRight(writer);
    }
}

