/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhkl0228.impersonator;

import com.github.zhkl0228.impersonator.Android;
import com.github.zhkl0228.impersonator.ExtensionListener;
import com.github.zhkl0228.impersonator.Impersonator;
import com.github.zhkl0228.impersonator.ImpersonatorApi;
import com.github.zhkl0228.impersonator.MacChrome;
import com.github.zhkl0228.impersonator.MacFirefox129;
import com.github.zhkl0228.impersonator.MacSafari;
import com.github.zhkl0228.impersonator.SecureRandomWrap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Http2Connection;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsUtils;

public abstract class ImpersonatorFactory
implements Impersonator,
ImpersonatorApi {
    private ExtensionListener extensionListener;
    private final int[] cipherSuites;
    private final String userAgent;
    private static final int[] GREASE;

    public static ImpersonatorApi macChrome() {
        return new MacChrome();
    }

    public static ImpersonatorApi macSafari() {
        return MacSafari.newMacSafari();
    }

    public static ImpersonatorApi macFirefox() {
        return new MacFirefox129();
    }

    public static ImpersonatorApi ios() {
        return MacSafari.newIOS();
    }

    public static ImpersonatorApi android() {
        return new Android();
    }

    @Override
    public SSLContext newSSLContext(KeyManager[] km, TrustManager[] tm) {
        try {
            if (tm == null || tm.length == 0) {
                tm = new TrustManager[]{new DummyX509KeyManager()};
            }
            SSLContext context = SSLContext.getInstance("TLSv1.3", "BCJSSE");
            context.init(km, tm, new SecureRandomWrap(this));
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException("newContext", e);
        }
    }

    public void onHttp2ConnectionInit(Http2Connection http2Connection) {
    }

    public abstract void fillRequestHeaders(Map<String, String> var1);

    protected final void addSignatureAlgorithmsExtension(Map<Integer, byte[]> clientExtensions, SignatureAndHashAlgorithm ... signatureAndHashAlgorithms) throws IOException {
        Vector<SignatureAndHashAlgorithm> supportedSignatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(signatureAndHashAlgorithms.length);
        supportedSignatureAlgorithms.addAll(Arrays.asList(signatureAndHashAlgorithms));
        TlsExtensionsUtils.addSignatureAlgorithmsExtension(clientExtensions, supportedSignatureAlgorithms);
    }

    protected final void addDelegatedCredentialsExtension(Map<Integer, byte[]> clientExtensions, SignatureAndHashAlgorithm ... signatureAndHashAlgorithms) throws IOException {
        Vector<SignatureAndHashAlgorithm> supportedSignatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(signatureAndHashAlgorithms.length);
        supportedSignatureAlgorithms.addAll(Arrays.asList(signatureAndHashAlgorithms));
        TlsExtensionsUtils.addDelegatedCredentialsExtension(clientExtensions, supportedSignatureAlgorithms);
    }

    protected final void addSupportedGroupsExtension(Map<Integer, byte[]> clientExtensions, Integer ... groups) throws IOException {
        Vector supportedGroups = new Vector();
        Collections.addAll(supportedGroups, groups);
        TlsExtensionsUtils.addSupportedGroupsExtension(clientExtensions, supportedGroups);
    }

    protected final void randomSupportedVersionsExtension(Map<Integer, byte[]> clientExtensions, ProtocolVersion ... protocolVersions) throws IOException {
        ArrayList<ProtocolVersion> list = new ArrayList<ProtocolVersion>(protocolVersions.length + 1);
        int grease = ImpersonatorFactory.randomGrease();
        list.add(ProtocolVersion.get(grease >> 8, grease & 0xFF));
        Collections.addAll(list, protocolVersions);
        TlsExtensionsUtils.addSupportedVersionsExtensionClient(clientExtensions, list.toArray(new ProtocolVersion[0]));
    }

    protected static void randomExtension(Map<Integer, byte[]> clientExtensions, String order, boolean needGrease) {
        ImpersonatorFactory.randomExtension(clientExtensions, order, (byte[])(needGrease ? TlsUtils.EMPTY_BYTES : null), (byte[])(needGrease ? TlsUtils.EMPTY_BYTES : null));
    }

    protected static void randomExtension(Map<Integer, byte[]> clientExtensions, String order, byte[] firstGreaseData, byte[] lastGreaseData) {
        block5: {
            int random;
            HashMap<Integer, byte[]> copy = new HashMap<Integer, byte[]>(clientExtensions);
            clientExtensions.clear();
            int grease = ImpersonatorFactory.randomGrease();
            if (firstGreaseData != null) {
                clientExtensions.put(grease, firstGreaseData);
            }
            if (order == null) {
                ArrayList keys = new ArrayList(copy.keySet());
                Collections.shuffle(keys);
                for (Integer key : keys) {
                    byte[] data = (byte[])copy.remove(key);
                    clientExtensions.put(key, data);
                }
            } else {
                ImpersonatorFactory.sortExtensions(clientExtensions, copy, order);
            }
            if (lastGreaseData == null) break block5;
            while ((random = ImpersonatorFactory.randomGrease()) == grease) {
            }
            clientExtensions.put(random, lastGreaseData);
        }
    }

    protected static void sortExtensions(Map<Integer, byte[]> clientExtensions, Map<Integer, byte[]> copy, String order) {
        String[] tokens;
        if (copy == null) {
            copy = new HashMap<Integer, byte[]>(clientExtensions);
            clientExtensions.clear();
        }
        for (String token : tokens = order.split("-")) {
            int type = Integer.parseInt(token);
            byte[] data = copy.remove(type);
            if (data == null) continue;
            clientExtensions.put(type, data);
        }
    }

    @Override
    public void onEstablishSession(Map<Integer, byte[]> clientExtensions) throws IOException {
        clientExtensions.put(65281, TlsUtils.encodeOpaque8(TlsUtils.EMPTY_BYTES));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int calcClientHelloMessageLength(ClientHello clientHello) {
        try (ByteArrayOutputStream message = new ByteArrayOutputStream(512);){
            clientHello.encode(null, message);
            int n = message.size() + 4;
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("calcClientHelloMessageLength", e);
        }
    }

    @Override
    public final void onSendClientHelloMessage(ClientHello clientHello, Map<Integer, byte[]> clientExtensions) throws IOException {
        clientExtensions.remove(17);
        clientExtensions.remove(22);
        this.onSendClientHelloMessageInternal(clientExtensions);
        if (this.extensionListener != null) {
            this.extensionListener.onClientExtensionsBuilt(clientHello, clientExtensions);
        }
    }

    @Override
    public void setExtensionListener(ExtensionListener extensionListener) {
        this.extensionListener = extensionListener;
    }

    protected abstract void onSendClientHelloMessageInternal(Map<Integer, byte[]> var1) throws IOException;

    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    protected ImpersonatorFactory(String cipherSuites, String userAgent) {
        this.userAgent = userAgent;
        String[] tokens = cipherSuites.split("-");
        this.cipherSuites = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            int cipherSuite;
            String token = tokens[i];
            this.cipherSuites[i] = "GREASE".equalsIgnoreCase(token) ? ImpersonatorFactory.randomGrease() : (cipherSuite = Integer.parseInt(token));
        }
    }

    public static int randomGrease() {
        return GREASE[ThreadLocalRandom.current().nextInt(GREASE.length)];
    }

    public static boolean isGrease(int value) {
        for (int grease : GREASE) {
            if (grease != value) continue;
            return true;
        }
        return false;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.addProvider(new BouncyCastleJsseProvider());
        GREASE = new int[]{2570, 6682, 10794, 14906, 19018, 23130, 27242, 31354, 35466, 39578, 43690, 47802, 51914, 56026, 60138, 64250};
    }

    public static class DummyX509KeyManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

